// Please see the README file or the LEGAL NOTES-section in the manual before modifying, compiling or using 'xmrm'
//   Idea: Manfred Kopp
//   Programming: Gerhard Waldhr, Andreas Artmann

#ifndef FD_MRM_h_
#define FD_MRM_h_
/* Header file generated with fdesign. */

/**** Callback routines ****/
extern void callback_Buttons(FL_OBJECT *, long);
extern void callback_Sliders(FL_OBJECT *, long);
extern void callback_CheckButtons(FL_OBJECT *, long);
extern void callback_Counters(FL_OBJECT *, long);
extern void callback_Menus(FL_OBJECT *, long);

extern int obj_s_handler(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my,
                         int key, void *xev);
extern int obj_d_handler(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my,
                         int key, void *xev);
extern int obj_vs_handler(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my,
                         int key, void *xev);
extern int obj_vd_handler(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my,
                         int key, void *xev);
                         
extern int obj_m_handler(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my,
                         int key, void *xev);
extern int obj_a_handler(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my,
                         int key, void *xev);
                         
extern int obj_wavelets_handler(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my,
                         int key, void *xev);

extern int obj_akima_handler(FL_OBJECT *obj, int event, FL_Coord mx, FL_Coord my,
                         int key, void *xev);

                         
                        
/**** Forms and Objects ****/
typedef struct {
	FL_FORM *MRM;
	void *vdata;
	long ldata;
	FL_OBJECT *mrm;

	FL_OBJECT *MN_File;
	FL_OBJECT *MN_Wavelet_Type;
	FL_OBJECT *MN_Windows;

	FL_OBJECT *BT_Load_Prj;
	FL_OBJECT *BT_Save_Prj;
	FL_OBJECT *BT_Save_Prj_as;
	FL_OBJECT *BT_Load_Source;
	FL_OBJECT *BT_Load_Dest;
	FL_OBJECT *BT_Load_Area;
	FL_OBJECT *BT_Load_Vecs;
	FL_OBJECT *BT_Save_Vecs;
	FL_OBJECT *BT_Save_Vecs_as;
	FL_OBJECT *BT_Swap_Vecs;
	FL_OBJECT *BT_Del_Vecs;
	FL_OBJECT *BT_About;
	FL_OBJECT *BT_Exit;
	FL_OBJECT *BT_Calculate;
	FL_OBJECT *BT_Animate;
	FL_OBJECT *BT_Load_Anim;
	FL_OBJECT *BT_Filename;
	FL_OBJECT *BT_Create_MPEG;        
//AAA	FL_OBJECT *BT_MPEG_Info;        
	FL_OBJECT *BT_Drop;
	FL_OBJECT *BT_Level[10];
        
	FL_OBJECT *GR_Morph_Mode;
          FL_OBJECT *CB_Simple_Morph;
          FL_OBJECT *CB_Area_Morph;        
          FL_OBJECT *CB_Warp;        
          FL_OBJECT *CB_Animate_Detail;
	FL_OBJECT *GR_Anim_Control;
          FL_OBJECT *CB_Animation;
          FL_OBJECT *CB_Single_Frame;
	FL_OBJECT *GR_Save_From;
          FL_OBJECT *CB_Save_Animation;
          FL_OBJECT *CB_Save_Calculation;        
	FL_OBJECT *CB_Advanced_Mode;                        
	FL_OBJECT *CB_Border_Vecs;
	FL_OBJECT *CB_High_Quality;
	FL_OBJECT *CB_Use_Wavelets;
	FL_OBJECT *CB_Anim_Cycle;        
//AAA	FL_OBJECT *CB_MPEG_Cycle;        

	FL_OBJECT *CT_Level_Select;
	FL_OBJECT *CT_Frames;        
	FL_OBJECT *CT_Frame_Nr;                
	FL_OBJECT *CT_Save_Start;                
	FL_OBJECT *CT_Save_Step;                

	FL_OBJECT *SL_Level_Adjust;
	FL_OBJECT *SL_fps;

	FL_OBJECT *Morph_Plot;
        FL_OBJECT *Wave_Plot_Box;
	FL_OBJECT *Wave_Plot;

	FL_OBJECT *Infoline;
} FD_MRM;
extern FD_MRM * create_form_MRM(void);

typedef struct {
	FL_FORM *MORPH;
	FL_OBJECT *morph;
	void *vdata;
	long ldata;
} FD_MORPH;
extern FD_MORPH * create_form_MORPH(void);

typedef struct {
	FL_FORM *RESULT;
	FL_OBJECT *result;
	void *vdata;
	long ldata;
} FD_RESULT;
extern FD_RESULT * create_form_RESULT(void);

typedef struct {
	FL_FORM *WAIT;
	FL_OBJECT *wait;        
	FL_OBJECT *SL_Progress;
	void *vdata;
	long ldata;
} FD_WAIT;
extern FD_WAIT * create_form_WAIT(void);

typedef struct {
	FL_FORM *CREDITS;
	void *vdata;
	long ldata;
	FL_OBJECT *BT_Drop;
	FL_OBJECT *BT_TU_Logo;
	FL_OBJECT *XPM_xmrm_logo;
} FD_CREDITS;
extern FD_CREDITS * create_form_CREDITS(void);

typedef struct {
	FL_FORM *AREAS;
	FL_OBJECT *areas;
	void *vdata;
	long ldata;
} FD_AREAS;
extern FD_AREAS * create_form_AREAS(void);

typedef struct {
	FL_FORM *SLID_CONTR;
	void *vdata;
	long ldata;
	FL_OBJECT *slid_contr;
	FL_OBJECT *SL_Param_a;
	FL_OBJECT *SL_Param_b;
	FL_OBJECT *SL_Param_p;
	FL_OBJECT *Infoline;    
} FD_SLID_CONTR;
extern FD_SLID_CONTR * create_form_SLID_CONTR(void);

typedef struct {
	FL_FORM *VEC_MENU;
	void *vdata;
	long ldata;
	FL_OBJECT *vec_menu;
	FL_OBJECT *BT_SetVec;
	FL_OBJECT *BT_EditVec;
	FL_OBJECT *BT_SetLines;
	FL_OBJECT *BT_DeleteVec;
} FD_VEC_MENU;
extern FD_VEC_MENU * create_form_VEC_MENU(void);

#endif /* FD_MRM_h_ */
