/*
 * KubeVirt API
 * This is KubeVirt API an add-on for Kubernetes.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: kubevirt-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package kubevirt.io;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import kubevirt.io.V1LocalObjectReference;

/**
 * Represents a cloud-init config drive user data source. More info: https://cloudinit.readthedocs.io/en/latest/topics/datasources/configdrive.html
 */
@ApiModel(description = "Represents a cloud-init config drive user data source. More info: https://cloudinit.readthedocs.io/en/latest/topics/datasources/configdrive.html")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-11-10T14:44:51.030+02:00")
public class V1CloudInitConfigDriveSource {
  @SerializedName("networkData")
  private String networkData = null;

  @SerializedName("networkDataBase64")
  private String networkDataBase64 = null;

  @SerializedName("networkDataSecretRef")
  private V1LocalObjectReference networkDataSecretRef = null;

  @SerializedName("secretRef")
  private V1LocalObjectReference secretRef = null;

  @SerializedName("userData")
  private String userData = null;

  @SerializedName("userDataBase64")
  private String userDataBase64 = null;

  public V1CloudInitConfigDriveSource networkData(String networkData) {
    this.networkData = networkData;
    return this;
  }

   /**
   * NetworkData contains config drive inline cloud-init networkdata. + optional
   * @return networkData
  **/
  @ApiModelProperty(value = "NetworkData contains config drive inline cloud-init networkdata. + optional")
  public String getNetworkData() {
    return networkData;
  }

  public void setNetworkData(String networkData) {
    this.networkData = networkData;
  }

  public V1CloudInitConfigDriveSource networkDataBase64(String networkDataBase64) {
    this.networkDataBase64 = networkDataBase64;
    return this;
  }

   /**
   * NetworkDataBase64 contains config drive cloud-init networkdata as a base64 encoded string. + optional
   * @return networkDataBase64
  **/
  @ApiModelProperty(value = "NetworkDataBase64 contains config drive cloud-init networkdata as a base64 encoded string. + optional")
  public String getNetworkDataBase64() {
    return networkDataBase64;
  }

  public void setNetworkDataBase64(String networkDataBase64) {
    this.networkDataBase64 = networkDataBase64;
  }

  public V1CloudInitConfigDriveSource networkDataSecretRef(V1LocalObjectReference networkDataSecretRef) {
    this.networkDataSecretRef = networkDataSecretRef;
    return this;
  }

   /**
   * NetworkDataSecretRef references a k8s secret that contains config drive networkdata. + optional
   * @return networkDataSecretRef
  **/
  @ApiModelProperty(value = "NetworkDataSecretRef references a k8s secret that contains config drive networkdata. + optional")
  public V1LocalObjectReference getNetworkDataSecretRef() {
    return networkDataSecretRef;
  }

  public void setNetworkDataSecretRef(V1LocalObjectReference networkDataSecretRef) {
    this.networkDataSecretRef = networkDataSecretRef;
  }

  public V1CloudInitConfigDriveSource secretRef(V1LocalObjectReference secretRef) {
    this.secretRef = secretRef;
    return this;
  }

   /**
   * UserDataSecretRef references a k8s secret that contains config drive userdata. + optional
   * @return secretRef
  **/
  @ApiModelProperty(value = "UserDataSecretRef references a k8s secret that contains config drive userdata. + optional")
  public V1LocalObjectReference getSecretRef() {
    return secretRef;
  }

  public void setSecretRef(V1LocalObjectReference secretRef) {
    this.secretRef = secretRef;
  }

  public V1CloudInitConfigDriveSource userData(String userData) {
    this.userData = userData;
    return this;
  }

   /**
   * UserData contains config drive inline cloud-init userdata. + optional
   * @return userData
  **/
  @ApiModelProperty(value = "UserData contains config drive inline cloud-init userdata. + optional")
  public String getUserData() {
    return userData;
  }

  public void setUserData(String userData) {
    this.userData = userData;
  }

  public V1CloudInitConfigDriveSource userDataBase64(String userDataBase64) {
    this.userDataBase64 = userDataBase64;
    return this;
  }

   /**
   * UserDataBase64 contains config drive cloud-init userdata as a base64 encoded string. + optional
   * @return userDataBase64
  **/
  @ApiModelProperty(value = "UserDataBase64 contains config drive cloud-init userdata as a base64 encoded string. + optional")
  public String getUserDataBase64() {
    return userDataBase64;
  }

  public void setUserDataBase64(String userDataBase64) {
    this.userDataBase64 = userDataBase64;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1CloudInitConfigDriveSource v1CloudInitConfigDriveSource = (V1CloudInitConfigDriveSource) o;
    return Objects.equals(this.networkData, v1CloudInitConfigDriveSource.networkData) &&
        Objects.equals(this.networkDataBase64, v1CloudInitConfigDriveSource.networkDataBase64) &&
        Objects.equals(this.networkDataSecretRef, v1CloudInitConfigDriveSource.networkDataSecretRef) &&
        Objects.equals(this.secretRef, v1CloudInitConfigDriveSource.secretRef) &&
        Objects.equals(this.userData, v1CloudInitConfigDriveSource.userData) &&
        Objects.equals(this.userDataBase64, v1CloudInitConfigDriveSource.userDataBase64);
  }

  @Override
  public int hashCode() {
    return Objects.hash(networkData, networkDataBase64, networkDataSecretRef, secretRef, userData, userDataBase64);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1CloudInitConfigDriveSource {\n");
    
    sb.append("    networkData: ").append(toIndentedString(networkData)).append("\n");
    sb.append("    networkDataBase64: ").append(toIndentedString(networkDataBase64)).append("\n");
    sb.append("    networkDataSecretRef: ").append(toIndentedString(networkDataSecretRef)).append("\n");
    sb.append("    secretRef: ").append(toIndentedString(secretRef)).append("\n");
    sb.append("    userData: ").append(toIndentedString(userData)).append("\n");
    sb.append("    userDataBase64: ").append(toIndentedString(userDataBase64)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

