/*
 * KubeVirt API
 * This is KubeVirt API an add-on for Kubernetes.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: kubevirt-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package kubevirt.io;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import kubevirt.io.V1CDRomTarget;
import kubevirt.io.V1DiskTarget;
import kubevirt.io.V1FloppyTarget;
import kubevirt.io.V1LunTarget;

/**
 * V1Disk
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-11-10T14:44:51.030+02:00")
public class V1Disk {
  @SerializedName("bootOrder")
  private Integer bootOrder = null;

  @SerializedName("cache")
  private String cache = null;

  @SerializedName("cdrom")
  private V1CDRomTarget cdrom = null;

  @SerializedName("dedicatedIOThread")
  private Boolean dedicatedIOThread = null;

  @SerializedName("disk")
  private V1DiskTarget disk = null;

  @SerializedName("floppy")
  private V1FloppyTarget floppy = null;

  @SerializedName("lun")
  private V1LunTarget lun = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("serial")
  private String serial = null;

  public V1Disk bootOrder(Integer bootOrder) {
    this.bootOrder = bootOrder;
    return this;
  }

   /**
   * BootOrder is an integer value &gt; 0, used to determine ordering of boot devices. Lower values take precedence. Each disk or interface that has a boot order must have a unique value. Disks without a boot order are not tried if a disk with a boot order exists. +optional
   * @return bootOrder
  **/
  @ApiModelProperty(value = "BootOrder is an integer value > 0, used to determine ordering of boot devices. Lower values take precedence. Each disk or interface that has a boot order must have a unique value. Disks without a boot order are not tried if a disk with a boot order exists. +optional")
  public Integer getBootOrder() {
    return bootOrder;
  }

  public void setBootOrder(Integer bootOrder) {
    this.bootOrder = bootOrder;
  }

  public V1Disk cache(String cache) {
    this.cache = cache;
    return this;
  }

   /**
   * Cache specifies which kvm disk cache mode should be used. +optional
   * @return cache
  **/
  @ApiModelProperty(value = "Cache specifies which kvm disk cache mode should be used. +optional")
  public String getCache() {
    return cache;
  }

  public void setCache(String cache) {
    this.cache = cache;
  }

  public V1Disk cdrom(V1CDRomTarget cdrom) {
    this.cdrom = cdrom;
    return this;
  }

   /**
   * Attach a volume as a cdrom to the vmi.
   * @return cdrom
  **/
  @ApiModelProperty(value = "Attach a volume as a cdrom to the vmi.")
  public V1CDRomTarget getCdrom() {
    return cdrom;
  }

  public void setCdrom(V1CDRomTarget cdrom) {
    this.cdrom = cdrom;
  }

  public V1Disk dedicatedIOThread(Boolean dedicatedIOThread) {
    this.dedicatedIOThread = dedicatedIOThread;
    return this;
  }

   /**
   * dedicatedIOThread indicates this disk should have an exclusive IO Thread. Enabling this implies useIOThreads &#x3D; true. Defaults to false. +optional
   * @return dedicatedIOThread
  **/
  @ApiModelProperty(value = "dedicatedIOThread indicates this disk should have an exclusive IO Thread. Enabling this implies useIOThreads = true. Defaults to false. +optional")
  public Boolean isDedicatedIOThread() {
    return dedicatedIOThread;
  }

  public void setDedicatedIOThread(Boolean dedicatedIOThread) {
    this.dedicatedIOThread = dedicatedIOThread;
  }

  public V1Disk disk(V1DiskTarget disk) {
    this.disk = disk;
    return this;
  }

   /**
   * Attach a volume as a disk to the vmi.
   * @return disk
  **/
  @ApiModelProperty(value = "Attach a volume as a disk to the vmi.")
  public V1DiskTarget getDisk() {
    return disk;
  }

  public void setDisk(V1DiskTarget disk) {
    this.disk = disk;
  }

  public V1Disk floppy(V1FloppyTarget floppy) {
    this.floppy = floppy;
    return this;
  }

   /**
   * Attach a volume as a floppy to the vmi.
   * @return floppy
  **/
  @ApiModelProperty(value = "Attach a volume as a floppy to the vmi.")
  public V1FloppyTarget getFloppy() {
    return floppy;
  }

  public void setFloppy(V1FloppyTarget floppy) {
    this.floppy = floppy;
  }

  public V1Disk lun(V1LunTarget lun) {
    this.lun = lun;
    return this;
  }

   /**
   * Attach a volume as a LUN to the vmi.
   * @return lun
  **/
  @ApiModelProperty(value = "Attach a volume as a LUN to the vmi.")
  public V1LunTarget getLun() {
    return lun;
  }

  public void setLun(V1LunTarget lun) {
    this.lun = lun;
  }

  public V1Disk name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Name is the device name
   * @return name
  **/
  @ApiModelProperty(required = true, value = "Name is the device name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public V1Disk serial(String serial) {
    this.serial = serial;
    return this;
  }

   /**
   * Serial provides the ability to specify a serial number for the disk device. +optional
   * @return serial
  **/
  @ApiModelProperty(value = "Serial provides the ability to specify a serial number for the disk device. +optional")
  public String getSerial() {
    return serial;
  }

  public void setSerial(String serial) {
    this.serial = serial;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1Disk v1Disk = (V1Disk) o;
    return Objects.equals(this.bootOrder, v1Disk.bootOrder) &&
        Objects.equals(this.cache, v1Disk.cache) &&
        Objects.equals(this.cdrom, v1Disk.cdrom) &&
        Objects.equals(this.dedicatedIOThread, v1Disk.dedicatedIOThread) &&
        Objects.equals(this.disk, v1Disk.disk) &&
        Objects.equals(this.floppy, v1Disk.floppy) &&
        Objects.equals(this.lun, v1Disk.lun) &&
        Objects.equals(this.name, v1Disk.name) &&
        Objects.equals(this.serial, v1Disk.serial);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bootOrder, cache, cdrom, dedicatedIOThread, disk, floppy, lun, name, serial);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1Disk {\n");
    
    sb.append("    bootOrder: ").append(toIndentedString(bootOrder)).append("\n");
    sb.append("    cache: ").append(toIndentedString(cache)).append("\n");
    sb.append("    cdrom: ").append(toIndentedString(cdrom)).append("\n");
    sb.append("    dedicatedIOThread: ").append(toIndentedString(dedicatedIOThread)).append("\n");
    sb.append("    disk: ").append(toIndentedString(disk)).append("\n");
    sb.append("    floppy: ").append(toIndentedString(floppy)).append("\n");
    sb.append("    lun: ").append(toIndentedString(lun)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    serial: ").append(toIndentedString(serial)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

