/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.Boolean;
import java.lang.String;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.internal.containers.AffinityGroupContainer;
import org.ovirt.engine.sdk4.types.AffinityGroup;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.Vm;

public class AffinityGroupBuilder {
    private Cluster cluster;
    private String comment;
    private String description;
    private Boolean enforcing;
    private String href;
    private String id;
    private String name;
    private Boolean positive;
    private List<Vm> vms;
    
    public AffinityGroupBuilder cluster(Cluster newCluster) {
        cluster = newCluster;
        return this;
    }
    
    public AffinityGroupBuilder cluster(ClusterBuilder newCluster) {
        if (newCluster == null) {
            cluster = null;
        }
        else {
            cluster = newCluster.build();
        }
        return this;
    }
    
    
    public AffinityGroupBuilder comment(String newComment) {
        comment = newComment;
        return this;
    }
    
    
    public AffinityGroupBuilder description(String newDescription) {
        description = newDescription;
        return this;
    }
    
    
    public AffinityGroupBuilder enforcing(boolean newEnforcing) {
        enforcing = Boolean.valueOf(newEnforcing);
        return this;
    }
    
    public AffinityGroupBuilder enforcing(Boolean newEnforcing) {
        enforcing = newEnforcing;
        return this;
    }
    
    
    public AffinityGroupBuilder href(String newHref) {
        href = newHref;
        return this;
    }
    
    
    public AffinityGroupBuilder id(String newId) {
        id = newId;
        return this;
    }
    
    
    public AffinityGroupBuilder name(String newName) {
        name = newName;
        return this;
    }
    
    
    public AffinityGroupBuilder positive(boolean newPositive) {
        positive = Boolean.valueOf(newPositive);
        return this;
    }
    
    public AffinityGroupBuilder positive(Boolean newPositive) {
        positive = newPositive;
        return this;
    }
    
    
    public AffinityGroupBuilder vms(List<Vm> newVms) {
        if (newVms != null) {
            if (vms == null) {
                vms = new ArrayList<>(newVms);
            }
            else {
                vms.addAll(newVms);
            }
        }
        return this;
    }
    
    public AffinityGroupBuilder vms(Vm... newVms) {
        if (newVms != null) {
            if (vms == null) {
                vms = new ArrayList<>(newVms.length);
            }
            Collections.addAll(vms, newVms);
        }
        return this;
    }
    
    public AffinityGroupBuilder vms(VmBuilder... newVms) {
        if (newVms != null) {
            if (vms == null) {
                vms = new ArrayList<>(newVms.length);
            }
            for (VmBuilder builder : newVms) {
                vms.add(builder.build());
            }
        }
        return this;
    }
    
    
    public AffinityGroup build() {
        AffinityGroupContainer container = new AffinityGroupContainer();
        container.cluster(cluster);
        container.comment(comment);
        container.description(description);
        container.enforcing(enforcing);
        container.href(href);
        container.id(id);
        container.name(name);
        container.positive(positive);
        container.vms(vms);
        return container;
    }
}
