/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.VmPoolBuilder;
import org.ovirt.engine.sdk4.types.VmPool;

public interface VmPoolService extends Service {
    /**
     * This operation allocates a virtual machine in the virtual machine pool.
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/vmpools/123/allocatevm
     * ----
     * 
     * The allocate virtual machine action does not take any action specific parameters, so the request body should
     * contain an empty `action`:
     * 
     * [source,xml]
     * ----
     * <action/>
     * ----
     */
    public interface AllocateVmRequest extends Request<AllocateVmRequest, AllocateVmResponse> {
        /**
         * Indicates if the allocation should be performed asynchronously.
         */
        AllocateVmRequest async(Boolean async);
    }
    
    /**
     * This operation allocates a virtual machine in the virtual machine pool.
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/vmpools/123/allocatevm
     * ----
     * 
     * The allocate virtual machine action does not take any action specific parameters, so the request body should
     * contain an empty `action`:
     * 
     * [source,xml]
     * ----
     * <action/>
     * ----
     */
    public interface AllocateVmResponse extends Response {
    }
    
    /**
     * This operation allocates a virtual machine in the virtual machine pool.
     * 
     * [source]
     * ----
     * POST /ovirt-engine/api/vmpools/123/allocatevm
     * ----
     * 
     * The allocate virtual machine action does not take any action specific parameters, so the request body should
     * contain an empty `action`:
     * 
     * [source,xml]
     * ----
     * <action/>
     * ----
     */
    AllocateVmRequest allocateVm();
    
    public interface GetRequest extends Request<GetRequest, GetResponse> {
        /**
         * Indicates if the results should be filtered according to the permissions of the user.
         */
        GetRequest filter(Boolean filter);
    }
    
    public interface GetResponse extends Response {
        VmPool pool();
    }
    
    GetRequest get();
    
    /**
     * Removes a virtual machine pool.
     * 
     * [source]
     * ----
     * DELETE /ovirt-engine/api/vmpools/123
     * ----
     */
    public interface RemoveRequest extends Request<RemoveRequest, RemoveResponse> {
        /**
         * Indicates if the remove should be performed asynchronously.
         */
        RemoveRequest async(Boolean async);
    }
    
    /**
     * Removes a virtual machine pool.
     * 
     * [source]
     * ----
     * DELETE /ovirt-engine/api/vmpools/123
     * ----
     */
    public interface RemoveResponse extends Response {
    }
    
    /**
     * Removes a virtual machine pool.
     * 
     * [source]
     * ----
     * DELETE /ovirt-engine/api/vmpools/123
     * ----
     */
    RemoveRequest remove();
    
    /**
     * Update the virtual machine pool.
     * 
     * [source]
     * ----
     * PUT /ovirt-engine/api/vmpools/123
     * ----
     * 
     * The `name`, `description`, `size`, `prestarted_vms` and `max_user_vms`
     * attributes can be updated after the virtual machine pool has been
     * created.
     * 
     * [source,xml]
     * ----
     * <vmpool>
     *   <name>VM_Pool_B</name>
     *   <description>Virtual Machine Pool B</description>
     *   <size>3</size>
     *   <prestarted_vms>1</size>
     *   <max_user_vms>2</size>
     * </vmpool>
     * ----
     */
    public interface UpdateRequest extends Request<UpdateRequest, UpdateResponse> {
        /**
         * Indicates if the update should be performed asynchronously.
         */
        UpdateRequest async(Boolean async);
        UpdateRequest pool(VmPool pool);
        /**
         * The virtual machine pool that is being updated.
         */
        UpdateRequest pool(VmPoolBuilder pool);
    }
    
    /**
     * Update the virtual machine pool.
     * 
     * [source]
     * ----
     * PUT /ovirt-engine/api/vmpools/123
     * ----
     * 
     * The `name`, `description`, `size`, `prestarted_vms` and `max_user_vms`
     * attributes can be updated after the virtual machine pool has been
     * created.
     * 
     * [source,xml]
     * ----
     * <vmpool>
     *   <name>VM_Pool_B</name>
     *   <description>Virtual Machine Pool B</description>
     *   <size>3</size>
     *   <prestarted_vms>1</size>
     *   <max_user_vms>2</size>
     * </vmpool>
     * ----
     */
    public interface UpdateResponse extends Response {
        /**
         * The virtual machine pool that is being updated.
         */
        VmPool pool();
    }
    
    /**
     * Update the virtual machine pool.
     * 
     * [source]
     * ----
     * PUT /ovirt-engine/api/vmpools/123
     * ----
     * 
     * The `name`, `description`, `size`, `prestarted_vms` and `max_user_vms`
     * attributes can be updated after the virtual machine pool has been
     * created.
     * 
     * [source,xml]
     * ----
     * <vmpool>
     *   <name>VM_Pool_B</name>
     *   <description>Virtual Machine Pool B</description>
     *   <size>3</size>
     *   <prestarted_vms>1</size>
     *   <max_user_vms>2</size>
     * </vmpool>
     * ----
     */
    UpdateRequest update();
    
    AssignedPermissionsService permissionsService();
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

