/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.TicketContainer;
import org.ovirt.engine.sdk4.types.Ticket;

public class XmlTicketReader {
    public static Ticket readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        TicketContainer object = new TicketContainer();
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block10: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "expiry": {
                    object.expiry(reader.readInteger());
                    continue block10;
                }
                case "value": {
                    object.value(reader.readString());
                    continue block10;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block10;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlTicketReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Ticket> iterateMany(final XmlReader reader) {
        return new Iterator<Ticket>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Ticket next() {
                Ticket next = XmlTicketReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Ticket> readMany(XmlReader reader) {
        ArrayList<Ticket> list = new ArrayList<Ticket>();
        Iterator<Ticket> iterator = XmlTicketReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(TicketContainer object, String[] link) {
    }
}

