/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import org.ovirt.engine.sdk4.internal.containers.IpAddressAssignmentContainer;
import org.ovirt.engine.sdk4.types.BootProtocol;
import org.ovirt.engine.sdk4.types.Ip;
import org.ovirt.engine.sdk4.types.IpAddressAssignment;

public class IpAddressAssignmentBuilder {
    private BootProtocol assignmentMethod;
    private Ip ip;
    
    public IpAddressAssignmentBuilder assignmentMethod(BootProtocol newAssignmentMethod) {
        assignmentMethod = newAssignmentMethod;
        return this;
    }
    
    
    public IpAddressAssignmentBuilder ip(Ip newIp) {
        ip = newIp;
        return this;
    }
    
    public IpAddressAssignmentBuilder ip(IpBuilder newIp) {
        if (newIp == null) {
            ip = null;
        }
        else {
            ip = newIp.build();
        }
        return this;
    }
    
    
    public IpAddressAssignment build() {
        IpAddressAssignmentContainer container = new IpAddressAssignmentContainer();
        container.assignmentMethod(assignmentMethod);
        container.ip(ip);
        return container;
    }
}
