/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ImageTransferPhase {
    UNKNOWN,
    INITIALIZING,
    TRANSFERRING,
    RESUMING,
    PAUSED_SYSTEM,
    PAUSED_USER,
    CANCELLED,
    FINALIZING_SUCCESS,
    FINALIZING_FAILURE,
    FINISHED_SUCCESS,
    FINISHED_FAILURE;

    private static final Logger LOG;

    public String value() {
        return this.name().toLowerCase();
    }

    public static ImageTransferPhase fromValue(String value) {
        try {
            return ImageTransferPhase.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.error("The string '" + value + "' isn't a valid value for the 'ImageTransferPhase' enumerated type. Valid values are: 'unknown', 'initializing', 'transferring', 'resuming', 'paused_system', 'paused_user', 'cancelled', 'finalizing_success', 'finalizing_failure', 'finished_success', 'finished_failure'.");
            return null;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(ImageTransferPhase.class);
    }
}

