/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import org.ovirt.engine.sdk4.types.Fault;

public class FaultContainer extends Container implements Fault {
    private String detail;
    private String reason;
    
    public String detail() {
        return detail;
    }
    
    public void detail(String newDetail) {
        detail = newDetail;
    }
    
    public boolean detailPresent() {
        return detail != null;
    }
    
    public String reason() {
        return reason;
    }
    
    public void reason(String newReason) {
        reason = newReason;
    }
    
    public boolean reasonPresent() {
        return reason != null;
    }
    
}
