/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.LogicalUnitContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlLunStatusReader;
import org.ovirt.engine.sdk4.types.LogicalUnit;

public class XmlLogicalUnitReader {
    public static LogicalUnit readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        LogicalUnitContainer object = new LogicalUnitContainer();
        block48: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "id": {
                    object.id(image);
                    continue block48;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block49: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "address": {
                    object.address(reader.readString());
                    continue block49;
                }
                case "discard_max_size": {
                    object.discardMaxSize(reader.readInteger());
                    continue block49;
                }
                case "discard_zeroes_data": {
                    object.discardZeroesData(reader.readBoolean());
                    continue block49;
                }
                case "disk_id": {
                    object.diskId(reader.readString());
                    continue block49;
                }
                case "lun_mapping": {
                    object.lunMapping(reader.readInteger());
                    continue block49;
                }
                case "password": {
                    object.password(reader.readString());
                    continue block49;
                }
                case "paths": {
                    object.paths(reader.readInteger());
                    continue block49;
                }
                case "port": {
                    object.port(reader.readInteger());
                    continue block49;
                }
                case "portal": {
                    object.portal(reader.readString());
                    continue block49;
                }
                case "product_id": {
                    object.productId(reader.readString());
                    continue block49;
                }
                case "serial": {
                    object.serial(reader.readString());
                    continue block49;
                }
                case "size": {
                    object.size(reader.readInteger());
                    continue block49;
                }
                case "status": {
                    object.status(XmlLunStatusReader.readOne(reader));
                    continue block49;
                }
                case "storage_domain_id": {
                    object.storageDomainId(reader.readString());
                    continue block49;
                }
                case "target": {
                    object.target(reader.readString());
                    continue block49;
                }
                case "username": {
                    object.username(reader.readString());
                    continue block49;
                }
                case "vendor_id": {
                    object.vendorId(reader.readString());
                    continue block49;
                }
                case "volume_group_id": {
                    object.volumeGroupId(reader.readString());
                    continue block49;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block49;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlLogicalUnitReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<LogicalUnit> iterateMany(final XmlReader reader) {
        return new Iterator<LogicalUnit>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public LogicalUnit next() {
                LogicalUnit next = XmlLogicalUnitReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<LogicalUnit> readMany(XmlReader reader) {
        ArrayList<LogicalUnit> list = new ArrayList<LogicalUnit>();
        Iterator<LogicalUnit> iterator = XmlLogicalUnitReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(LogicalUnitContainer object, String[] link) {
    }
}

