/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.services;

import java.io.IOException;
import java.util.List;
import org.ovirt.engine.sdk4.Request;
import org.ovirt.engine.sdk4.Response;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ImageTransferBuilder;
import org.ovirt.engine.sdk4.types.ImageTransfer;

/**
 * This service manages image transfers, for performing Image I/O API in {product-name}.
 * Please refer to <<services/image_transfer, image transfer>> for further
 * documentation.
 */
public interface ImageTransfersService extends Service {
    /**
     * Add a new image transfer. An image, disk or disk snapshot needs to be specified
     * in order to make a new transfer.
     * 
     * IMPORTANT: The `image` attribute is deprecated since version 4.2 of the engine.
     * Use the `disk` or `snapshot` attributes instead.
     */
    public interface AddRequest extends Request<AddRequest, AddResponse> {
        AddRequest imageTransfer(ImageTransfer imageTransfer);
        AddRequest imageTransfer(ImageTransferBuilder imageTransfer);
    }
    
    /**
     * Add a new image transfer. An image, disk or disk snapshot needs to be specified
     * in order to make a new transfer.
     * 
     * IMPORTANT: The `image` attribute is deprecated since version 4.2 of the engine.
     * Use the `disk` or `snapshot` attributes instead.
     */
    public interface AddResponse extends Response {
        ImageTransfer imageTransfer();
    }
    
    /**
     * Add a new image transfer. An image, disk or disk snapshot needs to be specified
     * in order to make a new transfer.
     * 
     * IMPORTANT: The `image` attribute is deprecated since version 4.2 of the engine.
     * Use the `disk` or `snapshot` attributes instead.
     */
    AddRequest add();
    
    public interface AddForDiskRequest extends Request<AddForDiskRequest, AddForDiskResponse> {
        AddForDiskRequest imageTransfer(ImageTransfer imageTransfer);
        AddForDiskRequest imageTransfer(ImageTransferBuilder imageTransfer);
    }
    
    public interface AddForDiskResponse extends Response {
        ImageTransfer imageTransfer();
    }
    
    AddForDiskRequest addForDisk();
    
    public interface AddForImageRequest extends Request<AddForImageRequest, AddForImageResponse> {
        AddForImageRequest imageTransfer(ImageTransfer imageTransfer);
        AddForImageRequest imageTransfer(ImageTransferBuilder imageTransfer);
    }
    
    public interface AddForImageResponse extends Response {
        ImageTransfer imageTransfer();
    }
    
    AddForImageRequest addForImage();
    
    public interface AddForSnapshotRequest extends Request<AddForSnapshotRequest, AddForSnapshotResponse> {
        AddForSnapshotRequest imageTransfer(ImageTransfer imageTransfer);
        AddForSnapshotRequest imageTransfer(ImageTransferBuilder imageTransfer);
    }
    
    public interface AddForSnapshotResponse extends Response {
        ImageTransfer imageTransfer();
    }
    
    AddForSnapshotRequest addForSnapshot();
    
    /**
     * Retrieves the list of image transfers that are currently
     * being performed.
     * 
     * The order of the returned list of image transfers is not guaranteed.
     */
    public interface ListRequest extends Request<ListRequest, ListResponse> {
        /**
         * Indicates which inner links should be _followed_. The objects referenced by these links will be fetched as part
         * of the current request. See <<documents/003_common_concepts/follow, here>> for details.
         */
        ListRequest follow(String follow);
    }
    
    /**
     * Retrieves the list of image transfers that are currently
     * being performed.
     * 
     * The order of the returned list of image transfers is not guaranteed.
     */
    public interface ListResponse extends Response {
        List<ImageTransfer> imageTransfer();
    }
    
    /**
     * Retrieves the list of image transfers that are currently
     * being performed.
     * 
     * The order of the returned list of image transfers is not guaranteed.
     */
    ListRequest list();
    
    /**
     * Returns a reference to the service that manages an
     * specific image transfer.
     */
    ImageTransferService imageTransferService(String id);
    /**
     * Service locator method, returns individual service on which the URI is dispatched.
     */
    Service service(String path);
}

