/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.ClusterFeatureBuilder;
import org.ovirt.engine.sdk4.builders.CpuTypeBuilder;
import org.ovirt.engine.sdk4.builders.PermitBuilder;
import org.ovirt.engine.sdk4.internal.containers.ClusterLevelContainer;
import org.ovirt.engine.sdk4.types.ClusterFeature;
import org.ovirt.engine.sdk4.types.ClusterLevel;
import org.ovirt.engine.sdk4.types.CpuType;
import org.ovirt.engine.sdk4.types.Permit;

public class ClusterLevelBuilder {
    private List<ClusterFeature> clusterFeatures;
    private String comment;
    private List<CpuType> cpuTypes;
    private String description;
    private String href;
    private String id;
    private String name;
    private List<Permit> permits;

    public ClusterLevelBuilder clusterFeatures(List<ClusterFeature> newClusterFeatures) {
        if (newClusterFeatures != null) {
            if (this.clusterFeatures == null) {
                this.clusterFeatures = new ArrayList<ClusterFeature>(newClusterFeatures);
            } else {
                this.clusterFeatures.addAll(newClusterFeatures);
            }
        }
        return this;
    }

    public ClusterLevelBuilder clusterFeatures(ClusterFeature ... newClusterFeatures) {
        if (newClusterFeatures != null) {
            if (this.clusterFeatures == null) {
                this.clusterFeatures = new ArrayList<ClusterFeature>(newClusterFeatures.length);
            }
            Collections.addAll(this.clusterFeatures, newClusterFeatures);
        }
        return this;
    }

    public ClusterLevelBuilder clusterFeatures(ClusterFeatureBuilder ... newClusterFeatures) {
        if (newClusterFeatures != null) {
            if (this.clusterFeatures == null) {
                this.clusterFeatures = new ArrayList<ClusterFeature>(newClusterFeatures.length);
            }
            for (ClusterFeatureBuilder builder : newClusterFeatures) {
                this.clusterFeatures.add(builder.build());
            }
        }
        return this;
    }

    public ClusterLevelBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public ClusterLevelBuilder cpuTypes(List<CpuType> newCpuTypes) {
        if (newCpuTypes != null) {
            if (this.cpuTypes == null) {
                this.cpuTypes = new ArrayList<CpuType>(newCpuTypes);
            } else {
                this.cpuTypes.addAll(newCpuTypes);
            }
        }
        return this;
    }

    public ClusterLevelBuilder cpuTypes(CpuType ... newCpuTypes) {
        if (newCpuTypes != null) {
            if (this.cpuTypes == null) {
                this.cpuTypes = new ArrayList<CpuType>(newCpuTypes.length);
            }
            Collections.addAll(this.cpuTypes, newCpuTypes);
        }
        return this;
    }

    public ClusterLevelBuilder cpuTypes(CpuTypeBuilder ... newCpuTypes) {
        if (newCpuTypes != null) {
            if (this.cpuTypes == null) {
                this.cpuTypes = new ArrayList<CpuType>(newCpuTypes.length);
            }
            for (CpuTypeBuilder builder : newCpuTypes) {
                this.cpuTypes.add(builder.build());
            }
        }
        return this;
    }

    public ClusterLevelBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public ClusterLevelBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public ClusterLevelBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public ClusterLevelBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public ClusterLevelBuilder permits(List<Permit> newPermits) {
        if (newPermits != null) {
            if (this.permits == null) {
                this.permits = new ArrayList<Permit>(newPermits);
            } else {
                this.permits.addAll(newPermits);
            }
        }
        return this;
    }

    public ClusterLevelBuilder permits(Permit ... newPermits) {
        if (newPermits != null) {
            if (this.permits == null) {
                this.permits = new ArrayList<Permit>(newPermits.length);
            }
            Collections.addAll(this.permits, newPermits);
        }
        return this;
    }

    public ClusterLevelBuilder permits(PermitBuilder ... newPermits) {
        if (newPermits != null) {
            if (this.permits == null) {
                this.permits = new ArrayList<Permit>(newPermits.length);
            }
            for (PermitBuilder builder : newPermits) {
                this.permits.add(builder.build());
            }
        }
        return this;
    }

    public ClusterLevel build() {
        ClusterLevelContainer container = new ClusterLevelContainer();
        container.clusterFeatures(this.clusterFeatures);
        container.comment(this.comment);
        container.cpuTypes(this.cpuTypes);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.permits(this.permits);
        return container;
    }
}

