/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import org.ovirt.engine.sdk4.internal.containers.VnicProfileMappingContainer;
import org.ovirt.engine.sdk4.types.VnicProfile;
import org.ovirt.engine.sdk4.types.VnicProfileMapping;

public class VnicProfileMappingBuilder {
    private String sourceNetworkName;
    private String sourceNetworkProfileName;
    private VnicProfile targetVnicProfile;
    
    public VnicProfileMappingBuilder sourceNetworkName(String newSourceNetworkName) {
        sourceNetworkName = newSourceNetworkName;
        return this;
    }
    
    
    public VnicProfileMappingBuilder sourceNetworkProfileName(String newSourceNetworkProfileName) {
        sourceNetworkProfileName = newSourceNetworkProfileName;
        return this;
    }
    
    
    public VnicProfileMappingBuilder targetVnicProfile(VnicProfile newTargetVnicProfile) {
        targetVnicProfile = newTargetVnicProfile;
        return this;
    }
    
    public VnicProfileMappingBuilder targetVnicProfile(VnicProfileBuilder newTargetVnicProfile) {
        if (newTargetVnicProfile == null) {
            targetVnicProfile = null;
        }
        else {
            targetVnicProfile = newTargetVnicProfile.build();
        }
        return this;
    }
    
    
    public VnicProfileMapping build() {
        VnicProfileMappingContainer container = new VnicProfileMappingContainer();
        container.sourceNetworkName(sourceNetworkName);
        container.sourceNetworkProfileName(sourceNetworkProfileName);
        container.targetVnicProfile(targetVnicProfile);
        return container;
    }
}
