/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;
import java.math.BigInteger;
import java.util.List;

public interface GlusterBrickAdvancedDetails extends Device {
    String device();
    
    boolean devicePresent();
    
    String fsName();
    
    boolean fsNamePresent();
    
    List<GlusterClient> glusterClients();
    
    boolean glusterClientsPresent();
    
    List<GlusterMemoryPool> memoryPools();
    
    boolean memoryPoolsPresent();
    
    String mntOptions();
    
    boolean mntOptionsPresent();
    
    BigInteger pid();
    Byte pidAsByte();
    Short pidAsShort();
    Integer pidAsInteger();
    Long pidAsLong();
    
    boolean pidPresent();
    
    BigInteger port();
    Byte portAsByte();
    Short portAsShort();
    Integer portAsInteger();
    Long portAsLong();
    
    boolean portPresent();
    
}
