/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.DnsBuilder;
import org.ovirt.engine.sdk4.builders.NicBuilder;
import org.ovirt.engine.sdk4.internal.containers.NetworkConfigurationContainer;
import org.ovirt.engine.sdk4.types.Dns;
import org.ovirt.engine.sdk4.types.NetworkConfiguration;
import org.ovirt.engine.sdk4.types.Nic;

public class NetworkConfigurationBuilder {
    private Dns dns;
    private List<Nic> nics;

    public NetworkConfigurationBuilder dns(Dns newDns) {
        this.dns = newDns;
        return this;
    }

    public NetworkConfigurationBuilder dns(DnsBuilder newDns) {
        this.dns = newDns == null ? null : newDns.build();
        return this;
    }

    public NetworkConfigurationBuilder nics(List<Nic> newNics) {
        if (newNics != null) {
            if (this.nics == null) {
                this.nics = new ArrayList<Nic>(newNics);
            } else {
                this.nics.addAll(newNics);
            }
        }
        return this;
    }

    public NetworkConfigurationBuilder nics(Nic ... newNics) {
        if (newNics != null) {
            if (this.nics == null) {
                this.nics = new ArrayList<Nic>(newNics.length);
            }
            Collections.addAll(this.nics, newNics);
        }
        return this;
    }

    public NetworkConfigurationBuilder nics(NicBuilder ... newNics) {
        if (newNics != null) {
            if (this.nics == null) {
                this.nics = new ArrayList<Nic>(newNics.length);
            }
            for (NicBuilder builder : newNics) {
                this.nics.add(builder.build());
            }
        }
        return this;
    }

    public NetworkConfiguration build() {
        NetworkConfigurationContainer container = new NetworkConfigurationContainer();
        container.dns(this.dns);
        container.nics(this.nics);
        return container;
    }
}

