/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import org.ovirt.engine.sdk4.internal.containers.NetworkFilterParameterContainer;
import org.ovirt.engine.sdk4.types.NetworkFilterParameter;
import org.ovirt.engine.sdk4.types.Nic;

public class NetworkFilterParameterBuilder {
    private String comment;
    private String description;
    private String href;
    private String id;
    private String name;
    private Nic nic;
    private String value;
    
    public NetworkFilterParameterBuilder comment(String newComment) {
        comment = newComment;
        return this;
    }
    
    
    public NetworkFilterParameterBuilder description(String newDescription) {
        description = newDescription;
        return this;
    }
    
    
    public NetworkFilterParameterBuilder href(String newHref) {
        href = newHref;
        return this;
    }
    
    
    public NetworkFilterParameterBuilder id(String newId) {
        id = newId;
        return this;
    }
    
    
    public NetworkFilterParameterBuilder name(String newName) {
        name = newName;
        return this;
    }
    
    
    public NetworkFilterParameterBuilder nic(Nic newNic) {
        nic = newNic;
        return this;
    }
    
    public NetworkFilterParameterBuilder nic(NicBuilder newNic) {
        if (newNic == null) {
            nic = null;
        }
        else {
            nic = newNic.build();
        }
        return this;
    }
    
    
    public NetworkFilterParameterBuilder value(String newValue) {
        value = newValue;
        return this;
    }
    
    
    public NetworkFilterParameter build() {
        NetworkFilterParameterContainer container = new NetworkFilterParameterContainer();
        container.comment(comment);
        container.description(description);
        container.href(href);
        container.id(id);
        container.name(name);
        container.nic(nic);
        container.value(value);
        return container;
    }
}
