/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.RoleBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.PermitsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlRoleReader;
import org.ovirt.engine.sdk4.internal.xml.XmlRoleWriter;
import org.ovirt.engine.sdk4.services.PermitsService;
import org.ovirt.engine.sdk4.services.RoleService;
import org.ovirt.engine.sdk4.types.Role;

public class RoleServiceImpl
extends ServiceImpl
implements RoleService {
    public RoleServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public RoleService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public RoleService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public RoleService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public PermitsService permitsService() {
        return new PermitsServiceImpl(this.getConnection(), this.getPath() + "/permits");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("permits")) {
            return this.permitsService();
        }
        if (path.startsWith("permits/")) {
            return this.permitsService().service(path.substring(8));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "RoleService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements RoleService.UpdateResponse {
        private Role role;

        private UpdateResponseImpl() {
        }

        public void role(Role role) {
            this.role = role;
        }

        @Override
        public Role role() {
            return this.role;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<RoleService.UpdateRequest, RoleService.UpdateResponse>
    implements RoleService.UpdateRequest {
        private Boolean async;
        private Role role;

        private UpdateRequestImpl() {
        }

        @Override
        public RoleService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public RoleService.UpdateRequest role(Role role) {
            this.role = role;
            return this;
        }

        @Override
        public RoleService.UpdateRequest role(RoleBuilder role) {
            this.role = role.build();
            return this;
        }

        @Override
        public RoleService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(RoleServiceImpl.this.getConnection().getUrl() + RoleServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlRoleWriter.writeOne(this.role, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = RoleServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.role(XmlRoleReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            RoleServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements RoleService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<RoleService.RemoveRequest, RoleService.RemoveResponse>
    implements RoleService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public RoleService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public RoleService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(RoleServiceImpl.this.getConnection().getUrl() + RoleServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = RoleServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            RoleServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements RoleService.GetResponse {
        private Role role;

        private GetResponseImpl() {
        }

        public void role(Role role) {
            this.role = role;
        }

        @Override
        public Role role() {
            return this.role;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<RoleService.GetRequest, RoleService.GetResponse>
    implements RoleService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public RoleService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public RoleService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(RoleServiceImpl.this.getConnection().getUrl() + RoleServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = RoleServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.role(XmlRoleReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            RoleServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

