/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.Boolean;
import java.util.List;
import org.ovirt.engine.sdk4.types.Permit;
import org.ovirt.engine.sdk4.types.Role;
import org.ovirt.engine.sdk4.types.User;

public class RoleContainer extends IdentifiedContainer implements Role {
    private Boolean administrative;
    private Boolean mutable;
    private List<Permit> permits;
    private User user;
    
    public boolean administrative() {
        return administrative;
    }
    
    public void administrative(boolean newAdministrative) {
        administrative = Boolean.valueOf(newAdministrative);
    }
    
    public void administrative(Boolean newAdministrative) {
        administrative = newAdministrative;
    }
    
    public boolean administrativePresent() {
        return administrative != null;
    }
    
    public boolean mutable() {
        return mutable;
    }
    
    public void mutable(boolean newMutable) {
        mutable = Boolean.valueOf(newMutable);
    }
    
    public void mutable(Boolean newMutable) {
        mutable = newMutable;
    }
    
    public boolean mutablePresent() {
        return mutable != null;
    }
    
    public List<Permit> permits() {
        return makeUnmodifiableList(permits);
    }
    
    public void permits(List<Permit> newPermits) {
        permits = makeArrayList(newPermits);
    }
    
    public boolean permitsPresent() {
        return permits != null && !permits.isEmpty();
    }
    
    public User user() {
        return user;
    }
    
    public void user(User newUser) {
        user = newUser;
    }
    
    public boolean userPresent() {
        return user != null;
    }
    
}
