/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.GlusterVolumeBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.GlusterVolumeServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlGlusterVolumeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlGlusterVolumeWriter;
import org.ovirt.engine.sdk4.services.GlusterVolumeService;
import org.ovirt.engine.sdk4.services.GlusterVolumesService;
import org.ovirt.engine.sdk4.types.GlusterVolume;

public class GlusterVolumesServiceImpl
extends ServiceImpl
implements GlusterVolumesService {
    public GlusterVolumesServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public GlusterVolumesService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public GlusterVolumesService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public GlusterVolumeService volumeService(String id) {
        return new GlusterVolumeServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.volumeService(path);
        }
        return this.volumeService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "GlusterVolumesService:" + this.getPath();
    }

    private class ListResponseImpl
    implements GlusterVolumesService.ListResponse {
        private List<GlusterVolume> volumes;

        private ListResponseImpl() {
        }

        public void volumes(List<GlusterVolume> volumes) {
            this.volumes = volumes;
        }

        @Override
        public List<GlusterVolume> volumes() {
            return this.volumes;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<GlusterVolumesService.ListRequest, GlusterVolumesService.ListResponse>
    implements GlusterVolumesService.ListRequest {
        private Boolean caseSensitive;
        private String follow;
        private BigInteger max;
        private String search;

        private ListRequestImpl() {
        }

        @Override
        public GlusterVolumesService.ListRequest caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        @Override
        public GlusterVolumesService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public GlusterVolumesService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public GlusterVolumesService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public GlusterVolumesService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public GlusterVolumesService.ListRequest search(String search) {
            this.search = search;
            return this;
        }

        @Override
        public GlusterVolumesService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(GlusterVolumesServiceImpl.this.getConnection().getUrl() + GlusterVolumesServiceImpl.this.getPath());
                if (this.caseSensitive != null) {
                    uriBuilder.addParameter("case_sensitive", XmlWriter.renderBoolean(this.caseSensitive));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.search != null) {
                    uriBuilder.addParameter("search", XmlWriter.renderString(this.search));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = GlusterVolumesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.volumes(XmlGlusterVolumeReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            GlusterVolumesServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements GlusterVolumesService.AddResponse {
        private GlusterVolume volume;

        private AddResponseImpl() {
        }

        public void volume(GlusterVolume volume) {
            this.volume = volume;
        }

        @Override
        public GlusterVolume volume() {
            return this.volume;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<GlusterVolumesService.AddRequest, GlusterVolumesService.AddResponse>
    implements GlusterVolumesService.AddRequest {
        private GlusterVolume volume;

        private AddRequestImpl() {
        }

        @Override
        public GlusterVolumesService.AddRequest volume(GlusterVolume volume) {
            this.volume = volume;
            return this;
        }

        @Override
        public GlusterVolumesService.AddRequest volume(GlusterVolumeBuilder volume) {
            this.volume = volume.build();
            return this;
        }

        @Override
        public GlusterVolumesService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(GlusterVolumesServiceImpl.this.getConnection().getUrl() + GlusterVolumesServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlGlusterVolumeWriter.writeOne(this.volume, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = GlusterVolumesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.volume(XmlGlusterVolumeReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            GlusterVolumesServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

