/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.StorageServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlHostStorageReader;
import org.ovirt.engine.sdk4.services.HostStorageService;
import org.ovirt.engine.sdk4.services.StorageService;
import org.ovirt.engine.sdk4.types.HostStorage;

public class HostStorageServiceImpl
extends ServiceImpl
implements HostStorageService {
    public HostStorageServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public HostStorageService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public StorageService storageService(String id) {
        return new StorageServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.storageService(path);
        }
        return this.storageService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "HostStorageService:" + this.getPath();
    }

    private class ListResponseImpl
    implements HostStorageService.ListResponse {
        private List<HostStorage> storages;

        private ListResponseImpl() {
        }

        public void storages(List<HostStorage> storages) {
            this.storages = storages;
        }

        @Override
        public List<HostStorage> storages() {
            return this.storages;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<HostStorageService.ListRequest, HostStorageService.ListResponse>
    implements HostStorageService.ListRequest {
        private String follow;
        private Boolean reportStatus;

        private ListRequestImpl() {
        }

        @Override
        public HostStorageService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public HostStorageService.ListRequest reportStatus(Boolean reportStatus) {
            this.reportStatus = reportStatus;
            return this;
        }

        @Override
        public HostStorageService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(HostStorageServiceImpl.this.getConnection().getUrl() + HostStorageServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.reportStatus != null) {
                    uriBuilder.addParameter("report_status", XmlWriter.renderBoolean(this.reportStatus));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = HostStorageServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.storages(XmlHostStorageReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            HostStorageServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }
}

