/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.DiskBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.StorageDomainDiskServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskWriter;
import org.ovirt.engine.sdk4.services.StorageDomainDiskService;
import org.ovirt.engine.sdk4.services.StorageDomainDisksService;
import org.ovirt.engine.sdk4.types.Disk;

public class StorageDomainDisksServiceImpl
extends ServiceImpl
implements StorageDomainDisksService {
    public StorageDomainDisksServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public StorageDomainDisksService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public StorageDomainDisksService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public StorageDomainDiskService diskService(String id) {
        return new StorageDomainDiskServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.diskService(path);
        }
        return this.diskService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "StorageDomainDisksService:" + this.getPath();
    }

    private class ListResponseImpl
    implements StorageDomainDisksService.ListResponse {
        private List<Disk> disks;

        private ListResponseImpl() {
        }

        public void disks(List<Disk> disks) {
            this.disks = disks;
        }

        @Override
        public List<Disk> disks() {
            return this.disks;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<StorageDomainDisksService.ListRequest, StorageDomainDisksService.ListResponse>
    implements StorageDomainDisksService.ListRequest {
        private String follow;
        private BigInteger max;
        private Boolean unregistered;

        private ListRequestImpl() {
        }

        @Override
        public StorageDomainDisksService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public StorageDomainDisksService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public StorageDomainDisksService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public StorageDomainDisksService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public StorageDomainDisksService.ListRequest unregistered(Boolean unregistered) {
            this.unregistered = unregistered;
            return this;
        }

        @Override
        public StorageDomainDisksService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageDomainDisksServiceImpl.this.getConnection().getUrl() + StorageDomainDisksServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.unregistered != null) {
                    uriBuilder.addParameter("unregistered", XmlWriter.renderBoolean(this.unregistered));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageDomainDisksServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.disks(XmlDiskReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageDomainDisksServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements StorageDomainDisksService.AddResponse {
        private Disk disk;

        private AddResponseImpl() {
        }

        public void disk(Disk disk) {
            this.disk = disk;
        }

        @Override
        public Disk disk() {
            return this.disk;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<StorageDomainDisksService.AddRequest, StorageDomainDisksService.AddResponse>
    implements StorageDomainDisksService.AddRequest {
        private Disk disk;
        private Boolean unregistered;

        private AddRequestImpl() {
        }

        @Override
        public StorageDomainDisksService.AddRequest disk(Disk disk) {
            this.disk = disk;
            return this;
        }

        @Override
        public StorageDomainDisksService.AddRequest disk(DiskBuilder disk) {
            this.disk = disk.build();
            return this;
        }

        @Override
        public StorageDomainDisksService.AddRequest unregistered(Boolean unregistered) {
            this.unregistered = unregistered;
            return this;
        }

        @Override
        public StorageDomainDisksService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageDomainDisksServiceImpl.this.getConnection().getUrl() + StorageDomainDisksServiceImpl.this.getPath());
                if (this.unregistered != null) {
                    uriBuilder.addParameter("unregistered", XmlWriter.renderBoolean(this.unregistered));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlDiskWriter.writeOne(this.disk, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageDomainDisksServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.disk(XmlDiskReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageDomainDisksServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

