/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum VmPoolType {
    AUTOMATIC("automatic"),
    MANUAL("manual");

    private static final Logger log;
    private String image;

    private VmPoolType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static VmPoolType fromValue(String value) {
        try {
            return VmPoolType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'VmPoolType' enumerated type. Valid values are 'automatic' and 'manual'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(VmPoolType.class);
    }
}

