/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AffinityGroupHostServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlHostReader;
import org.ovirt.engine.sdk4.internal.xml.XmlHostWriter;
import org.ovirt.engine.sdk4.services.AffinityGroupHostService;
import org.ovirt.engine.sdk4.services.AffinityGroupHostsService;
import org.ovirt.engine.sdk4.types.Host;

public class AffinityGroupHostsServiceImpl
extends ServiceImpl
implements AffinityGroupHostsService {
    public AffinityGroupHostsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public AffinityGroupHostsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public AffinityGroupHostsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public AffinityGroupHostService hostService(String id) {
        return new AffinityGroupHostServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.hostService(path);
        }
        return this.hostService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "AffinityGroupHostsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements AffinityGroupHostsService.ListResponse {
        private List<Host> hosts;

        private ListResponseImpl() {
        }

        public void hosts(List<Host> hosts) {
            this.hosts = hosts;
        }

        @Override
        public List<Host> hosts() {
            return this.hosts;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<AffinityGroupHostsService.ListRequest, AffinityGroupHostsService.ListResponse>
    implements AffinityGroupHostsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public AffinityGroupHostsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public AffinityGroupHostsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public AffinityGroupHostsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public AffinityGroupHostsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public AffinityGroupHostsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AffinityGroupHostsServiceImpl.this.getConnection().getUrl() + AffinityGroupHostsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AffinityGroupHostsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.hosts(XmlHostReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AffinityGroupHostsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements AffinityGroupHostsService.AddResponse {
        private Host host;

        private AddResponseImpl() {
        }

        public void host(Host host) {
            this.host = host;
        }

        @Override
        public Host host() {
            return this.host;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<AffinityGroupHostsService.AddRequest, AffinityGroupHostsService.AddResponse>
    implements AffinityGroupHostsService.AddRequest {
        private Host host;

        private AddRequestImpl() {
        }

        @Override
        public AffinityGroupHostsService.AddRequest host(Host host) {
            this.host = host;
            return this;
        }

        @Override
        public AffinityGroupHostsService.AddRequest host(HostBuilder host) {
            this.host = host.build();
            return this;
        }

        @Override
        public AffinityGroupHostsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AffinityGroupHostsServiceImpl.this.getConnection().getUrl() + AffinityGroupHostsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlHostWriter.writeOne(this.host, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AffinityGroupHostsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.host(XmlHostReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AffinityGroupHostsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

