/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.IscsiBondBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.NetworksServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.StorageServerConnectionsServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlIscsiBondReader;
import org.ovirt.engine.sdk4.internal.xml.XmlIscsiBondWriter;
import org.ovirt.engine.sdk4.services.IscsiBondService;
import org.ovirt.engine.sdk4.services.NetworksService;
import org.ovirt.engine.sdk4.services.StorageServerConnectionsService;
import org.ovirt.engine.sdk4.types.IscsiBond;

public class IscsiBondServiceImpl
extends ServiceImpl
implements IscsiBondService {
    public IscsiBondServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public IscsiBondService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public IscsiBondService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public IscsiBondService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public NetworksService networksService() {
        return new NetworksServiceImpl(this.getConnection(), this.getPath() + "/networks");
    }

    @Override
    public StorageServerConnectionsService storageServerConnectionsService() {
        return new StorageServerConnectionsServiceImpl(this.getConnection(), this.getPath() + "/storageserverconnections");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("networks")) {
            return this.networksService();
        }
        if (path.startsWith("networks/")) {
            return this.networksService().service(path.substring(9));
        }
        if (path.equals("storageserverconnections")) {
            return this.storageServerConnectionsService();
        }
        if (path.startsWith("storageserverconnections/")) {
            return this.storageServerConnectionsService().service(path.substring(25));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "IscsiBondService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements IscsiBondService.UpdateResponse {
        private IscsiBond bond;

        private UpdateResponseImpl() {
        }

        public void bond(IscsiBond bond) {
            this.bond = bond;
        }

        @Override
        public IscsiBond bond() {
            return this.bond;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<IscsiBondService.UpdateRequest, IscsiBondService.UpdateResponse>
    implements IscsiBondService.UpdateRequest {
        private Boolean async;
        private IscsiBond bond;

        private UpdateRequestImpl() {
        }

        @Override
        public IscsiBondService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public IscsiBondService.UpdateRequest bond(IscsiBond bond) {
            this.bond = bond;
            return this;
        }

        @Override
        public IscsiBondService.UpdateRequest bond(IscsiBondBuilder bond) {
            this.bond = bond.build();
            return this;
        }

        @Override
        public IscsiBondService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(IscsiBondServiceImpl.this.getConnection().getUrl() + IscsiBondServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlIscsiBondWriter.writeOne(this.bond, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = IscsiBondServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.bond(XmlIscsiBondReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            IscsiBondServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements IscsiBondService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<IscsiBondService.RemoveRequest, IscsiBondService.RemoveResponse>
    implements IscsiBondService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public IscsiBondService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public IscsiBondService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(IscsiBondServiceImpl.this.getConnection().getUrl() + IscsiBondServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = IscsiBondServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            IscsiBondServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements IscsiBondService.GetResponse {
        private IscsiBond bond;

        private GetResponseImpl() {
        }

        public void bond(IscsiBond bond) {
            this.bond = bond;
        }

        @Override
        public IscsiBond bond() {
            return this.bond;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<IscsiBondService.GetRequest, IscsiBondService.GetResponse>
    implements IscsiBondService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public IscsiBondService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public IscsiBondService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(IscsiBondServiceImpl.this.getConnection().getUrl() + IscsiBondServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = IscsiBondServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.bond(XmlIscsiBondReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            IscsiBondServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

