/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.QosBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.QosServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlQosReader;
import org.ovirt.engine.sdk4.internal.xml.XmlQosWriter;
import org.ovirt.engine.sdk4.services.QosService;
import org.ovirt.engine.sdk4.services.QossService;
import org.ovirt.engine.sdk4.types.Qos;

public class QossServiceImpl
extends ServiceImpl
implements QossService {
    public QossServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public QossService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public QossService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public QosService qosService(String id) {
        return new QosServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.qosService(path);
        }
        return this.qosService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "QossService:" + this.getPath();
    }

    private class ListResponseImpl
    implements QossService.ListResponse {
        private List<Qos> qoss;

        private ListResponseImpl() {
        }

        public void qoss(List<Qos> qoss) {
            this.qoss = qoss;
        }

        @Override
        public List<Qos> qoss() {
            return this.qoss;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<QossService.ListRequest, QossService.ListResponse>
    implements QossService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public QossService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public QossService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public QossService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public QossService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public QossService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(QossServiceImpl.this.getConnection().getUrl() + QossServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = QossServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.qoss(XmlQosReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            QossServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements QossService.AddResponse {
        private Qos qos;

        private AddResponseImpl() {
        }

        public void qos(Qos qos) {
            this.qos = qos;
        }

        @Override
        public Qos qos() {
            return this.qos;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<QossService.AddRequest, QossService.AddResponse>
    implements QossService.AddRequest {
        private Qos qos;

        private AddRequestImpl() {
        }

        @Override
        public QossService.AddRequest qos(Qos qos) {
            this.qos = qos;
            return this;
        }

        @Override
        public QossService.AddRequest qos(QosBuilder qos) {
            this.qos = qos.build();
            return this;
        }

        @Override
        public QossService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(QossServiceImpl.this.getConnection().getUrl() + QossServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlQosWriter.writeOne(this.qos, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = QossServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.qos(XmlQosReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            QossServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

