/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.SchedulingPolicyUnitServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlSchedulingPolicyUnitReader;
import org.ovirt.engine.sdk4.services.SchedulingPolicyUnitService;
import org.ovirt.engine.sdk4.services.SchedulingPolicyUnitsService;
import org.ovirt.engine.sdk4.types.SchedulingPolicyUnit;

public class SchedulingPolicyUnitsServiceImpl
extends ServiceImpl
implements SchedulingPolicyUnitsService {
    public SchedulingPolicyUnitsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public SchedulingPolicyUnitsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public SchedulingPolicyUnitService unitService(String id) {
        return new SchedulingPolicyUnitServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.unitService(path);
        }
        return this.unitService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "SchedulingPolicyUnitsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements SchedulingPolicyUnitsService.ListResponse {
        private List<SchedulingPolicyUnit> units;

        private ListResponseImpl() {
        }

        public void units(List<SchedulingPolicyUnit> units) {
            this.units = units;
        }

        @Override
        public List<SchedulingPolicyUnit> units() {
            return this.units;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<SchedulingPolicyUnitsService.ListRequest, SchedulingPolicyUnitsService.ListResponse>
    implements SchedulingPolicyUnitsService.ListRequest {
        private Boolean filter;
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public SchedulingPolicyUnitsService.ListRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public SchedulingPolicyUnitsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public SchedulingPolicyUnitsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public SchedulingPolicyUnitsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public SchedulingPolicyUnitsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public SchedulingPolicyUnitsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(SchedulingPolicyUnitsServiceImpl.this.getConnection().getUrl() + SchedulingPolicyUnitsServiceImpl.this.getPath());
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = SchedulingPolicyUnitsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.units(XmlSchedulingPolicyUnitReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            SchedulingPolicyUnitsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }
}

