/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlApplicationReader;
import org.ovirt.engine.sdk4.services.VmApplicationService;
import org.ovirt.engine.sdk4.types.Application;

public class VmApplicationServiceImpl
extends ServiceImpl
implements VmApplicationService {
    public VmApplicationServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public VmApplicationService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "VmApplicationService:" + this.getPath();
    }

    private class GetResponseImpl
    implements VmApplicationService.GetResponse {
        private Application application;

        private GetResponseImpl() {
        }

        public void application(Application application) {
            this.application = application;
        }

        @Override
        public Application application() {
            return this.application;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<VmApplicationService.GetRequest, VmApplicationService.GetResponse>
    implements VmApplicationService.GetRequest {
        private Boolean filter;
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public VmApplicationService.GetRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public VmApplicationService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public VmApplicationService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmApplicationServiceImpl.this.getConnection().getUrl() + VmApplicationServiceImpl.this.getPath());
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmApplicationServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.application(XmlApplicationReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmApplicationServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

