/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.BackupBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.VmBackupServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlBackupReader;
import org.ovirt.engine.sdk4.internal.xml.XmlBackupWriter;
import org.ovirt.engine.sdk4.services.VmBackupService;
import org.ovirt.engine.sdk4.services.VmBackupsService;
import org.ovirt.engine.sdk4.types.Backup;

public class VmBackupsServiceImpl
extends ServiceImpl
implements VmBackupsService {
    public VmBackupsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public VmBackupsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public VmBackupsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public VmBackupService backupService(String id) {
        return new VmBackupServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.backupService(path);
        }
        return this.backupService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "VmBackupsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements VmBackupsService.ListResponse {
        private List<Backup> backups;

        private ListResponseImpl() {
        }

        public void backups(List<Backup> backups) {
            this.backups = backups;
        }

        @Override
        public List<Backup> backups() {
            return this.backups;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<VmBackupsService.ListRequest, VmBackupsService.ListResponse>
    implements VmBackupsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public VmBackupsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public VmBackupsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public VmBackupsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public VmBackupsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public VmBackupsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmBackupsServiceImpl.this.getConnection().getUrl() + VmBackupsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmBackupsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.backups(XmlBackupReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmBackupsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements VmBackupsService.AddResponse {
        private Backup backup;

        private AddResponseImpl() {
        }

        public void backup(Backup backup) {
            this.backup = backup;
        }

        @Override
        public Backup backup() {
            return this.backup;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<VmBackupsService.AddRequest, VmBackupsService.AddResponse>
    implements VmBackupsService.AddRequest {
        private Backup backup;
        private Boolean requireConsistency;

        private AddRequestImpl() {
        }

        @Override
        public VmBackupsService.AddRequest backup(Backup backup) {
            this.backup = backup;
            return this;
        }

        @Override
        public VmBackupsService.AddRequest backup(BackupBuilder backup) {
            this.backup = backup.build();
            return this;
        }

        @Override
        public VmBackupsService.AddRequest requireConsistency(Boolean requireConsistency) {
            this.requireConsistency = requireConsistency;
            return this;
        }

        @Override
        public VmBackupsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmBackupsServiceImpl.this.getConnection().getUrl() + VmBackupsServiceImpl.this.getPath());
                if (this.requireConsistency != null) {
                    uriBuilder.addParameter("require_consistency", XmlWriter.renderBoolean(this.requireConsistency));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlBackupWriter.writeOne(this.backup, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmBackupsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.backup(XmlBackupReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmBackupsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

