/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import org.ovirt.engine.sdk4.types.ApiSummary;
import org.ovirt.engine.sdk4.types.ApiSummaryItem;

public class ApiSummaryContainer extends Container implements ApiSummary {
    private ApiSummaryItem hosts;
    private ApiSummaryItem storageDomains;
    private ApiSummaryItem users;
    private ApiSummaryItem vms;
    
    public ApiSummaryItem hosts() {
        return hosts;
    }
    
    public void hosts(ApiSummaryItem newHosts) {
        hosts = newHosts;
    }
    
    public boolean hostsPresent() {
        return hosts != null;
    }
    
    public ApiSummaryItem storageDomains() {
        return storageDomains;
    }
    
    public void storageDomains(ApiSummaryItem newStorageDomains) {
        storageDomains = newStorageDomains;
    }
    
    public boolean storageDomainsPresent() {
        return storageDomains != null;
    }
    
    public ApiSummaryItem users() {
        return users;
    }
    
    public void users(ApiSummaryItem newUsers) {
        users = newUsers;
    }
    
    public boolean usersPresent() {
        return users != null;
    }
    
    public ApiSummaryItem vms() {
        return vms;
    }
    
    public void vms(ApiSummaryItem newVms) {
        vms = newVms;
    }
    
    public boolean vmsPresent() {
        return vms != null;
    }
    
}
