/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.containers;

import java.util.Date;
import java.util.List;
import org.ovirt.engine.sdk4.internal.containers.IdentifiedContainer;
import org.ovirt.engine.sdk4.types.Checkpoint;
import org.ovirt.engine.sdk4.types.CheckpointState;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.Vm;

public class CheckpointContainer
extends IdentifiedContainer
implements Checkpoint {
    private Date creationDate;
    private String parentId;
    private CheckpointState state;
    private List<Disk> disks;
    private Vm vm;

    @Override
    public Date creationDate() {
        if (this.creationDate == null) {
            return null;
        }
        return new Date(this.creationDate.getTime());
    }

    public void creationDate(Date newCreationDate) {
        this.creationDate = newCreationDate == null ? null : new Date(newCreationDate.getTime());
    }

    @Override
    public boolean creationDatePresent() {
        return this.creationDate != null;
    }

    @Override
    public String parentId() {
        return this.parentId;
    }

    public void parentId(String newParentId) {
        this.parentId = newParentId;
    }

    @Override
    public boolean parentIdPresent() {
        return this.parentId != null;
    }

    @Override
    public CheckpointState state() {
        return this.state;
    }

    public void state(CheckpointState newState) {
        this.state = newState;
    }

    @Override
    public boolean statePresent() {
        return this.state != null;
    }

    @Override
    public List<Disk> disks() {
        return CheckpointContainer.makeUnmodifiableList(this.disks);
    }

    public void disks(List<Disk> newDisks) {
        this.disks = CheckpointContainer.makeArrayList(newDisks);
    }

    @Override
    public boolean disksPresent() {
        return this.disks != null && !this.disks.isEmpty();
    }

    @Override
    public Vm vm() {
        return this.vm;
    }

    public void vm(Vm newVm) {
        this.vm = newVm;
    }

    @Override
    public boolean vmPresent() {
        return this.vm != null;
    }
}

