/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AffinityGroupVmServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmWriter;
import org.ovirt.engine.sdk4.services.AffinityGroupVmService;
import org.ovirt.engine.sdk4.services.AffinityGroupVmsService;
import org.ovirt.engine.sdk4.types.Vm;

public class AffinityGroupVmsServiceImpl
extends ServiceImpl
implements AffinityGroupVmsService {
    public AffinityGroupVmsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public AffinityGroupVmsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public AffinityGroupVmsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public AffinityGroupVmService vmService(String id) {
        return new AffinityGroupVmServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.vmService(path);
        }
        return this.vmService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "AffinityGroupVmsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements AffinityGroupVmsService.ListResponse {
        private List<Vm> vms;

        private ListResponseImpl() {
        }

        public void vms(List<Vm> vms) {
            this.vms = vms;
        }

        @Override
        public List<Vm> vms() {
            return this.vms;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<AffinityGroupVmsService.ListRequest, AffinityGroupVmsService.ListResponse>
    implements AffinityGroupVmsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public AffinityGroupVmsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public AffinityGroupVmsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public AffinityGroupVmsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public AffinityGroupVmsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public AffinityGroupVmsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AffinityGroupVmsServiceImpl.this.getConnection().getUrl() + AffinityGroupVmsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AffinityGroupVmsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.vms(XmlVmReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AffinityGroupVmsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements AffinityGroupVmsService.AddResponse {
        private Vm vm;

        private AddResponseImpl() {
        }

        public void vm(Vm vm) {
            this.vm = vm;
        }

        @Override
        public Vm vm() {
            return this.vm;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<AffinityGroupVmsService.AddRequest, AffinityGroupVmsService.AddResponse>
    implements AffinityGroupVmsService.AddRequest {
        private Vm vm;

        private AddRequestImpl() {
        }

        @Override
        public AffinityGroupVmsService.AddRequest vm(Vm vm) {
            this.vm = vm;
            return this;
        }

        @Override
        public AffinityGroupVmsService.AddRequest vm(VmBuilder vm) {
            this.vm = vm.build();
            return this;
        }

        @Override
        public AffinityGroupVmsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(AffinityGroupVmsServiceImpl.this.getConnection().getUrl() + AffinityGroupVmsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlVmWriter.writeOne(this.vm, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = AffinityGroupVmsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.vm(XmlVmReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            AffinityGroupVmsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

