#ifndef JEMALLOC_INTERNAL_SIZE_CLASSES_H
#define JEMALLOC_INTERNAL_SIZE_CLASSES_H

/* This file was automatically generated by size_classes.sh. */

#include "jemalloc/internal/jemalloc_internal_types.h"

/*
 * This header file defines:
 *
 *   LG_SIZE_CLASS_GROUP: Lg of size class count for each size doubling.
 *   LG_TINY_MIN: Lg of minimum size class to support.
 *   SIZE_CLASSES: Complete table of SC(index, lg_grp, lg_delta, ndelta, psz,
 *                 bin, pgs, lg_delta_lookup) tuples.
 *     index: Size class index.
 *     lg_grp: Lg group base size (no deltas added).
 *     lg_delta: Lg delta to previous size class.
 *     ndelta: Delta multiplier.  size == 1<<lg_grp + ndelta<<lg_delta
 *     psz: 'yes' if a multiple of the page size, 'no' otherwise.
 *     bin: 'yes' if a small bin size class, 'no' otherwise.
 *     pgs: Slab page count if a small bin size class, 0 otherwise.
 *     lg_delta_lookup: Same as lg_delta if a lookup table size class, 'no'
 *                      otherwise.
 *   NTBINS: Number of tiny bins.
 *   NLBINS: Number of bins supported by the lookup table.
 *   NBINS: Number of small size class bins.
 *   NSIZES: Number of size classes.
 *   LG_CEIL_NSIZES: Number of bits required to store NSIZES.
 *   NPSIZES: Number of size classes that are a multiple of (1U << LG_PAGE).
 *   LG_TINY_MAXCLASS: Lg of maximum tiny size class.
 *   LOOKUP_MAXCLASS: Maximum size class included in lookup table.
 *   SMALL_MAXCLASS: Maximum small size class.
 *   LG_LARGE_MINCLASS: Lg of minimum large size class.
 *   LARGE_MAXCLASS: Maximum (large) size class.
 */

#define LG_SIZE_CLASS_GROUP	2

#ifdef __NetBSD__
#if defined(__hppa__)
/*
 * This case would also be needed for aarch64 but NetBSD's gcc config overrides it:
 * gcc/config/aarch64/aarch64-netbsd.h:#define MALLOC_ABI_ALIGNMENT  64
 * The NetBSD hppa config is non-standard too and always uses 128 bit (not only
 * for 64bit code and 64bit alignment for 32bit code).
 */
#define LG_TINY_MIN		5
#elif defined(_LP64) || defined(__arm__)
#define LG_TINY_MIN		4
#else
#define LG_TINY_MIN		3
#endif
#else
#define LG_TINY_MIN		3
#endif

#if (LG_SIZEOF_PTR == 2 && LG_TINY_MIN == 3 && LG_QUANTUM == 3 && LG_PAGE == 12)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      3,        3,      0,  no, yes,   1,  3) \
    SC(  1,      3,        3,      1,  no, yes,   1,  3) \
    SC(  2,      3,        3,      2,  no, yes,   3,  3) \
    SC(  3,      3,        3,      3,  no, yes,   1,  3) \
                                                         \
    SC(  4,      5,        3,      1,  no, yes,   5,  3) \
    SC(  5,      5,        3,      2,  no, yes,   3,  3) \
    SC(  6,      5,        3,      3,  no, yes,   7,  3) \
    SC(  7,      5,        3,      4,  no, yes,   1,  3) \
                                                         \
    SC(  8,      6,        4,      1,  no, yes,   5,  4) \
    SC(  9,      6,        4,      2,  no, yes,   3,  4) \
    SC( 10,      6,        4,      3,  no, yes,   7,  4) \
    SC( 11,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC( 12,      7,        5,      1,  no, yes,   5,  5) \
    SC( 13,      7,        5,      2,  no, yes,   3,  5) \
    SC( 14,      7,        5,      3,  no, yes,   7,  5) \
    SC( 15,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 16,      8,        6,      1,  no, yes,   5,  6) \
    SC( 17,      8,        6,      2,  no, yes,   3,  6) \
    SC( 18,      8,        6,      3,  no, yes,   7,  6) \
    SC( 19,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 20,      9,        7,      1,  no, yes,   5,  7) \
    SC( 21,      9,        7,      2,  no, yes,   3,  7) \
    SC( 22,      9,        7,      3,  no, yes,   7,  7) \
    SC( 23,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 24,     10,        8,      1,  no, yes,   5,  8) \
    SC( 25,     10,        8,      2,  no, yes,   3,  8) \
    SC( 26,     10,        8,      3,  no, yes,   7,  8) \
    SC( 27,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 28,     11,        9,      1,  no, yes,   5,  9) \
    SC( 29,     11,        9,      2,  no, yes,   3,  9) \
    SC( 30,     11,        9,      3,  no, yes,   7,  9) \
    SC( 31,     11,        9,      4, yes, yes,   1,  9) \
                                                         \
    SC( 32,     12,       10,      1,  no, yes,   5, no) \
    SC( 33,     12,       10,      2,  no, yes,   3, no) \
    SC( 34,     12,       10,      3,  no, yes,   7, no) \
    SC( 35,     12,       10,      4, yes, yes,   2, no) \
                                                         \
    SC( 36,     13,       11,      1,  no, yes,   5, no) \
    SC( 37,     13,       11,      2, yes, yes,   3, no) \
    SC( 38,     13,       11,      3,  no, yes,   7, no) \
    SC( 39,     13,       11,      4, yes,  no,   0, no) \
                                                         \
    SC( 40,     14,       12,      1, yes,  no,   0, no) \
    SC( 41,     14,       12,      2, yes,  no,   0, no) \
    SC( 42,     14,       12,      3, yes,  no,   0, no) \
    SC( 43,     14,       12,      4, yes,  no,   0, no) \
                                                         \
    SC( 44,     15,       13,      1, yes,  no,   0, no) \
    SC( 45,     15,       13,      2, yes,  no,   0, no) \
    SC( 46,     15,       13,      3, yes,  no,   0, no) \
    SC( 47,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 48,     16,       14,      1, yes,  no,   0, no) \
    SC( 49,     16,       14,      2, yes,  no,   0, no) \
    SC( 50,     16,       14,      3, yes,  no,   0, no) \
    SC( 51,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 52,     17,       15,      1, yes,  no,   0, no) \
    SC( 53,     17,       15,      2, yes,  no,   0, no) \
    SC( 54,     17,       15,      3, yes,  no,   0, no) \
    SC( 55,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 56,     18,       16,      1, yes,  no,   0, no) \
    SC( 57,     18,       16,      2, yes,  no,   0, no) \
    SC( 58,     18,       16,      3, yes,  no,   0, no) \
    SC( 59,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 60,     19,       17,      1, yes,  no,   0, no) \
    SC( 61,     19,       17,      2, yes,  no,   0, no) \
    SC( 62,     19,       17,      3, yes,  no,   0, no) \
    SC( 63,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 64,     20,       18,      1, yes,  no,   0, no) \
    SC( 65,     20,       18,      2, yes,  no,   0, no) \
    SC( 66,     20,       18,      3, yes,  no,   0, no) \
    SC( 67,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 68,     21,       19,      1, yes,  no,   0, no) \
    SC( 69,     21,       19,      2, yes,  no,   0, no) \
    SC( 70,     21,       19,      3, yes,  no,   0, no) \
    SC( 71,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 72,     22,       20,      1, yes,  no,   0, no) \
    SC( 73,     22,       20,      2, yes,  no,   0, no) \
    SC( 74,     22,       20,      3, yes,  no,   0, no) \
    SC( 75,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 76,     23,       21,      1, yes,  no,   0, no) \
    SC( 77,     23,       21,      2, yes,  no,   0, no) \
    SC( 78,     23,       21,      3, yes,  no,   0, no) \
    SC( 79,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 80,     24,       22,      1, yes,  no,   0, no) \
    SC( 81,     24,       22,      2, yes,  no,   0, no) \
    SC( 82,     24,       22,      3, yes,  no,   0, no) \
    SC( 83,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 84,     25,       23,      1, yes,  no,   0, no) \
    SC( 85,     25,       23,      2, yes,  no,   0, no) \
    SC( 86,     25,       23,      3, yes,  no,   0, no) \
    SC( 87,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 88,     26,       24,      1, yes,  no,   0, no) \
    SC( 89,     26,       24,      2, yes,  no,   0, no) \
    SC( 90,     26,       24,      3, yes,  no,   0, no) \
    SC( 91,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 92,     27,       25,      1, yes,  no,   0, no) \
    SC( 93,     27,       25,      2, yes,  no,   0, no) \
    SC( 94,     27,       25,      3, yes,  no,   0, no) \
    SC( 95,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 96,     28,       26,      1, yes,  no,   0, no) \
    SC( 97,     28,       26,      2, yes,  no,   0, no) \
    SC( 98,     28,       26,      3, yes,  no,   0, no) \
    SC( 99,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC(100,     29,       27,      1, yes,  no,   0, no) \
    SC(101,     29,       27,      2, yes,  no,   0, no) \
    SC(102,     29,       27,      3, yes,  no,   0, no) \
    SC(103,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(104,     30,       28,      1, yes,  no,   0, no) \
    SC(105,     30,       28,      2, yes,  no,   0, no) \
    SC(106,     30,       28,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			0
#define NLBINS			32
#define NBINS			39
#define NSIZES			107
#define LG_CEIL_NSIZES		7
#define NPSIZES			71
#define LG_TINY_MAXCLASS	"NA"
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 13) + (((size_t)3) << 11))
#define LG_LARGE_MINCLASS	14
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 30) + (((size_t)3) << 28))
#endif

#if (LG_SIZEOF_PTR == 2 && LG_TINY_MIN == 3 && LG_QUANTUM == 4 && LG_PAGE == 12)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      3,        3,      0,  no, yes,   1,  3) \
                                                         \
    SC(  1,      3,        3,      1,  no, yes,   1,  3) \
    SC(  2,      4,        4,      1,  no, yes,   1,  4) \
    SC(  3,      4,        4,      2,  no, yes,   3,  4) \
    SC(  4,      4,        4,      3,  no, yes,   1,  4) \
                                                         \
    SC(  5,      6,        4,      1,  no, yes,   5,  4) \
    SC(  6,      6,        4,      2,  no, yes,   3,  4) \
    SC(  7,      6,        4,      3,  no, yes,   7,  4) \
    SC(  8,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC(  9,      7,        5,      1,  no, yes,   5,  5) \
    SC( 10,      7,        5,      2,  no, yes,   3,  5) \
    SC( 11,      7,        5,      3,  no, yes,   7,  5) \
    SC( 12,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 13,      8,        6,      1,  no, yes,   5,  6) \
    SC( 14,      8,        6,      2,  no, yes,   3,  6) \
    SC( 15,      8,        6,      3,  no, yes,   7,  6) \
    SC( 16,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 17,      9,        7,      1,  no, yes,   5,  7) \
    SC( 18,      9,        7,      2,  no, yes,   3,  7) \
    SC( 19,      9,        7,      3,  no, yes,   7,  7) \
    SC( 20,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 21,     10,        8,      1,  no, yes,   5,  8) \
    SC( 22,     10,        8,      2,  no, yes,   3,  8) \
    SC( 23,     10,        8,      3,  no, yes,   7,  8) \
    SC( 24,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 25,     11,        9,      1,  no, yes,   5,  9) \
    SC( 26,     11,        9,      2,  no, yes,   3,  9) \
    SC( 27,     11,        9,      3,  no, yes,   7,  9) \
    SC( 28,     11,        9,      4, yes, yes,   1,  9) \
                                                         \
    SC( 29,     12,       10,      1,  no, yes,   5, no) \
    SC( 30,     12,       10,      2,  no, yes,   3, no) \
    SC( 31,     12,       10,      3,  no, yes,   7, no) \
    SC( 32,     12,       10,      4, yes, yes,   2, no) \
                                                         \
    SC( 33,     13,       11,      1,  no, yes,   5, no) \
    SC( 34,     13,       11,      2, yes, yes,   3, no) \
    SC( 35,     13,       11,      3,  no, yes,   7, no) \
    SC( 36,     13,       11,      4, yes,  no,   0, no) \
                                                         \
    SC( 37,     14,       12,      1, yes,  no,   0, no) \
    SC( 38,     14,       12,      2, yes,  no,   0, no) \
    SC( 39,     14,       12,      3, yes,  no,   0, no) \
    SC( 40,     14,       12,      4, yes,  no,   0, no) \
                                                         \
    SC( 41,     15,       13,      1, yes,  no,   0, no) \
    SC( 42,     15,       13,      2, yes,  no,   0, no) \
    SC( 43,     15,       13,      3, yes,  no,   0, no) \
    SC( 44,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 45,     16,       14,      1, yes,  no,   0, no) \
    SC( 46,     16,       14,      2, yes,  no,   0, no) \
    SC( 47,     16,       14,      3, yes,  no,   0, no) \
    SC( 48,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 49,     17,       15,      1, yes,  no,   0, no) \
    SC( 50,     17,       15,      2, yes,  no,   0, no) \
    SC( 51,     17,       15,      3, yes,  no,   0, no) \
    SC( 52,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 53,     18,       16,      1, yes,  no,   0, no) \
    SC( 54,     18,       16,      2, yes,  no,   0, no) \
    SC( 55,     18,       16,      3, yes,  no,   0, no) \
    SC( 56,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 57,     19,       17,      1, yes,  no,   0, no) \
    SC( 58,     19,       17,      2, yes,  no,   0, no) \
    SC( 59,     19,       17,      3, yes,  no,   0, no) \
    SC( 60,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 61,     20,       18,      1, yes,  no,   0, no) \
    SC( 62,     20,       18,      2, yes,  no,   0, no) \
    SC( 63,     20,       18,      3, yes,  no,   0, no) \
    SC( 64,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 65,     21,       19,      1, yes,  no,   0, no) \
    SC( 66,     21,       19,      2, yes,  no,   0, no) \
    SC( 67,     21,       19,      3, yes,  no,   0, no) \
    SC( 68,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 69,     22,       20,      1, yes,  no,   0, no) \
    SC( 70,     22,       20,      2, yes,  no,   0, no) \
    SC( 71,     22,       20,      3, yes,  no,   0, no) \
    SC( 72,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 73,     23,       21,      1, yes,  no,   0, no) \
    SC( 74,     23,       21,      2, yes,  no,   0, no) \
    SC( 75,     23,       21,      3, yes,  no,   0, no) \
    SC( 76,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 77,     24,       22,      1, yes,  no,   0, no) \
    SC( 78,     24,       22,      2, yes,  no,   0, no) \
    SC( 79,     24,       22,      3, yes,  no,   0, no) \
    SC( 80,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 81,     25,       23,      1, yes,  no,   0, no) \
    SC( 82,     25,       23,      2, yes,  no,   0, no) \
    SC( 83,     25,       23,      3, yes,  no,   0, no) \
    SC( 84,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 85,     26,       24,      1, yes,  no,   0, no) \
    SC( 86,     26,       24,      2, yes,  no,   0, no) \
    SC( 87,     26,       24,      3, yes,  no,   0, no) \
    SC( 88,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 89,     27,       25,      1, yes,  no,   0, no) \
    SC( 90,     27,       25,      2, yes,  no,   0, no) \
    SC( 91,     27,       25,      3, yes,  no,   0, no) \
    SC( 92,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 93,     28,       26,      1, yes,  no,   0, no) \
    SC( 94,     28,       26,      2, yes,  no,   0, no) \
    SC( 95,     28,       26,      3, yes,  no,   0, no) \
    SC( 96,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC( 97,     29,       27,      1, yes,  no,   0, no) \
    SC( 98,     29,       27,      2, yes,  no,   0, no) \
    SC( 99,     29,       27,      3, yes,  no,   0, no) \
    SC(100,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(101,     30,       28,      1, yes,  no,   0, no) \
    SC(102,     30,       28,      2, yes,  no,   0, no) \
    SC(103,     30,       28,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			1
#define NLBINS			29
#define NBINS			36
#define NSIZES			104
#define LG_CEIL_NSIZES		7
#define NPSIZES			71
#define LG_TINY_MAXCLASS	3
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 13) + (((size_t)3) << 11))
#define LG_LARGE_MINCLASS	14
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 30) + (((size_t)3) << 28))
#endif

#if (LG_SIZEOF_PTR == 2 && LG_TINY_MIN == 4 && LG_QUANTUM == 4 && LG_PAGE == 12)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      4,        4,      0,  no, yes,   1,  4) \
    SC(  1,      4,        4,      1,  no, yes,   1,  4) \
    SC(  2,      4,        4,      2,  no, yes,   3,  4) \
    SC(  3,      4,        4,      3,  no, yes,   1,  4) \
                                                         \
    SC(  4,      6,        4,      1,  no, yes,   5,  4) \
    SC(  5,      6,        4,      2,  no, yes,   3,  4) \
    SC(  6,      6,        4,      3,  no, yes,   7,  4) \
    SC(  7,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC(  8,      7,        5,      1,  no, yes,   5,  5) \
    SC(  9,      7,        5,      2,  no, yes,   3,  5) \
    SC( 10,      7,        5,      3,  no, yes,   7,  5) \
    SC( 11,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 12,      8,        6,      1,  no, yes,   5,  6) \
    SC( 13,      8,        6,      2,  no, yes,   3,  6) \
    SC( 14,      8,        6,      3,  no, yes,   7,  6) \
    SC( 15,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 16,      9,        7,      1,  no, yes,   5,  7) \
    SC( 17,      9,        7,      2,  no, yes,   3,  7) \
    SC( 18,      9,        7,      3,  no, yes,   7,  7) \
    SC( 19,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 20,     10,        8,      1,  no, yes,   5,  8) \
    SC( 21,     10,        8,      2,  no, yes,   3,  8) \
    SC( 22,     10,        8,      3,  no, yes,   7,  8) \
    SC( 23,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 24,     11,        9,      1,  no, yes,   5,  9) \
    SC( 25,     11,        9,      2,  no, yes,   3,  9) \
    SC( 26,     11,        9,      3,  no, yes,   7,  9) \
    SC( 27,     11,        9,      4, yes, yes,   1,  9) \
                                                         \
    SC( 28,     12,       10,      1,  no, yes,   5, no) \
    SC( 29,     12,       10,      2,  no, yes,   3, no) \
    SC( 30,     12,       10,      3,  no, yes,   7, no) \
    SC( 31,     12,       10,      4, yes, yes,   2, no) \
                                                         \
    SC( 32,     13,       11,      1,  no, yes,   5, no) \
    SC( 33,     13,       11,      2, yes, yes,   3, no) \
    SC( 34,     13,       11,      3,  no, yes,   7, no) \
    SC( 35,     13,       11,      4, yes,  no,   0, no) \
                                                         \
    SC( 36,     14,       12,      1, yes,  no,   0, no) \
    SC( 37,     14,       12,      2, yes,  no,   0, no) \
    SC( 38,     14,       12,      3, yes,  no,   0, no) \
    SC( 39,     14,       12,      4, yes,  no,   0, no) \
                                                         \
    SC( 40,     15,       13,      1, yes,  no,   0, no) \
    SC( 41,     15,       13,      2, yes,  no,   0, no) \
    SC( 42,     15,       13,      3, yes,  no,   0, no) \
    SC( 43,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 44,     16,       14,      1, yes,  no,   0, no) \
    SC( 45,     16,       14,      2, yes,  no,   0, no) \
    SC( 46,     16,       14,      3, yes,  no,   0, no) \
    SC( 47,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 48,     17,       15,      1, yes,  no,   0, no) \
    SC( 49,     17,       15,      2, yes,  no,   0, no) \
    SC( 50,     17,       15,      3, yes,  no,   0, no) \
    SC( 51,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 52,     18,       16,      1, yes,  no,   0, no) \
    SC( 53,     18,       16,      2, yes,  no,   0, no) \
    SC( 54,     18,       16,      3, yes,  no,   0, no) \
    SC( 55,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 56,     19,       17,      1, yes,  no,   0, no) \
    SC( 57,     19,       17,      2, yes,  no,   0, no) \
    SC( 58,     19,       17,      3, yes,  no,   0, no) \
    SC( 59,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 60,     20,       18,      1, yes,  no,   0, no) \
    SC( 61,     20,       18,      2, yes,  no,   0, no) \
    SC( 62,     20,       18,      3, yes,  no,   0, no) \
    SC( 63,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 64,     21,       19,      1, yes,  no,   0, no) \
    SC( 65,     21,       19,      2, yes,  no,   0, no) \
    SC( 66,     21,       19,      3, yes,  no,   0, no) \
    SC( 67,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 68,     22,       20,      1, yes,  no,   0, no) \
    SC( 69,     22,       20,      2, yes,  no,   0, no) \
    SC( 70,     22,       20,      3, yes,  no,   0, no) \
    SC( 71,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 72,     23,       21,      1, yes,  no,   0, no) \
    SC( 73,     23,       21,      2, yes,  no,   0, no) \
    SC( 74,     23,       21,      3, yes,  no,   0, no) \
    SC( 75,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 76,     24,       22,      1, yes,  no,   0, no) \
    SC( 77,     24,       22,      2, yes,  no,   0, no) \
    SC( 78,     24,       22,      3, yes,  no,   0, no) \
    SC( 79,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 80,     25,       23,      1, yes,  no,   0, no) \
    SC( 81,     25,       23,      2, yes,  no,   0, no) \
    SC( 82,     25,       23,      3, yes,  no,   0, no) \
    SC( 83,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 84,     26,       24,      1, yes,  no,   0, no) \
    SC( 85,     26,       24,      2, yes,  no,   0, no) \
    SC( 86,     26,       24,      3, yes,  no,   0, no) \
    SC( 87,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 88,     27,       25,      1, yes,  no,   0, no) \
    SC( 89,     27,       25,      2, yes,  no,   0, no) \
    SC( 90,     27,       25,      3, yes,  no,   0, no) \
    SC( 91,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 92,     28,       26,      1, yes,  no,   0, no) \
    SC( 93,     28,       26,      2, yes,  no,   0, no) \
    SC( 94,     28,       26,      3, yes,  no,   0, no) \
    SC( 95,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC( 96,     29,       27,      1, yes,  no,   0, no) \
    SC( 97,     29,       27,      2, yes,  no,   0, no) \
    SC( 98,     29,       27,      3, yes,  no,   0, no) \
    SC( 99,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(100,     30,       28,      1, yes,  no,   0, no) \
    SC(101,     30,       28,      2, yes,  no,   0, no) \
    SC(102,     30,       28,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			0
#define NLBINS			28
#define NBINS			35
#define NSIZES			103
#define LG_CEIL_NSIZES		7
#define NPSIZES			71
#define LG_TINY_MAXCLASS	"NA"
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 13) + (((size_t)3) << 11))
#define LG_LARGE_MINCLASS	14
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 30) + (((size_t)3) << 28))
#endif

#if (LG_SIZEOF_PTR == 3 && LG_TINY_MIN == 3 && LG_QUANTUM == 3 && LG_PAGE == 12)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      3,        3,      0,  no, yes,   1,  3) \
    SC(  1,      3,        3,      1,  no, yes,   1,  3) \
    SC(  2,      3,        3,      2,  no, yes,   3,  3) \
    SC(  3,      3,        3,      3,  no, yes,   1,  3) \
                                                         \
    SC(  4,      5,        3,      1,  no, yes,   5,  3) \
    SC(  5,      5,        3,      2,  no, yes,   3,  3) \
    SC(  6,      5,        3,      3,  no, yes,   7,  3) \
    SC(  7,      5,        3,      4,  no, yes,   1,  3) \
                                                         \
    SC(  8,      6,        4,      1,  no, yes,   5,  4) \
    SC(  9,      6,        4,      2,  no, yes,   3,  4) \
    SC( 10,      6,        4,      3,  no, yes,   7,  4) \
    SC( 11,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC( 12,      7,        5,      1,  no, yes,   5,  5) \
    SC( 13,      7,        5,      2,  no, yes,   3,  5) \
    SC( 14,      7,        5,      3,  no, yes,   7,  5) \
    SC( 15,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 16,      8,        6,      1,  no, yes,   5,  6) \
    SC( 17,      8,        6,      2,  no, yes,   3,  6) \
    SC( 18,      8,        6,      3,  no, yes,   7,  6) \
    SC( 19,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 20,      9,        7,      1,  no, yes,   5,  7) \
    SC( 21,      9,        7,      2,  no, yes,   3,  7) \
    SC( 22,      9,        7,      3,  no, yes,   7,  7) \
    SC( 23,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 24,     10,        8,      1,  no, yes,   5,  8) \
    SC( 25,     10,        8,      2,  no, yes,   3,  8) \
    SC( 26,     10,        8,      3,  no, yes,   7,  8) \
    SC( 27,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 28,     11,        9,      1,  no, yes,   5,  9) \
    SC( 29,     11,        9,      2,  no, yes,   3,  9) \
    SC( 30,     11,        9,      3,  no, yes,   7,  9) \
    SC( 31,     11,        9,      4, yes, yes,   1,  9) \
                                                         \
    SC( 32,     12,       10,      1,  no, yes,   5, no) \
    SC( 33,     12,       10,      2,  no, yes,   3, no) \
    SC( 34,     12,       10,      3,  no, yes,   7, no) \
    SC( 35,     12,       10,      4, yes, yes,   2, no) \
                                                         \
    SC( 36,     13,       11,      1,  no, yes,   5, no) \
    SC( 37,     13,       11,      2, yes, yes,   3, no) \
    SC( 38,     13,       11,      3,  no, yes,   7, no) \
    SC( 39,     13,       11,      4, yes,  no,   0, no) \
                                                         \
    SC( 40,     14,       12,      1, yes,  no,   0, no) \
    SC( 41,     14,       12,      2, yes,  no,   0, no) \
    SC( 42,     14,       12,      3, yes,  no,   0, no) \
    SC( 43,     14,       12,      4, yes,  no,   0, no) \
                                                         \
    SC( 44,     15,       13,      1, yes,  no,   0, no) \
    SC( 45,     15,       13,      2, yes,  no,   0, no) \
    SC( 46,     15,       13,      3, yes,  no,   0, no) \
    SC( 47,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 48,     16,       14,      1, yes,  no,   0, no) \
    SC( 49,     16,       14,      2, yes,  no,   0, no) \
    SC( 50,     16,       14,      3, yes,  no,   0, no) \
    SC( 51,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 52,     17,       15,      1, yes,  no,   0, no) \
    SC( 53,     17,       15,      2, yes,  no,   0, no) \
    SC( 54,     17,       15,      3, yes,  no,   0, no) \
    SC( 55,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 56,     18,       16,      1, yes,  no,   0, no) \
    SC( 57,     18,       16,      2, yes,  no,   0, no) \
    SC( 58,     18,       16,      3, yes,  no,   0, no) \
    SC( 59,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 60,     19,       17,      1, yes,  no,   0, no) \
    SC( 61,     19,       17,      2, yes,  no,   0, no) \
    SC( 62,     19,       17,      3, yes,  no,   0, no) \
    SC( 63,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 64,     20,       18,      1, yes,  no,   0, no) \
    SC( 65,     20,       18,      2, yes,  no,   0, no) \
    SC( 66,     20,       18,      3, yes,  no,   0, no) \
    SC( 67,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 68,     21,       19,      1, yes,  no,   0, no) \
    SC( 69,     21,       19,      2, yes,  no,   0, no) \
    SC( 70,     21,       19,      3, yes,  no,   0, no) \
    SC( 71,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 72,     22,       20,      1, yes,  no,   0, no) \
    SC( 73,     22,       20,      2, yes,  no,   0, no) \
    SC( 74,     22,       20,      3, yes,  no,   0, no) \
    SC( 75,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 76,     23,       21,      1, yes,  no,   0, no) \
    SC( 77,     23,       21,      2, yes,  no,   0, no) \
    SC( 78,     23,       21,      3, yes,  no,   0, no) \
    SC( 79,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 80,     24,       22,      1, yes,  no,   0, no) \
    SC( 81,     24,       22,      2, yes,  no,   0, no) \
    SC( 82,     24,       22,      3, yes,  no,   0, no) \
    SC( 83,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 84,     25,       23,      1, yes,  no,   0, no) \
    SC( 85,     25,       23,      2, yes,  no,   0, no) \
    SC( 86,     25,       23,      3, yes,  no,   0, no) \
    SC( 87,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 88,     26,       24,      1, yes,  no,   0, no) \
    SC( 89,     26,       24,      2, yes,  no,   0, no) \
    SC( 90,     26,       24,      3, yes,  no,   0, no) \
    SC( 91,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 92,     27,       25,      1, yes,  no,   0, no) \
    SC( 93,     27,       25,      2, yes,  no,   0, no) \
    SC( 94,     27,       25,      3, yes,  no,   0, no) \
    SC( 95,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 96,     28,       26,      1, yes,  no,   0, no) \
    SC( 97,     28,       26,      2, yes,  no,   0, no) \
    SC( 98,     28,       26,      3, yes,  no,   0, no) \
    SC( 99,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC(100,     29,       27,      1, yes,  no,   0, no) \
    SC(101,     29,       27,      2, yes,  no,   0, no) \
    SC(102,     29,       27,      3, yes,  no,   0, no) \
    SC(103,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(104,     30,       28,      1, yes,  no,   0, no) \
    SC(105,     30,       28,      2, yes,  no,   0, no) \
    SC(106,     30,       28,      3, yes,  no,   0, no) \
    SC(107,     30,       28,      4, yes,  no,   0, no) \
                                                         \
    SC(108,     31,       29,      1, yes,  no,   0, no) \
    SC(109,     31,       29,      2, yes,  no,   0, no) \
    SC(110,     31,       29,      3, yes,  no,   0, no) \
    SC(111,     31,       29,      4, yes,  no,   0, no) \
                                                         \
    SC(112,     32,       30,      1, yes,  no,   0, no) \
    SC(113,     32,       30,      2, yes,  no,   0, no) \
    SC(114,     32,       30,      3, yes,  no,   0, no) \
    SC(115,     32,       30,      4, yes,  no,   0, no) \
                                                         \
    SC(116,     33,       31,      1, yes,  no,   0, no) \
    SC(117,     33,       31,      2, yes,  no,   0, no) \
    SC(118,     33,       31,      3, yes,  no,   0, no) \
    SC(119,     33,       31,      4, yes,  no,   0, no) \
                                                         \
    SC(120,     34,       32,      1, yes,  no,   0, no) \
    SC(121,     34,       32,      2, yes,  no,   0, no) \
    SC(122,     34,       32,      3, yes,  no,   0, no) \
    SC(123,     34,       32,      4, yes,  no,   0, no) \
                                                         \
    SC(124,     35,       33,      1, yes,  no,   0, no) \
    SC(125,     35,       33,      2, yes,  no,   0, no) \
    SC(126,     35,       33,      3, yes,  no,   0, no) \
    SC(127,     35,       33,      4, yes,  no,   0, no) \
                                                         \
    SC(128,     36,       34,      1, yes,  no,   0, no) \
    SC(129,     36,       34,      2, yes,  no,   0, no) \
    SC(130,     36,       34,      3, yes,  no,   0, no) \
    SC(131,     36,       34,      4, yes,  no,   0, no) \
                                                         \
    SC(132,     37,       35,      1, yes,  no,   0, no) \
    SC(133,     37,       35,      2, yes,  no,   0, no) \
    SC(134,     37,       35,      3, yes,  no,   0, no) \
    SC(135,     37,       35,      4, yes,  no,   0, no) \
                                                         \
    SC(136,     38,       36,      1, yes,  no,   0, no) \
    SC(137,     38,       36,      2, yes,  no,   0, no) \
    SC(138,     38,       36,      3, yes,  no,   0, no) \
    SC(139,     38,       36,      4, yes,  no,   0, no) \
                                                         \
    SC(140,     39,       37,      1, yes,  no,   0, no) \
    SC(141,     39,       37,      2, yes,  no,   0, no) \
    SC(142,     39,       37,      3, yes,  no,   0, no) \
    SC(143,     39,       37,      4, yes,  no,   0, no) \
                                                         \
    SC(144,     40,       38,      1, yes,  no,   0, no) \
    SC(145,     40,       38,      2, yes,  no,   0, no) \
    SC(146,     40,       38,      3, yes,  no,   0, no) \
    SC(147,     40,       38,      4, yes,  no,   0, no) \
                                                         \
    SC(148,     41,       39,      1, yes,  no,   0, no) \
    SC(149,     41,       39,      2, yes,  no,   0, no) \
    SC(150,     41,       39,      3, yes,  no,   0, no) \
    SC(151,     41,       39,      4, yes,  no,   0, no) \
                                                         \
    SC(152,     42,       40,      1, yes,  no,   0, no) \
    SC(153,     42,       40,      2, yes,  no,   0, no) \
    SC(154,     42,       40,      3, yes,  no,   0, no) \
    SC(155,     42,       40,      4, yes,  no,   0, no) \
                                                         \
    SC(156,     43,       41,      1, yes,  no,   0, no) \
    SC(157,     43,       41,      2, yes,  no,   0, no) \
    SC(158,     43,       41,      3, yes,  no,   0, no) \
    SC(159,     43,       41,      4, yes,  no,   0, no) \
                                                         \
    SC(160,     44,       42,      1, yes,  no,   0, no) \
    SC(161,     44,       42,      2, yes,  no,   0, no) \
    SC(162,     44,       42,      3, yes,  no,   0, no) \
    SC(163,     44,       42,      4, yes,  no,   0, no) \
                                                         \
    SC(164,     45,       43,      1, yes,  no,   0, no) \
    SC(165,     45,       43,      2, yes,  no,   0, no) \
    SC(166,     45,       43,      3, yes,  no,   0, no) \
    SC(167,     45,       43,      4, yes,  no,   0, no) \
                                                         \
    SC(168,     46,       44,      1, yes,  no,   0, no) \
    SC(169,     46,       44,      2, yes,  no,   0, no) \
    SC(170,     46,       44,      3, yes,  no,   0, no) \
    SC(171,     46,       44,      4, yes,  no,   0, no) \
                                                         \
    SC(172,     47,       45,      1, yes,  no,   0, no) \
    SC(173,     47,       45,      2, yes,  no,   0, no) \
    SC(174,     47,       45,      3, yes,  no,   0, no) \
    SC(175,     47,       45,      4, yes,  no,   0, no) \
                                                         \
    SC(176,     48,       46,      1, yes,  no,   0, no) \
    SC(177,     48,       46,      2, yes,  no,   0, no) \
    SC(178,     48,       46,      3, yes,  no,   0, no) \
    SC(179,     48,       46,      4, yes,  no,   0, no) \
                                                         \
    SC(180,     49,       47,      1, yes,  no,   0, no) \
    SC(181,     49,       47,      2, yes,  no,   0, no) \
    SC(182,     49,       47,      3, yes,  no,   0, no) \
    SC(183,     49,       47,      4, yes,  no,   0, no) \
                                                         \
    SC(184,     50,       48,      1, yes,  no,   0, no) \
    SC(185,     50,       48,      2, yes,  no,   0, no) \
    SC(186,     50,       48,      3, yes,  no,   0, no) \
    SC(187,     50,       48,      4, yes,  no,   0, no) \
                                                         \
    SC(188,     51,       49,      1, yes,  no,   0, no) \
    SC(189,     51,       49,      2, yes,  no,   0, no) \
    SC(190,     51,       49,      3, yes,  no,   0, no) \
    SC(191,     51,       49,      4, yes,  no,   0, no) \
                                                         \
    SC(192,     52,       50,      1, yes,  no,   0, no) \
    SC(193,     52,       50,      2, yes,  no,   0, no) \
    SC(194,     52,       50,      3, yes,  no,   0, no) \
    SC(195,     52,       50,      4, yes,  no,   0, no) \
                                                         \
    SC(196,     53,       51,      1, yes,  no,   0, no) \
    SC(197,     53,       51,      2, yes,  no,   0, no) \
    SC(198,     53,       51,      3, yes,  no,   0, no) \
    SC(199,     53,       51,      4, yes,  no,   0, no) \
                                                         \
    SC(200,     54,       52,      1, yes,  no,   0, no) \
    SC(201,     54,       52,      2, yes,  no,   0, no) \
    SC(202,     54,       52,      3, yes,  no,   0, no) \
    SC(203,     54,       52,      4, yes,  no,   0, no) \
                                                         \
    SC(204,     55,       53,      1, yes,  no,   0, no) \
    SC(205,     55,       53,      2, yes,  no,   0, no) \
    SC(206,     55,       53,      3, yes,  no,   0, no) \
    SC(207,     55,       53,      4, yes,  no,   0, no) \
                                                         \
    SC(208,     56,       54,      1, yes,  no,   0, no) \
    SC(209,     56,       54,      2, yes,  no,   0, no) \
    SC(210,     56,       54,      3, yes,  no,   0, no) \
    SC(211,     56,       54,      4, yes,  no,   0, no) \
                                                         \
    SC(212,     57,       55,      1, yes,  no,   0, no) \
    SC(213,     57,       55,      2, yes,  no,   0, no) \
    SC(214,     57,       55,      3, yes,  no,   0, no) \
    SC(215,     57,       55,      4, yes,  no,   0, no) \
                                                         \
    SC(216,     58,       56,      1, yes,  no,   0, no) \
    SC(217,     58,       56,      2, yes,  no,   0, no) \
    SC(218,     58,       56,      3, yes,  no,   0, no) \
    SC(219,     58,       56,      4, yes,  no,   0, no) \
                                                         \
    SC(220,     59,       57,      1, yes,  no,   0, no) \
    SC(221,     59,       57,      2, yes,  no,   0, no) \
    SC(222,     59,       57,      3, yes,  no,   0, no) \
    SC(223,     59,       57,      4, yes,  no,   0, no) \
                                                         \
    SC(224,     60,       58,      1, yes,  no,   0, no) \
    SC(225,     60,       58,      2, yes,  no,   0, no) \
    SC(226,     60,       58,      3, yes,  no,   0, no) \
    SC(227,     60,       58,      4, yes,  no,   0, no) \
                                                         \
    SC(228,     61,       59,      1, yes,  no,   0, no) \
    SC(229,     61,       59,      2, yes,  no,   0, no) \
    SC(230,     61,       59,      3, yes,  no,   0, no) \
    SC(231,     61,       59,      4, yes,  no,   0, no) \
                                                         \
    SC(232,     62,       60,      1, yes,  no,   0, no) \
    SC(233,     62,       60,      2, yes,  no,   0, no) \
    SC(234,     62,       60,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			0
#define NLBINS			32
#define NBINS			39
#define NSIZES			235
#define LG_CEIL_NSIZES		8
#define NPSIZES			199
#define LG_TINY_MAXCLASS	"NA"
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 13) + (((size_t)3) << 11))
#define LG_LARGE_MINCLASS	14
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 62) + (((size_t)3) << 60))
#endif

#if (LG_SIZEOF_PTR == 3 && LG_TINY_MIN == 3 && LG_QUANTUM == 4 && LG_PAGE == 12)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      3,        3,      0,  no, yes,   1,  3) \
                                                         \
    SC(  1,      3,        3,      1,  no, yes,   1,  3) \
    SC(  2,      4,        4,      1,  no, yes,   1,  4) \
    SC(  3,      4,        4,      2,  no, yes,   3,  4) \
    SC(  4,      4,        4,      3,  no, yes,   1,  4) \
                                                         \
    SC(  5,      6,        4,      1,  no, yes,   5,  4) \
    SC(  6,      6,        4,      2,  no, yes,   3,  4) \
    SC(  7,      6,        4,      3,  no, yes,   7,  4) \
    SC(  8,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC(  9,      7,        5,      1,  no, yes,   5,  5) \
    SC( 10,      7,        5,      2,  no, yes,   3,  5) \
    SC( 11,      7,        5,      3,  no, yes,   7,  5) \
    SC( 12,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 13,      8,        6,      1,  no, yes,   5,  6) \
    SC( 14,      8,        6,      2,  no, yes,   3,  6) \
    SC( 15,      8,        6,      3,  no, yes,   7,  6) \
    SC( 16,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 17,      9,        7,      1,  no, yes,   5,  7) \
    SC( 18,      9,        7,      2,  no, yes,   3,  7) \
    SC( 19,      9,        7,      3,  no, yes,   7,  7) \
    SC( 20,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 21,     10,        8,      1,  no, yes,   5,  8) \
    SC( 22,     10,        8,      2,  no, yes,   3,  8) \
    SC( 23,     10,        8,      3,  no, yes,   7,  8) \
    SC( 24,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 25,     11,        9,      1,  no, yes,   5,  9) \
    SC( 26,     11,        9,      2,  no, yes,   3,  9) \
    SC( 27,     11,        9,      3,  no, yes,   7,  9) \
    SC( 28,     11,        9,      4, yes, yes,   1,  9) \
                                                         \
    SC( 29,     12,       10,      1,  no, yes,   5, no) \
    SC( 30,     12,       10,      2,  no, yes,   3, no) \
    SC( 31,     12,       10,      3,  no, yes,   7, no) \
    SC( 32,     12,       10,      4, yes, yes,   2, no) \
                                                         \
    SC( 33,     13,       11,      1,  no, yes,   5, no) \
    SC( 34,     13,       11,      2, yes, yes,   3, no) \
    SC( 35,     13,       11,      3,  no, yes,   7, no) \
    SC( 36,     13,       11,      4, yes,  no,   0, no) \
                                                         \
    SC( 37,     14,       12,      1, yes,  no,   0, no) \
    SC( 38,     14,       12,      2, yes,  no,   0, no) \
    SC( 39,     14,       12,      3, yes,  no,   0, no) \
    SC( 40,     14,       12,      4, yes,  no,   0, no) \
                                                         \
    SC( 41,     15,       13,      1, yes,  no,   0, no) \
    SC( 42,     15,       13,      2, yes,  no,   0, no) \
    SC( 43,     15,       13,      3, yes,  no,   0, no) \
    SC( 44,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 45,     16,       14,      1, yes,  no,   0, no) \
    SC( 46,     16,       14,      2, yes,  no,   0, no) \
    SC( 47,     16,       14,      3, yes,  no,   0, no) \
    SC( 48,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 49,     17,       15,      1, yes,  no,   0, no) \
    SC( 50,     17,       15,      2, yes,  no,   0, no) \
    SC( 51,     17,       15,      3, yes,  no,   0, no) \
    SC( 52,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 53,     18,       16,      1, yes,  no,   0, no) \
    SC( 54,     18,       16,      2, yes,  no,   0, no) \
    SC( 55,     18,       16,      3, yes,  no,   0, no) \
    SC( 56,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 57,     19,       17,      1, yes,  no,   0, no) \
    SC( 58,     19,       17,      2, yes,  no,   0, no) \
    SC( 59,     19,       17,      3, yes,  no,   0, no) \
    SC( 60,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 61,     20,       18,      1, yes,  no,   0, no) \
    SC( 62,     20,       18,      2, yes,  no,   0, no) \
    SC( 63,     20,       18,      3, yes,  no,   0, no) \
    SC( 64,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 65,     21,       19,      1, yes,  no,   0, no) \
    SC( 66,     21,       19,      2, yes,  no,   0, no) \
    SC( 67,     21,       19,      3, yes,  no,   0, no) \
    SC( 68,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 69,     22,       20,      1, yes,  no,   0, no) \
    SC( 70,     22,       20,      2, yes,  no,   0, no) \
    SC( 71,     22,       20,      3, yes,  no,   0, no) \
    SC( 72,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 73,     23,       21,      1, yes,  no,   0, no) \
    SC( 74,     23,       21,      2, yes,  no,   0, no) \
    SC( 75,     23,       21,      3, yes,  no,   0, no) \
    SC( 76,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 77,     24,       22,      1, yes,  no,   0, no) \
    SC( 78,     24,       22,      2, yes,  no,   0, no) \
    SC( 79,     24,       22,      3, yes,  no,   0, no) \
    SC( 80,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 81,     25,       23,      1, yes,  no,   0, no) \
    SC( 82,     25,       23,      2, yes,  no,   0, no) \
    SC( 83,     25,       23,      3, yes,  no,   0, no) \
    SC( 84,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 85,     26,       24,      1, yes,  no,   0, no) \
    SC( 86,     26,       24,      2, yes,  no,   0, no) \
    SC( 87,     26,       24,      3, yes,  no,   0, no) \
    SC( 88,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 89,     27,       25,      1, yes,  no,   0, no) \
    SC( 90,     27,       25,      2, yes,  no,   0, no) \
    SC( 91,     27,       25,      3, yes,  no,   0, no) \
    SC( 92,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 93,     28,       26,      1, yes,  no,   0, no) \
    SC( 94,     28,       26,      2, yes,  no,   0, no) \
    SC( 95,     28,       26,      3, yes,  no,   0, no) \
    SC( 96,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC( 97,     29,       27,      1, yes,  no,   0, no) \
    SC( 98,     29,       27,      2, yes,  no,   0, no) \
    SC( 99,     29,       27,      3, yes,  no,   0, no) \
    SC(100,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(101,     30,       28,      1, yes,  no,   0, no) \
    SC(102,     30,       28,      2, yes,  no,   0, no) \
    SC(103,     30,       28,      3, yes,  no,   0, no) \
    SC(104,     30,       28,      4, yes,  no,   0, no) \
                                                         \
    SC(105,     31,       29,      1, yes,  no,   0, no) \
    SC(106,     31,       29,      2, yes,  no,   0, no) \
    SC(107,     31,       29,      3, yes,  no,   0, no) \
    SC(108,     31,       29,      4, yes,  no,   0, no) \
                                                         \
    SC(109,     32,       30,      1, yes,  no,   0, no) \
    SC(110,     32,       30,      2, yes,  no,   0, no) \
    SC(111,     32,       30,      3, yes,  no,   0, no) \
    SC(112,     32,       30,      4, yes,  no,   0, no) \
                                                         \
    SC(113,     33,       31,      1, yes,  no,   0, no) \
    SC(114,     33,       31,      2, yes,  no,   0, no) \
    SC(115,     33,       31,      3, yes,  no,   0, no) \
    SC(116,     33,       31,      4, yes,  no,   0, no) \
                                                         \
    SC(117,     34,       32,      1, yes,  no,   0, no) \
    SC(118,     34,       32,      2, yes,  no,   0, no) \
    SC(119,     34,       32,      3, yes,  no,   0, no) \
    SC(120,     34,       32,      4, yes,  no,   0, no) \
                                                         \
    SC(121,     35,       33,      1, yes,  no,   0, no) \
    SC(122,     35,       33,      2, yes,  no,   0, no) \
    SC(123,     35,       33,      3, yes,  no,   0, no) \
    SC(124,     35,       33,      4, yes,  no,   0, no) \
                                                         \
    SC(125,     36,       34,      1, yes,  no,   0, no) \
    SC(126,     36,       34,      2, yes,  no,   0, no) \
    SC(127,     36,       34,      3, yes,  no,   0, no) \
    SC(128,     36,       34,      4, yes,  no,   0, no) \
                                                         \
    SC(129,     37,       35,      1, yes,  no,   0, no) \
    SC(130,     37,       35,      2, yes,  no,   0, no) \
    SC(131,     37,       35,      3, yes,  no,   0, no) \
    SC(132,     37,       35,      4, yes,  no,   0, no) \
                                                         \
    SC(133,     38,       36,      1, yes,  no,   0, no) \
    SC(134,     38,       36,      2, yes,  no,   0, no) \
    SC(135,     38,       36,      3, yes,  no,   0, no) \
    SC(136,     38,       36,      4, yes,  no,   0, no) \
                                                         \
    SC(137,     39,       37,      1, yes,  no,   0, no) \
    SC(138,     39,       37,      2, yes,  no,   0, no) \
    SC(139,     39,       37,      3, yes,  no,   0, no) \
    SC(140,     39,       37,      4, yes,  no,   0, no) \
                                                         \
    SC(141,     40,       38,      1, yes,  no,   0, no) \
    SC(142,     40,       38,      2, yes,  no,   0, no) \
    SC(143,     40,       38,      3, yes,  no,   0, no) \
    SC(144,     40,       38,      4, yes,  no,   0, no) \
                                                         \
    SC(145,     41,       39,      1, yes,  no,   0, no) \
    SC(146,     41,       39,      2, yes,  no,   0, no) \
    SC(147,     41,       39,      3, yes,  no,   0, no) \
    SC(148,     41,       39,      4, yes,  no,   0, no) \
                                                         \
    SC(149,     42,       40,      1, yes,  no,   0, no) \
    SC(150,     42,       40,      2, yes,  no,   0, no) \
    SC(151,     42,       40,      3, yes,  no,   0, no) \
    SC(152,     42,       40,      4, yes,  no,   0, no) \
                                                         \
    SC(153,     43,       41,      1, yes,  no,   0, no) \
    SC(154,     43,       41,      2, yes,  no,   0, no) \
    SC(155,     43,       41,      3, yes,  no,   0, no) \
    SC(156,     43,       41,      4, yes,  no,   0, no) \
                                                         \
    SC(157,     44,       42,      1, yes,  no,   0, no) \
    SC(158,     44,       42,      2, yes,  no,   0, no) \
    SC(159,     44,       42,      3, yes,  no,   0, no) \
    SC(160,     44,       42,      4, yes,  no,   0, no) \
                                                         \
    SC(161,     45,       43,      1, yes,  no,   0, no) \
    SC(162,     45,       43,      2, yes,  no,   0, no) \
    SC(163,     45,       43,      3, yes,  no,   0, no) \
    SC(164,     45,       43,      4, yes,  no,   0, no) \
                                                         \
    SC(165,     46,       44,      1, yes,  no,   0, no) \
    SC(166,     46,       44,      2, yes,  no,   0, no) \
    SC(167,     46,       44,      3, yes,  no,   0, no) \
    SC(168,     46,       44,      4, yes,  no,   0, no) \
                                                         \
    SC(169,     47,       45,      1, yes,  no,   0, no) \
    SC(170,     47,       45,      2, yes,  no,   0, no) \
    SC(171,     47,       45,      3, yes,  no,   0, no) \
    SC(172,     47,       45,      4, yes,  no,   0, no) \
                                                         \
    SC(173,     48,       46,      1, yes,  no,   0, no) \
    SC(174,     48,       46,      2, yes,  no,   0, no) \
    SC(175,     48,       46,      3, yes,  no,   0, no) \
    SC(176,     48,       46,      4, yes,  no,   0, no) \
                                                         \
    SC(177,     49,       47,      1, yes,  no,   0, no) \
    SC(178,     49,       47,      2, yes,  no,   0, no) \
    SC(179,     49,       47,      3, yes,  no,   0, no) \
    SC(180,     49,       47,      4, yes,  no,   0, no) \
                                                         \
    SC(181,     50,       48,      1, yes,  no,   0, no) \
    SC(182,     50,       48,      2, yes,  no,   0, no) \
    SC(183,     50,       48,      3, yes,  no,   0, no) \
    SC(184,     50,       48,      4, yes,  no,   0, no) \
                                                         \
    SC(185,     51,       49,      1, yes,  no,   0, no) \
    SC(186,     51,       49,      2, yes,  no,   0, no) \
    SC(187,     51,       49,      3, yes,  no,   0, no) \
    SC(188,     51,       49,      4, yes,  no,   0, no) \
                                                         \
    SC(189,     52,       50,      1, yes,  no,   0, no) \
    SC(190,     52,       50,      2, yes,  no,   0, no) \
    SC(191,     52,       50,      3, yes,  no,   0, no) \
    SC(192,     52,       50,      4, yes,  no,   0, no) \
                                                         \
    SC(193,     53,       51,      1, yes,  no,   0, no) \
    SC(194,     53,       51,      2, yes,  no,   0, no) \
    SC(195,     53,       51,      3, yes,  no,   0, no) \
    SC(196,     53,       51,      4, yes,  no,   0, no) \
                                                         \
    SC(197,     54,       52,      1, yes,  no,   0, no) \
    SC(198,     54,       52,      2, yes,  no,   0, no) \
    SC(199,     54,       52,      3, yes,  no,   0, no) \
    SC(200,     54,       52,      4, yes,  no,   0, no) \
                                                         \
    SC(201,     55,       53,      1, yes,  no,   0, no) \
    SC(202,     55,       53,      2, yes,  no,   0, no) \
    SC(203,     55,       53,      3, yes,  no,   0, no) \
    SC(204,     55,       53,      4, yes,  no,   0, no) \
                                                         \
    SC(205,     56,       54,      1, yes,  no,   0, no) \
    SC(206,     56,       54,      2, yes,  no,   0, no) \
    SC(207,     56,       54,      3, yes,  no,   0, no) \
    SC(208,     56,       54,      4, yes,  no,   0, no) \
                                                         \
    SC(209,     57,       55,      1, yes,  no,   0, no) \
    SC(210,     57,       55,      2, yes,  no,   0, no) \
    SC(211,     57,       55,      3, yes,  no,   0, no) \
    SC(212,     57,       55,      4, yes,  no,   0, no) \
                                                         \
    SC(213,     58,       56,      1, yes,  no,   0, no) \
    SC(214,     58,       56,      2, yes,  no,   0, no) \
    SC(215,     58,       56,      3, yes,  no,   0, no) \
    SC(216,     58,       56,      4, yes,  no,   0, no) \
                                                         \
    SC(217,     59,       57,      1, yes,  no,   0, no) \
    SC(218,     59,       57,      2, yes,  no,   0, no) \
    SC(219,     59,       57,      3, yes,  no,   0, no) \
    SC(220,     59,       57,      4, yes,  no,   0, no) \
                                                         \
    SC(221,     60,       58,      1, yes,  no,   0, no) \
    SC(222,     60,       58,      2, yes,  no,   0, no) \
    SC(223,     60,       58,      3, yes,  no,   0, no) \
    SC(224,     60,       58,      4, yes,  no,   0, no) \
                                                         \
    SC(225,     61,       59,      1, yes,  no,   0, no) \
    SC(226,     61,       59,      2, yes,  no,   0, no) \
    SC(227,     61,       59,      3, yes,  no,   0, no) \
    SC(228,     61,       59,      4, yes,  no,   0, no) \
                                                         \
    SC(229,     62,       60,      1, yes,  no,   0, no) \
    SC(230,     62,       60,      2, yes,  no,   0, no) \
    SC(231,     62,       60,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			1
#define NLBINS			29
#define NBINS			36
#define NSIZES			232
#define LG_CEIL_NSIZES		8
#define NPSIZES			199
#define LG_TINY_MAXCLASS	3
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 13) + (((size_t)3) << 11))
#define LG_LARGE_MINCLASS	14
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 62) + (((size_t)3) << 60))
#endif

#if (LG_SIZEOF_PTR == 3 && LG_TINY_MIN == 4 && LG_QUANTUM == 4 && LG_PAGE == 12)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      4,        4,      0,  no, yes,   1,  4) \
    SC(  1,      4,        4,      1,  no, yes,   1,  4) \
    SC(  2,      4,        4,      2,  no, yes,   3,  4) \
    SC(  3,      4,        4,      3,  no, yes,   1,  4) \
                                                         \
    SC(  4,      6,        4,      1,  no, yes,   5,  4) \
    SC(  5,      6,        4,      2,  no, yes,   3,  4) \
    SC(  6,      6,        4,      3,  no, yes,   7,  4) \
    SC(  7,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC(  8,      7,        5,      1,  no, yes,   5,  5) \
    SC(  9,      7,        5,      2,  no, yes,   3,  5) \
    SC( 10,      7,        5,      3,  no, yes,   7,  5) \
    SC( 11,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 12,      8,        6,      1,  no, yes,   5,  6) \
    SC( 13,      8,        6,      2,  no, yes,   3,  6) \
    SC( 14,      8,        6,      3,  no, yes,   7,  6) \
    SC( 15,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 16,      9,        7,      1,  no, yes,   5,  7) \
    SC( 17,      9,        7,      2,  no, yes,   3,  7) \
    SC( 18,      9,        7,      3,  no, yes,   7,  7) \
    SC( 19,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 20,     10,        8,      1,  no, yes,   5,  8) \
    SC( 21,     10,        8,      2,  no, yes,   3,  8) \
    SC( 22,     10,        8,      3,  no, yes,   7,  8) \
    SC( 23,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 24,     11,        9,      1,  no, yes,   5,  9) \
    SC( 25,     11,        9,      2,  no, yes,   3,  9) \
    SC( 26,     11,        9,      3,  no, yes,   7,  9) \
    SC( 27,     11,        9,      4, yes, yes,   1,  9) \
                                                         \
    SC( 28,     12,       10,      1,  no, yes,   5, no) \
    SC( 29,     12,       10,      2,  no, yes,   3, no) \
    SC( 30,     12,       10,      3,  no, yes,   7, no) \
    SC( 31,     12,       10,      4, yes, yes,   2, no) \
                                                         \
    SC( 32,     13,       11,      1,  no, yes,   5, no) \
    SC( 33,     13,       11,      2, yes, yes,   3, no) \
    SC( 34,     13,       11,      3,  no, yes,   7, no) \
    SC( 35,     13,       11,      4, yes,  no,   0, no) \
                                                         \
    SC( 36,     14,       12,      1, yes,  no,   0, no) \
    SC( 37,     14,       12,      2, yes,  no,   0, no) \
    SC( 38,     14,       12,      3, yes,  no,   0, no) \
    SC( 39,     14,       12,      4, yes,  no,   0, no) \
                                                         \
    SC( 40,     15,       13,      1, yes,  no,   0, no) \
    SC( 41,     15,       13,      2, yes,  no,   0, no) \
    SC( 42,     15,       13,      3, yes,  no,   0, no) \
    SC( 43,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 44,     16,       14,      1, yes,  no,   0, no) \
    SC( 45,     16,       14,      2, yes,  no,   0, no) \
    SC( 46,     16,       14,      3, yes,  no,   0, no) \
    SC( 47,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 48,     17,       15,      1, yes,  no,   0, no) \
    SC( 49,     17,       15,      2, yes,  no,   0, no) \
    SC( 50,     17,       15,      3, yes,  no,   0, no) \
    SC( 51,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 52,     18,       16,      1, yes,  no,   0, no) \
    SC( 53,     18,       16,      2, yes,  no,   0, no) \
    SC( 54,     18,       16,      3, yes,  no,   0, no) \
    SC( 55,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 56,     19,       17,      1, yes,  no,   0, no) \
    SC( 57,     19,       17,      2, yes,  no,   0, no) \
    SC( 58,     19,       17,      3, yes,  no,   0, no) \
    SC( 59,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 60,     20,       18,      1, yes,  no,   0, no) \
    SC( 61,     20,       18,      2, yes,  no,   0, no) \
    SC( 62,     20,       18,      3, yes,  no,   0, no) \
    SC( 63,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 64,     21,       19,      1, yes,  no,   0, no) \
    SC( 65,     21,       19,      2, yes,  no,   0, no) \
    SC( 66,     21,       19,      3, yes,  no,   0, no) \
    SC( 67,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 68,     22,       20,      1, yes,  no,   0, no) \
    SC( 69,     22,       20,      2, yes,  no,   0, no) \
    SC( 70,     22,       20,      3, yes,  no,   0, no) \
    SC( 71,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 72,     23,       21,      1, yes,  no,   0, no) \
    SC( 73,     23,       21,      2, yes,  no,   0, no) \
    SC( 74,     23,       21,      3, yes,  no,   0, no) \
    SC( 75,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 76,     24,       22,      1, yes,  no,   0, no) \
    SC( 77,     24,       22,      2, yes,  no,   0, no) \
    SC( 78,     24,       22,      3, yes,  no,   0, no) \
    SC( 79,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 80,     25,       23,      1, yes,  no,   0, no) \
    SC( 81,     25,       23,      2, yes,  no,   0, no) \
    SC( 82,     25,       23,      3, yes,  no,   0, no) \
    SC( 83,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 84,     26,       24,      1, yes,  no,   0, no) \
    SC( 85,     26,       24,      2, yes,  no,   0, no) \
    SC( 86,     26,       24,      3, yes,  no,   0, no) \
    SC( 87,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 88,     27,       25,      1, yes,  no,   0, no) \
    SC( 89,     27,       25,      2, yes,  no,   0, no) \
    SC( 90,     27,       25,      3, yes,  no,   0, no) \
    SC( 91,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 92,     28,       26,      1, yes,  no,   0, no) \
    SC( 93,     28,       26,      2, yes,  no,   0, no) \
    SC( 94,     28,       26,      3, yes,  no,   0, no) \
    SC( 95,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC( 96,     29,       27,      1, yes,  no,   0, no) \
    SC( 97,     29,       27,      2, yes,  no,   0, no) \
    SC( 98,     29,       27,      3, yes,  no,   0, no) \
    SC( 99,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(100,     30,       28,      1, yes,  no,   0, no) \
    SC(101,     30,       28,      2, yes,  no,   0, no) \
    SC(102,     30,       28,      3, yes,  no,   0, no) \
    SC(103,     30,       28,      4, yes,  no,   0, no) \
                                                         \
    SC(104,     31,       29,      1, yes,  no,   0, no) \
    SC(105,     31,       29,      2, yes,  no,   0, no) \
    SC(106,     31,       29,      3, yes,  no,   0, no) \
    SC(107,     31,       29,      4, yes,  no,   0, no) \
                                                         \
    SC(108,     32,       30,      1, yes,  no,   0, no) \
    SC(109,     32,       30,      2, yes,  no,   0, no) \
    SC(110,     32,       30,      3, yes,  no,   0, no) \
    SC(111,     32,       30,      4, yes,  no,   0, no) \
                                                         \
    SC(112,     33,       31,      1, yes,  no,   0, no) \
    SC(113,     33,       31,      2, yes,  no,   0, no) \
    SC(114,     33,       31,      3, yes,  no,   0, no) \
    SC(115,     33,       31,      4, yes,  no,   0, no) \
                                                         \
    SC(116,     34,       32,      1, yes,  no,   0, no) \
    SC(117,     34,       32,      2, yes,  no,   0, no) \
    SC(118,     34,       32,      3, yes,  no,   0, no) \
    SC(119,     34,       32,      4, yes,  no,   0, no) \
                                                         \
    SC(120,     35,       33,      1, yes,  no,   0, no) \
    SC(121,     35,       33,      2, yes,  no,   0, no) \
    SC(122,     35,       33,      3, yes,  no,   0, no) \
    SC(123,     35,       33,      4, yes,  no,   0, no) \
                                                         \
    SC(124,     36,       34,      1, yes,  no,   0, no) \
    SC(125,     36,       34,      2, yes,  no,   0, no) \
    SC(126,     36,       34,      3, yes,  no,   0, no) \
    SC(127,     36,       34,      4, yes,  no,   0, no) \
                                                         \
    SC(128,     37,       35,      1, yes,  no,   0, no) \
    SC(129,     37,       35,      2, yes,  no,   0, no) \
    SC(130,     37,       35,      3, yes,  no,   0, no) \
    SC(131,     37,       35,      4, yes,  no,   0, no) \
                                                         \
    SC(132,     38,       36,      1, yes,  no,   0, no) \
    SC(133,     38,       36,      2, yes,  no,   0, no) \
    SC(134,     38,       36,      3, yes,  no,   0, no) \
    SC(135,     38,       36,      4, yes,  no,   0, no) \
                                                         \
    SC(136,     39,       37,      1, yes,  no,   0, no) \
    SC(137,     39,       37,      2, yes,  no,   0, no) \
    SC(138,     39,       37,      3, yes,  no,   0, no) \
    SC(139,     39,       37,      4, yes,  no,   0, no) \
                                                         \
    SC(140,     40,       38,      1, yes,  no,   0, no) \
    SC(141,     40,       38,      2, yes,  no,   0, no) \
    SC(142,     40,       38,      3, yes,  no,   0, no) \
    SC(143,     40,       38,      4, yes,  no,   0, no) \
                                                         \
    SC(144,     41,       39,      1, yes,  no,   0, no) \
    SC(145,     41,       39,      2, yes,  no,   0, no) \
    SC(146,     41,       39,      3, yes,  no,   0, no) \
    SC(147,     41,       39,      4, yes,  no,   0, no) \
                                                         \
    SC(148,     42,       40,      1, yes,  no,   0, no) \
    SC(149,     42,       40,      2, yes,  no,   0, no) \
    SC(150,     42,       40,      3, yes,  no,   0, no) \
    SC(151,     42,       40,      4, yes,  no,   0, no) \
                                                         \
    SC(152,     43,       41,      1, yes,  no,   0, no) \
    SC(153,     43,       41,      2, yes,  no,   0, no) \
    SC(154,     43,       41,      3, yes,  no,   0, no) \
    SC(155,     43,       41,      4, yes,  no,   0, no) \
                                                         \
    SC(156,     44,       42,      1, yes,  no,   0, no) \
    SC(157,     44,       42,      2, yes,  no,   0, no) \
    SC(158,     44,       42,      3, yes,  no,   0, no) \
    SC(159,     44,       42,      4, yes,  no,   0, no) \
                                                         \
    SC(160,     45,       43,      1, yes,  no,   0, no) \
    SC(161,     45,       43,      2, yes,  no,   0, no) \
    SC(162,     45,       43,      3, yes,  no,   0, no) \
    SC(163,     45,       43,      4, yes,  no,   0, no) \
                                                         \
    SC(164,     46,       44,      1, yes,  no,   0, no) \
    SC(165,     46,       44,      2, yes,  no,   0, no) \
    SC(166,     46,       44,      3, yes,  no,   0, no) \
    SC(167,     46,       44,      4, yes,  no,   0, no) \
                                                         \
    SC(168,     47,       45,      1, yes,  no,   0, no) \
    SC(169,     47,       45,      2, yes,  no,   0, no) \
    SC(170,     47,       45,      3, yes,  no,   0, no) \
    SC(171,     47,       45,      4, yes,  no,   0, no) \
                                                         \
    SC(172,     48,       46,      1, yes,  no,   0, no) \
    SC(173,     48,       46,      2, yes,  no,   0, no) \
    SC(174,     48,       46,      3, yes,  no,   0, no) \
    SC(175,     48,       46,      4, yes,  no,   0, no) \
                                                         \
    SC(176,     49,       47,      1, yes,  no,   0, no) \
    SC(177,     49,       47,      2, yes,  no,   0, no) \
    SC(178,     49,       47,      3, yes,  no,   0, no) \
    SC(179,     49,       47,      4, yes,  no,   0, no) \
                                                         \
    SC(180,     50,       48,      1, yes,  no,   0, no) \
    SC(181,     50,       48,      2, yes,  no,   0, no) \
    SC(182,     50,       48,      3, yes,  no,   0, no) \
    SC(183,     50,       48,      4, yes,  no,   0, no) \
                                                         \
    SC(184,     51,       49,      1, yes,  no,   0, no) \
    SC(185,     51,       49,      2, yes,  no,   0, no) \
    SC(186,     51,       49,      3, yes,  no,   0, no) \
    SC(187,     51,       49,      4, yes,  no,   0, no) \
                                                         \
    SC(188,     52,       50,      1, yes,  no,   0, no) \
    SC(189,     52,       50,      2, yes,  no,   0, no) \
    SC(190,     52,       50,      3, yes,  no,   0, no) \
    SC(191,     52,       50,      4, yes,  no,   0, no) \
                                                         \
    SC(192,     53,       51,      1, yes,  no,   0, no) \
    SC(193,     53,       51,      2, yes,  no,   0, no) \
    SC(194,     53,       51,      3, yes,  no,   0, no) \
    SC(195,     53,       51,      4, yes,  no,   0, no) \
                                                         \
    SC(196,     54,       52,      1, yes,  no,   0, no) \
    SC(197,     54,       52,      2, yes,  no,   0, no) \
    SC(198,     54,       52,      3, yes,  no,   0, no) \
    SC(199,     54,       52,      4, yes,  no,   0, no) \
                                                         \
    SC(200,     55,       53,      1, yes,  no,   0, no) \
    SC(201,     55,       53,      2, yes,  no,   0, no) \
    SC(202,     55,       53,      3, yes,  no,   0, no) \
    SC(203,     55,       53,      4, yes,  no,   0, no) \
                                                         \
    SC(204,     56,       54,      1, yes,  no,   0, no) \
    SC(205,     56,       54,      2, yes,  no,   0, no) \
    SC(206,     56,       54,      3, yes,  no,   0, no) \
    SC(207,     56,       54,      4, yes,  no,   0, no) \
                                                         \
    SC(208,     57,       55,      1, yes,  no,   0, no) \
    SC(209,     57,       55,      2, yes,  no,   0, no) \
    SC(210,     57,       55,      3, yes,  no,   0, no) \
    SC(211,     57,       55,      4, yes,  no,   0, no) \
                                                         \
    SC(212,     58,       56,      1, yes,  no,   0, no) \
    SC(213,     58,       56,      2, yes,  no,   0, no) \
    SC(214,     58,       56,      3, yes,  no,   0, no) \
    SC(215,     58,       56,      4, yes,  no,   0, no) \
                                                         \
    SC(216,     59,       57,      1, yes,  no,   0, no) \
    SC(217,     59,       57,      2, yes,  no,   0, no) \
    SC(218,     59,       57,      3, yes,  no,   0, no) \
    SC(219,     59,       57,      4, yes,  no,   0, no) \
                                                         \
    SC(220,     60,       58,      1, yes,  no,   0, no) \
    SC(221,     60,       58,      2, yes,  no,   0, no) \
    SC(222,     60,       58,      3, yes,  no,   0, no) \
    SC(223,     60,       58,      4, yes,  no,   0, no) \
                                                         \
    SC(224,     61,       59,      1, yes,  no,   0, no) \
    SC(225,     61,       59,      2, yes,  no,   0, no) \
    SC(226,     61,       59,      3, yes,  no,   0, no) \
    SC(227,     61,       59,      4, yes,  no,   0, no) \
                                                         \
    SC(228,     62,       60,      1, yes,  no,   0, no) \
    SC(229,     62,       60,      2, yes,  no,   0, no) \
    SC(230,     62,       60,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			0
#define NLBINS			28
#define NBINS			35
#define NSIZES			231
#define LG_CEIL_NSIZES		8
#define NPSIZES			199
#define LG_TINY_MAXCLASS	"NA"
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 13) + (((size_t)3) << 11))
#define LG_LARGE_MINCLASS	14
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 62) + (((size_t)3) << 60))
#endif

#if (LG_SIZEOF_PTR == 2 && LG_TINY_MIN == 3 && LG_QUANTUM == 3 && LG_PAGE == 13)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      3,        3,      0,  no, yes,   1,  3) \
    SC(  1,      3,        3,      1,  no, yes,   1,  3) \
    SC(  2,      3,        3,      2,  no, yes,   3,  3) \
    SC(  3,      3,        3,      3,  no, yes,   1,  3) \
                                                         \
    SC(  4,      5,        3,      1,  no, yes,   5,  3) \
    SC(  5,      5,        3,      2,  no, yes,   3,  3) \
    SC(  6,      5,        3,      3,  no, yes,   7,  3) \
    SC(  7,      5,        3,      4,  no, yes,   1,  3) \
                                                         \
    SC(  8,      6,        4,      1,  no, yes,   5,  4) \
    SC(  9,      6,        4,      2,  no, yes,   3,  4) \
    SC( 10,      6,        4,      3,  no, yes,   7,  4) \
    SC( 11,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC( 12,      7,        5,      1,  no, yes,   5,  5) \
    SC( 13,      7,        5,      2,  no, yes,   3,  5) \
    SC( 14,      7,        5,      3,  no, yes,   7,  5) \
    SC( 15,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 16,      8,        6,      1,  no, yes,   5,  6) \
    SC( 17,      8,        6,      2,  no, yes,   3,  6) \
    SC( 18,      8,        6,      3,  no, yes,   7,  6) \
    SC( 19,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 20,      9,        7,      1,  no, yes,   5,  7) \
    SC( 21,      9,        7,      2,  no, yes,   3,  7) \
    SC( 22,      9,        7,      3,  no, yes,   7,  7) \
    SC( 23,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 24,     10,        8,      1,  no, yes,   5,  8) \
    SC( 25,     10,        8,      2,  no, yes,   3,  8) \
    SC( 26,     10,        8,      3,  no, yes,   7,  8) \
    SC( 27,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 28,     11,        9,      1,  no, yes,   5,  9) \
    SC( 29,     11,        9,      2,  no, yes,   3,  9) \
    SC( 30,     11,        9,      3,  no, yes,   7,  9) \
    SC( 31,     11,        9,      4,  no, yes,   1,  9) \
                                                         \
    SC( 32,     12,       10,      1,  no, yes,   5, no) \
    SC( 33,     12,       10,      2,  no, yes,   3, no) \
    SC( 34,     12,       10,      3,  no, yes,   7, no) \
    SC( 35,     12,       10,      4, yes, yes,   1, no) \
                                                         \
    SC( 36,     13,       11,      1,  no, yes,   5, no) \
    SC( 37,     13,       11,      2,  no, yes,   3, no) \
    SC( 38,     13,       11,      3,  no, yes,   7, no) \
    SC( 39,     13,       11,      4, yes, yes,   2, no) \
                                                         \
    SC( 40,     14,       12,      1,  no, yes,   5, no) \
    SC( 41,     14,       12,      2, yes, yes,   3, no) \
    SC( 42,     14,       12,      3,  no, yes,   7, no) \
    SC( 43,     14,       12,      4, yes,  no,   0, no) \
                                                         \
    SC( 44,     15,       13,      1, yes,  no,   0, no) \
    SC( 45,     15,       13,      2, yes,  no,   0, no) \
    SC( 46,     15,       13,      3, yes,  no,   0, no) \
    SC( 47,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 48,     16,       14,      1, yes,  no,   0, no) \
    SC( 49,     16,       14,      2, yes,  no,   0, no) \
    SC( 50,     16,       14,      3, yes,  no,   0, no) \
    SC( 51,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 52,     17,       15,      1, yes,  no,   0, no) \
    SC( 53,     17,       15,      2, yes,  no,   0, no) \
    SC( 54,     17,       15,      3, yes,  no,   0, no) \
    SC( 55,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 56,     18,       16,      1, yes,  no,   0, no) \
    SC( 57,     18,       16,      2, yes,  no,   0, no) \
    SC( 58,     18,       16,      3, yes,  no,   0, no) \
    SC( 59,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 60,     19,       17,      1, yes,  no,   0, no) \
    SC( 61,     19,       17,      2, yes,  no,   0, no) \
    SC( 62,     19,       17,      3, yes,  no,   0, no) \
    SC( 63,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 64,     20,       18,      1, yes,  no,   0, no) \
    SC( 65,     20,       18,      2, yes,  no,   0, no) \
    SC( 66,     20,       18,      3, yes,  no,   0, no) \
    SC( 67,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 68,     21,       19,      1, yes,  no,   0, no) \
    SC( 69,     21,       19,      2, yes,  no,   0, no) \
    SC( 70,     21,       19,      3, yes,  no,   0, no) \
    SC( 71,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 72,     22,       20,      1, yes,  no,   0, no) \
    SC( 73,     22,       20,      2, yes,  no,   0, no) \
    SC( 74,     22,       20,      3, yes,  no,   0, no) \
    SC( 75,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 76,     23,       21,      1, yes,  no,   0, no) \
    SC( 77,     23,       21,      2, yes,  no,   0, no) \
    SC( 78,     23,       21,      3, yes,  no,   0, no) \
    SC( 79,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 80,     24,       22,      1, yes,  no,   0, no) \
    SC( 81,     24,       22,      2, yes,  no,   0, no) \
    SC( 82,     24,       22,      3, yes,  no,   0, no) \
    SC( 83,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 84,     25,       23,      1, yes,  no,   0, no) \
    SC( 85,     25,       23,      2, yes,  no,   0, no) \
    SC( 86,     25,       23,      3, yes,  no,   0, no) \
    SC( 87,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 88,     26,       24,      1, yes,  no,   0, no) \
    SC( 89,     26,       24,      2, yes,  no,   0, no) \
    SC( 90,     26,       24,      3, yes,  no,   0, no) \
    SC( 91,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 92,     27,       25,      1, yes,  no,   0, no) \
    SC( 93,     27,       25,      2, yes,  no,   0, no) \
    SC( 94,     27,       25,      3, yes,  no,   0, no) \
    SC( 95,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 96,     28,       26,      1, yes,  no,   0, no) \
    SC( 97,     28,       26,      2, yes,  no,   0, no) \
    SC( 98,     28,       26,      3, yes,  no,   0, no) \
    SC( 99,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC(100,     29,       27,      1, yes,  no,   0, no) \
    SC(101,     29,       27,      2, yes,  no,   0, no) \
    SC(102,     29,       27,      3, yes,  no,   0, no) \
    SC(103,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(104,     30,       28,      1, yes,  no,   0, no) \
    SC(105,     30,       28,      2, yes,  no,   0, no) \
    SC(106,     30,       28,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			0
#define NLBINS			32
#define NBINS			43
#define NSIZES			107
#define LG_CEIL_NSIZES		7
#define NPSIZES			67
#define LG_TINY_MAXCLASS	"NA"
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 14) + (((size_t)3) << 12))
#define LG_LARGE_MINCLASS	15
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 30) + (((size_t)3) << 28))
#endif

#if (LG_SIZEOF_PTR == 2 && LG_TINY_MIN == 3 && LG_QUANTUM == 4 && LG_PAGE == 13)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      3,        3,      0,  no, yes,   1,  3) \
                                                         \
    SC(  1,      3,        3,      1,  no, yes,   1,  3) \
    SC(  2,      4,        4,      1,  no, yes,   1,  4) \
    SC(  3,      4,        4,      2,  no, yes,   3,  4) \
    SC(  4,      4,        4,      3,  no, yes,   1,  4) \
                                                         \
    SC(  5,      6,        4,      1,  no, yes,   5,  4) \
    SC(  6,      6,        4,      2,  no, yes,   3,  4) \
    SC(  7,      6,        4,      3,  no, yes,   7,  4) \
    SC(  8,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC(  9,      7,        5,      1,  no, yes,   5,  5) \
    SC( 10,      7,        5,      2,  no, yes,   3,  5) \
    SC( 11,      7,        5,      3,  no, yes,   7,  5) \
    SC( 12,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 13,      8,        6,      1,  no, yes,   5,  6) \
    SC( 14,      8,        6,      2,  no, yes,   3,  6) \
    SC( 15,      8,        6,      3,  no, yes,   7,  6) \
    SC( 16,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 17,      9,        7,      1,  no, yes,   5,  7) \
    SC( 18,      9,        7,      2,  no, yes,   3,  7) \
    SC( 19,      9,        7,      3,  no, yes,   7,  7) \
    SC( 20,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 21,     10,        8,      1,  no, yes,   5,  8) \
    SC( 22,     10,        8,      2,  no, yes,   3,  8) \
    SC( 23,     10,        8,      3,  no, yes,   7,  8) \
    SC( 24,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 25,     11,        9,      1,  no, yes,   5,  9) \
    SC( 26,     11,        9,      2,  no, yes,   3,  9) \
    SC( 27,     11,        9,      3,  no, yes,   7,  9) \
    SC( 28,     11,        9,      4,  no, yes,   1,  9) \
                                                         \
    SC( 29,     12,       10,      1,  no, yes,   5, no) \
    SC( 30,     12,       10,      2,  no, yes,   3, no) \
    SC( 31,     12,       10,      3,  no, yes,   7, no) \
    SC( 32,     12,       10,      4, yes, yes,   1, no) \
                                                         \
    SC( 33,     13,       11,      1,  no, yes,   5, no) \
    SC( 34,     13,       11,      2,  no, yes,   3, no) \
    SC( 35,     13,       11,      3,  no, yes,   7, no) \
    SC( 36,     13,       11,      4, yes, yes,   2, no) \
                                                         \
    SC( 37,     14,       12,      1,  no, yes,   5, no) \
    SC( 38,     14,       12,      2, yes, yes,   3, no) \
    SC( 39,     14,       12,      3,  no, yes,   7, no) \
    SC( 40,     14,       12,      4, yes,  no,   0, no) \
                                                         \
    SC( 41,     15,       13,      1, yes,  no,   0, no) \
    SC( 42,     15,       13,      2, yes,  no,   0, no) \
    SC( 43,     15,       13,      3, yes,  no,   0, no) \
    SC( 44,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 45,     16,       14,      1, yes,  no,   0, no) \
    SC( 46,     16,       14,      2, yes,  no,   0, no) \
    SC( 47,     16,       14,      3, yes,  no,   0, no) \
    SC( 48,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 49,     17,       15,      1, yes,  no,   0, no) \
    SC( 50,     17,       15,      2, yes,  no,   0, no) \
    SC( 51,     17,       15,      3, yes,  no,   0, no) \
    SC( 52,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 53,     18,       16,      1, yes,  no,   0, no) \
    SC( 54,     18,       16,      2, yes,  no,   0, no) \
    SC( 55,     18,       16,      3, yes,  no,   0, no) \
    SC( 56,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 57,     19,       17,      1, yes,  no,   0, no) \
    SC( 58,     19,       17,      2, yes,  no,   0, no) \
    SC( 59,     19,       17,      3, yes,  no,   0, no) \
    SC( 60,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 61,     20,       18,      1, yes,  no,   0, no) \
    SC( 62,     20,       18,      2, yes,  no,   0, no) \
    SC( 63,     20,       18,      3, yes,  no,   0, no) \
    SC( 64,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 65,     21,       19,      1, yes,  no,   0, no) \
    SC( 66,     21,       19,      2, yes,  no,   0, no) \
    SC( 67,     21,       19,      3, yes,  no,   0, no) \
    SC( 68,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 69,     22,       20,      1, yes,  no,   0, no) \
    SC( 70,     22,       20,      2, yes,  no,   0, no) \
    SC( 71,     22,       20,      3, yes,  no,   0, no) \
    SC( 72,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 73,     23,       21,      1, yes,  no,   0, no) \
    SC( 74,     23,       21,      2, yes,  no,   0, no) \
    SC( 75,     23,       21,      3, yes,  no,   0, no) \
    SC( 76,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 77,     24,       22,      1, yes,  no,   0, no) \
    SC( 78,     24,       22,      2, yes,  no,   0, no) \
    SC( 79,     24,       22,      3, yes,  no,   0, no) \
    SC( 80,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 81,     25,       23,      1, yes,  no,   0, no) \
    SC( 82,     25,       23,      2, yes,  no,   0, no) \
    SC( 83,     25,       23,      3, yes,  no,   0, no) \
    SC( 84,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 85,     26,       24,      1, yes,  no,   0, no) \
    SC( 86,     26,       24,      2, yes,  no,   0, no) \
    SC( 87,     26,       24,      3, yes,  no,   0, no) \
    SC( 88,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 89,     27,       25,      1, yes,  no,   0, no) \
    SC( 90,     27,       25,      2, yes,  no,   0, no) \
    SC( 91,     27,       25,      3, yes,  no,   0, no) \
    SC( 92,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 93,     28,       26,      1, yes,  no,   0, no) \
    SC( 94,     28,       26,      2, yes,  no,   0, no) \
    SC( 95,     28,       26,      3, yes,  no,   0, no) \
    SC( 96,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC( 97,     29,       27,      1, yes,  no,   0, no) \
    SC( 98,     29,       27,      2, yes,  no,   0, no) \
    SC( 99,     29,       27,      3, yes,  no,   0, no) \
    SC(100,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(101,     30,       28,      1, yes,  no,   0, no) \
    SC(102,     30,       28,      2, yes,  no,   0, no) \
    SC(103,     30,       28,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			1
#define NLBINS			29
#define NBINS			40
#define NSIZES			104
#define LG_CEIL_NSIZES		7
#define NPSIZES			67
#define LG_TINY_MAXCLASS	3
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 14) + (((size_t)3) << 12))
#define LG_LARGE_MINCLASS	15
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 30) + (((size_t)3) << 28))
#endif

#if (LG_SIZEOF_PTR == 2 && LG_TINY_MIN == 4 && LG_QUANTUM == 4 && LG_PAGE == 13)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      4,        4,      0,  no, yes,   1,  4) \
    SC(  1,      4,        4,      1,  no, yes,   1,  4) \
    SC(  2,      4,        4,      2,  no, yes,   3,  4) \
    SC(  3,      4,        4,      3,  no, yes,   1,  4) \
                                                         \
    SC(  4,      6,        4,      1,  no, yes,   5,  4) \
    SC(  5,      6,        4,      2,  no, yes,   3,  4) \
    SC(  6,      6,        4,      3,  no, yes,   7,  4) \
    SC(  7,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC(  8,      7,        5,      1,  no, yes,   5,  5) \
    SC(  9,      7,        5,      2,  no, yes,   3,  5) \
    SC( 10,      7,        5,      3,  no, yes,   7,  5) \
    SC( 11,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 12,      8,        6,      1,  no, yes,   5,  6) \
    SC( 13,      8,        6,      2,  no, yes,   3,  6) \
    SC( 14,      8,        6,      3,  no, yes,   7,  6) \
    SC( 15,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 16,      9,        7,      1,  no, yes,   5,  7) \
    SC( 17,      9,        7,      2,  no, yes,   3,  7) \
    SC( 18,      9,        7,      3,  no, yes,   7,  7) \
    SC( 19,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 20,     10,        8,      1,  no, yes,   5,  8) \
    SC( 21,     10,        8,      2,  no, yes,   3,  8) \
    SC( 22,     10,        8,      3,  no, yes,   7,  8) \
    SC( 23,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 24,     11,        9,      1,  no, yes,   5,  9) \
    SC( 25,     11,        9,      2,  no, yes,   3,  9) \
    SC( 26,     11,        9,      3,  no, yes,   7,  9) \
    SC( 27,     11,        9,      4,  no, yes,   1,  9) \
                                                         \
    SC( 28,     12,       10,      1,  no, yes,   5, no) \
    SC( 29,     12,       10,      2,  no, yes,   3, no) \
    SC( 30,     12,       10,      3,  no, yes,   7, no) \
    SC( 31,     12,       10,      4, yes, yes,   1, no) \
                                                         \
    SC( 32,     13,       11,      1,  no, yes,   5, no) \
    SC( 33,     13,       11,      2,  no, yes,   3, no) \
    SC( 34,     13,       11,      3,  no, yes,   7, no) \
    SC( 35,     13,       11,      4, yes, yes,   2, no) \
                                                         \
    SC( 36,     14,       12,      1,  no, yes,   5, no) \
    SC( 37,     14,       12,      2, yes, yes,   3, no) \
    SC( 38,     14,       12,      3,  no, yes,   7, no) \
    SC( 39,     14,       12,      4, yes,  no,   0, no) \
                                                         \
    SC( 40,     15,       13,      1, yes,  no,   0, no) \
    SC( 41,     15,       13,      2, yes,  no,   0, no) \
    SC( 42,     15,       13,      3, yes,  no,   0, no) \
    SC( 43,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 44,     16,       14,      1, yes,  no,   0, no) \
    SC( 45,     16,       14,      2, yes,  no,   0, no) \
    SC( 46,     16,       14,      3, yes,  no,   0, no) \
    SC( 47,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 48,     17,       15,      1, yes,  no,   0, no) \
    SC( 49,     17,       15,      2, yes,  no,   0, no) \
    SC( 50,     17,       15,      3, yes,  no,   0, no) \
    SC( 51,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 52,     18,       16,      1, yes,  no,   0, no) \
    SC( 53,     18,       16,      2, yes,  no,   0, no) \
    SC( 54,     18,       16,      3, yes,  no,   0, no) \
    SC( 55,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 56,     19,       17,      1, yes,  no,   0, no) \
    SC( 57,     19,       17,      2, yes,  no,   0, no) \
    SC( 58,     19,       17,      3, yes,  no,   0, no) \
    SC( 59,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 60,     20,       18,      1, yes,  no,   0, no) \
    SC( 61,     20,       18,      2, yes,  no,   0, no) \
    SC( 62,     20,       18,      3, yes,  no,   0, no) \
    SC( 63,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 64,     21,       19,      1, yes,  no,   0, no) \
    SC( 65,     21,       19,      2, yes,  no,   0, no) \
    SC( 66,     21,       19,      3, yes,  no,   0, no) \
    SC( 67,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 68,     22,       20,      1, yes,  no,   0, no) \
    SC( 69,     22,       20,      2, yes,  no,   0, no) \
    SC( 70,     22,       20,      3, yes,  no,   0, no) \
    SC( 71,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 72,     23,       21,      1, yes,  no,   0, no) \
    SC( 73,     23,       21,      2, yes,  no,   0, no) \
    SC( 74,     23,       21,      3, yes,  no,   0, no) \
    SC( 75,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 76,     24,       22,      1, yes,  no,   0, no) \
    SC( 77,     24,       22,      2, yes,  no,   0, no) \
    SC( 78,     24,       22,      3, yes,  no,   0, no) \
    SC( 79,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 80,     25,       23,      1, yes,  no,   0, no) \
    SC( 81,     25,       23,      2, yes,  no,   0, no) \
    SC( 82,     25,       23,      3, yes,  no,   0, no) \
    SC( 83,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 84,     26,       24,      1, yes,  no,   0, no) \
    SC( 85,     26,       24,      2, yes,  no,   0, no) \
    SC( 86,     26,       24,      3, yes,  no,   0, no) \
    SC( 87,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 88,     27,       25,      1, yes,  no,   0, no) \
    SC( 89,     27,       25,      2, yes,  no,   0, no) \
    SC( 90,     27,       25,      3, yes,  no,   0, no) \
    SC( 91,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 92,     28,       26,      1, yes,  no,   0, no) \
    SC( 93,     28,       26,      2, yes,  no,   0, no) \
    SC( 94,     28,       26,      3, yes,  no,   0, no) \
    SC( 95,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC( 96,     29,       27,      1, yes,  no,   0, no) \
    SC( 97,     29,       27,      2, yes,  no,   0, no) \
    SC( 98,     29,       27,      3, yes,  no,   0, no) \
    SC( 99,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(100,     30,       28,      1, yes,  no,   0, no) \
    SC(101,     30,       28,      2, yes,  no,   0, no) \
    SC(102,     30,       28,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			0
#define NLBINS			28
#define NBINS			39
#define NSIZES			103
#define LG_CEIL_NSIZES		7
#define NPSIZES			67
#define LG_TINY_MAXCLASS	"NA"
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 14) + (((size_t)3) << 12))
#define LG_LARGE_MINCLASS	15
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 30) + (((size_t)3) << 28))
#endif

#if (LG_SIZEOF_PTR == 3 && LG_TINY_MIN == 3 && LG_QUANTUM == 3 && LG_PAGE == 13)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      3,        3,      0,  no, yes,   1,  3) \
    SC(  1,      3,        3,      1,  no, yes,   1,  3) \
    SC(  2,      3,        3,      2,  no, yes,   3,  3) \
    SC(  3,      3,        3,      3,  no, yes,   1,  3) \
                                                         \
    SC(  4,      5,        3,      1,  no, yes,   5,  3) \
    SC(  5,      5,        3,      2,  no, yes,   3,  3) \
    SC(  6,      5,        3,      3,  no, yes,   7,  3) \
    SC(  7,      5,        3,      4,  no, yes,   1,  3) \
                                                         \
    SC(  8,      6,        4,      1,  no, yes,   5,  4) \
    SC(  9,      6,        4,      2,  no, yes,   3,  4) \
    SC( 10,      6,        4,      3,  no, yes,   7,  4) \
    SC( 11,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC( 12,      7,        5,      1,  no, yes,   5,  5) \
    SC( 13,      7,        5,      2,  no, yes,   3,  5) \
    SC( 14,      7,        5,      3,  no, yes,   7,  5) \
    SC( 15,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 16,      8,        6,      1,  no, yes,   5,  6) \
    SC( 17,      8,        6,      2,  no, yes,   3,  6) \
    SC( 18,      8,        6,      3,  no, yes,   7,  6) \
    SC( 19,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 20,      9,        7,      1,  no, yes,   5,  7) \
    SC( 21,      9,        7,      2,  no, yes,   3,  7) \
    SC( 22,      9,        7,      3,  no, yes,   7,  7) \
    SC( 23,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 24,     10,        8,      1,  no, yes,   5,  8) \
    SC( 25,     10,        8,      2,  no, yes,   3,  8) \
    SC( 26,     10,        8,      3,  no, yes,   7,  8) \
    SC( 27,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 28,     11,        9,      1,  no, yes,   5,  9) \
    SC( 29,     11,        9,      2,  no, yes,   3,  9) \
    SC( 30,     11,        9,      3,  no, yes,   7,  9) \
    SC( 31,     11,        9,      4,  no, yes,   1,  9) \
                                                         \
    SC( 32,     12,       10,      1,  no, yes,   5, no) \
    SC( 33,     12,       10,      2,  no, yes,   3, no) \
    SC( 34,     12,       10,      3,  no, yes,   7, no) \
    SC( 35,     12,       10,      4, yes, yes,   1, no) \
                                                         \
    SC( 36,     13,       11,      1,  no, yes,   5, no) \
    SC( 37,     13,       11,      2,  no, yes,   3, no) \
    SC( 38,     13,       11,      3,  no, yes,   7, no) \
    SC( 39,     13,       11,      4, yes, yes,   2, no) \
                                                         \
    SC( 40,     14,       12,      1,  no, yes,   5, no) \
    SC( 41,     14,       12,      2, yes, yes,   3, no) \
    SC( 42,     14,       12,      3,  no, yes,   7, no) \
    SC( 43,     14,       12,      4, yes,  no,   0, no) \
                                                         \
    SC( 44,     15,       13,      1, yes,  no,   0, no) \
    SC( 45,     15,       13,      2, yes,  no,   0, no) \
    SC( 46,     15,       13,      3, yes,  no,   0, no) \
    SC( 47,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 48,     16,       14,      1, yes,  no,   0, no) \
    SC( 49,     16,       14,      2, yes,  no,   0, no) \
    SC( 50,     16,       14,      3, yes,  no,   0, no) \
    SC( 51,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 52,     17,       15,      1, yes,  no,   0, no) \
    SC( 53,     17,       15,      2, yes,  no,   0, no) \
    SC( 54,     17,       15,      3, yes,  no,   0, no) \
    SC( 55,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 56,     18,       16,      1, yes,  no,   0, no) \
    SC( 57,     18,       16,      2, yes,  no,   0, no) \
    SC( 58,     18,       16,      3, yes,  no,   0, no) \
    SC( 59,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 60,     19,       17,      1, yes,  no,   0, no) \
    SC( 61,     19,       17,      2, yes,  no,   0, no) \
    SC( 62,     19,       17,      3, yes,  no,   0, no) \
    SC( 63,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 64,     20,       18,      1, yes,  no,   0, no) \
    SC( 65,     20,       18,      2, yes,  no,   0, no) \
    SC( 66,     20,       18,      3, yes,  no,   0, no) \
    SC( 67,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 68,     21,       19,      1, yes,  no,   0, no) \
    SC( 69,     21,       19,      2, yes,  no,   0, no) \
    SC( 70,     21,       19,      3, yes,  no,   0, no) \
    SC( 71,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 72,     22,       20,      1, yes,  no,   0, no) \
    SC( 73,     22,       20,      2, yes,  no,   0, no) \
    SC( 74,     22,       20,      3, yes,  no,   0, no) \
    SC( 75,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 76,     23,       21,      1, yes,  no,   0, no) \
    SC( 77,     23,       21,      2, yes,  no,   0, no) \
    SC( 78,     23,       21,      3, yes,  no,   0, no) \
    SC( 79,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 80,     24,       22,      1, yes,  no,   0, no) \
    SC( 81,     24,       22,      2, yes,  no,   0, no) \
    SC( 82,     24,       22,      3, yes,  no,   0, no) \
    SC( 83,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 84,     25,       23,      1, yes,  no,   0, no) \
    SC( 85,     25,       23,      2, yes,  no,   0, no) \
    SC( 86,     25,       23,      3, yes,  no,   0, no) \
    SC( 87,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 88,     26,       24,      1, yes,  no,   0, no) \
    SC( 89,     26,       24,      2, yes,  no,   0, no) \
    SC( 90,     26,       24,      3, yes,  no,   0, no) \
    SC( 91,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 92,     27,       25,      1, yes,  no,   0, no) \
    SC( 93,     27,       25,      2, yes,  no,   0, no) \
    SC( 94,     27,       25,      3, yes,  no,   0, no) \
    SC( 95,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 96,     28,       26,      1, yes,  no,   0, no) \
    SC( 97,     28,       26,      2, yes,  no,   0, no) \
    SC( 98,     28,       26,      3, yes,  no,   0, no) \
    SC( 99,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC(100,     29,       27,      1, yes,  no,   0, no) \
    SC(101,     29,       27,      2, yes,  no,   0, no) \
    SC(102,     29,       27,      3, yes,  no,   0, no) \
    SC(103,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(104,     30,       28,      1, yes,  no,   0, no) \
    SC(105,     30,       28,      2, yes,  no,   0, no) \
    SC(106,     30,       28,      3, yes,  no,   0, no) \
    SC(107,     30,       28,      4, yes,  no,   0, no) \
                                                         \
    SC(108,     31,       29,      1, yes,  no,   0, no) \
    SC(109,     31,       29,      2, yes,  no,   0, no) \
    SC(110,     31,       29,      3, yes,  no,   0, no) \
    SC(111,     31,       29,      4, yes,  no,   0, no) \
                                                         \
    SC(112,     32,       30,      1, yes,  no,   0, no) \
    SC(113,     32,       30,      2, yes,  no,   0, no) \
    SC(114,     32,       30,      3, yes,  no,   0, no) \
    SC(115,     32,       30,      4, yes,  no,   0, no) \
                                                         \
    SC(116,     33,       31,      1, yes,  no,   0, no) \
    SC(117,     33,       31,      2, yes,  no,   0, no) \
    SC(118,     33,       31,      3, yes,  no,   0, no) \
    SC(119,     33,       31,      4, yes,  no,   0, no) \
                                                         \
    SC(120,     34,       32,      1, yes,  no,   0, no) \
    SC(121,     34,       32,      2, yes,  no,   0, no) \
    SC(122,     34,       32,      3, yes,  no,   0, no) \
    SC(123,     34,       32,      4, yes,  no,   0, no) \
                                                         \
    SC(124,     35,       33,      1, yes,  no,   0, no) \
    SC(125,     35,       33,      2, yes,  no,   0, no) \
    SC(126,     35,       33,      3, yes,  no,   0, no) \
    SC(127,     35,       33,      4, yes,  no,   0, no) \
                                                         \
    SC(128,     36,       34,      1, yes,  no,   0, no) \
    SC(129,     36,       34,      2, yes,  no,   0, no) \
    SC(130,     36,       34,      3, yes,  no,   0, no) \
    SC(131,     36,       34,      4, yes,  no,   0, no) \
                                                         \
    SC(132,     37,       35,      1, yes,  no,   0, no) \
    SC(133,     37,       35,      2, yes,  no,   0, no) \
    SC(134,     37,       35,      3, yes,  no,   0, no) \
    SC(135,     37,       35,      4, yes,  no,   0, no) \
                                                         \
    SC(136,     38,       36,      1, yes,  no,   0, no) \
    SC(137,     38,       36,      2, yes,  no,   0, no) \
    SC(138,     38,       36,      3, yes,  no,   0, no) \
    SC(139,     38,       36,      4, yes,  no,   0, no) \
                                                         \
    SC(140,     39,       37,      1, yes,  no,   0, no) \
    SC(141,     39,       37,      2, yes,  no,   0, no) \
    SC(142,     39,       37,      3, yes,  no,   0, no) \
    SC(143,     39,       37,      4, yes,  no,   0, no) \
                                                         \
    SC(144,     40,       38,      1, yes,  no,   0, no) \
    SC(145,     40,       38,      2, yes,  no,   0, no) \
    SC(146,     40,       38,      3, yes,  no,   0, no) \
    SC(147,     40,       38,      4, yes,  no,   0, no) \
                                                         \
    SC(148,     41,       39,      1, yes,  no,   0, no) \
    SC(149,     41,       39,      2, yes,  no,   0, no) \
    SC(150,     41,       39,      3, yes,  no,   0, no) \
    SC(151,     41,       39,      4, yes,  no,   0, no) \
                                                         \
    SC(152,     42,       40,      1, yes,  no,   0, no) \
    SC(153,     42,       40,      2, yes,  no,   0, no) \
    SC(154,     42,       40,      3, yes,  no,   0, no) \
    SC(155,     42,       40,      4, yes,  no,   0, no) \
                                                         \
    SC(156,     43,       41,      1, yes,  no,   0, no) \
    SC(157,     43,       41,      2, yes,  no,   0, no) \
    SC(158,     43,       41,      3, yes,  no,   0, no) \
    SC(159,     43,       41,      4, yes,  no,   0, no) \
                                                         \
    SC(160,     44,       42,      1, yes,  no,   0, no) \
    SC(161,     44,       42,      2, yes,  no,   0, no) \
    SC(162,     44,       42,      3, yes,  no,   0, no) \
    SC(163,     44,       42,      4, yes,  no,   0, no) \
                                                         \
    SC(164,     45,       43,      1, yes,  no,   0, no) \
    SC(165,     45,       43,      2, yes,  no,   0, no) \
    SC(166,     45,       43,      3, yes,  no,   0, no) \
    SC(167,     45,       43,      4, yes,  no,   0, no) \
                                                         \
    SC(168,     46,       44,      1, yes,  no,   0, no) \
    SC(169,     46,       44,      2, yes,  no,   0, no) \
    SC(170,     46,       44,      3, yes,  no,   0, no) \
    SC(171,     46,       44,      4, yes,  no,   0, no) \
                                                         \
    SC(172,     47,       45,      1, yes,  no,   0, no) \
    SC(173,     47,       45,      2, yes,  no,   0, no) \
    SC(174,     47,       45,      3, yes,  no,   0, no) \
    SC(175,     47,       45,      4, yes,  no,   0, no) \
                                                         \
    SC(176,     48,       46,      1, yes,  no,   0, no) \
    SC(177,     48,       46,      2, yes,  no,   0, no) \
    SC(178,     48,       46,      3, yes,  no,   0, no) \
    SC(179,     48,       46,      4, yes,  no,   0, no) \
                                                         \
    SC(180,     49,       47,      1, yes,  no,   0, no) \
    SC(181,     49,       47,      2, yes,  no,   0, no) \
    SC(182,     49,       47,      3, yes,  no,   0, no) \
    SC(183,     49,       47,      4, yes,  no,   0, no) \
                                                         \
    SC(184,     50,       48,      1, yes,  no,   0, no) \
    SC(185,     50,       48,      2, yes,  no,   0, no) \
    SC(186,     50,       48,      3, yes,  no,   0, no) \
    SC(187,     50,       48,      4, yes,  no,   0, no) \
                                                         \
    SC(188,     51,       49,      1, yes,  no,   0, no) \
    SC(189,     51,       49,      2, yes,  no,   0, no) \
    SC(190,     51,       49,      3, yes,  no,   0, no) \
    SC(191,     51,       49,      4, yes,  no,   0, no) \
                                                         \
    SC(192,     52,       50,      1, yes,  no,   0, no) \
    SC(193,     52,       50,      2, yes,  no,   0, no) \
    SC(194,     52,       50,      3, yes,  no,   0, no) \
    SC(195,     52,       50,      4, yes,  no,   0, no) \
                                                         \
    SC(196,     53,       51,      1, yes,  no,   0, no) \
    SC(197,     53,       51,      2, yes,  no,   0, no) \
    SC(198,     53,       51,      3, yes,  no,   0, no) \
    SC(199,     53,       51,      4, yes,  no,   0, no) \
                                                         \
    SC(200,     54,       52,      1, yes,  no,   0, no) \
    SC(201,     54,       52,      2, yes,  no,   0, no) \
    SC(202,     54,       52,      3, yes,  no,   0, no) \
    SC(203,     54,       52,      4, yes,  no,   0, no) \
                                                         \
    SC(204,     55,       53,      1, yes,  no,   0, no) \
    SC(205,     55,       53,      2, yes,  no,   0, no) \
    SC(206,     55,       53,      3, yes,  no,   0, no) \
    SC(207,     55,       53,      4, yes,  no,   0, no) \
                                                         \
    SC(208,     56,       54,      1, yes,  no,   0, no) \
    SC(209,     56,       54,      2, yes,  no,   0, no) \
    SC(210,     56,       54,      3, yes,  no,   0, no) \
    SC(211,     56,       54,      4, yes,  no,   0, no) \
                                                         \
    SC(212,     57,       55,      1, yes,  no,   0, no) \
    SC(213,     57,       55,      2, yes,  no,   0, no) \
    SC(214,     57,       55,      3, yes,  no,   0, no) \
    SC(215,     57,       55,      4, yes,  no,   0, no) \
                                                         \
    SC(216,     58,       56,      1, yes,  no,   0, no) \
    SC(217,     58,       56,      2, yes,  no,   0, no) \
    SC(218,     58,       56,      3, yes,  no,   0, no) \
    SC(219,     58,       56,      4, yes,  no,   0, no) \
                                                         \
    SC(220,     59,       57,      1, yes,  no,   0, no) \
    SC(221,     59,       57,      2, yes,  no,   0, no) \
    SC(222,     59,       57,      3, yes,  no,   0, no) \
    SC(223,     59,       57,      4, yes,  no,   0, no) \
                                                         \
    SC(224,     60,       58,      1, yes,  no,   0, no) \
    SC(225,     60,       58,      2, yes,  no,   0, no) \
    SC(226,     60,       58,      3, yes,  no,   0, no) \
    SC(227,     60,       58,      4, yes,  no,   0, no) \
                                                         \
    SC(228,     61,       59,      1, yes,  no,   0, no) \
    SC(229,     61,       59,      2, yes,  no,   0, no) \
    SC(230,     61,       59,      3, yes,  no,   0, no) \
    SC(231,     61,       59,      4, yes,  no,   0, no) \
                                                         \
    SC(232,     62,       60,      1, yes,  no,   0, no) \
    SC(233,     62,       60,      2, yes,  no,   0, no) \
    SC(234,     62,       60,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			0
#define NLBINS			32
#define NBINS			43
#define NSIZES			235
#define LG_CEIL_NSIZES		8
#define NPSIZES			195
#define LG_TINY_MAXCLASS	"NA"
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 14) + (((size_t)3) << 12))
#define LG_LARGE_MINCLASS	15
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 62) + (((size_t)3) << 60))
#endif

#if (LG_SIZEOF_PTR == 3 && LG_TINY_MIN == 3 && LG_QUANTUM == 4 && LG_PAGE == 13)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      3,        3,      0,  no, yes,   1,  3) \
                                                         \
    SC(  1,      3,        3,      1,  no, yes,   1,  3) \
    SC(  2,      4,        4,      1,  no, yes,   1,  4) \
    SC(  3,      4,        4,      2,  no, yes,   3,  4) \
    SC(  4,      4,        4,      3,  no, yes,   1,  4) \
                                                         \
    SC(  5,      6,        4,      1,  no, yes,   5,  4) \
    SC(  6,      6,        4,      2,  no, yes,   3,  4) \
    SC(  7,      6,        4,      3,  no, yes,   7,  4) \
    SC(  8,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC(  9,      7,        5,      1,  no, yes,   5,  5) \
    SC( 10,      7,        5,      2,  no, yes,   3,  5) \
    SC( 11,      7,        5,      3,  no, yes,   7,  5) \
    SC( 12,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 13,      8,        6,      1,  no, yes,   5,  6) \
    SC( 14,      8,        6,      2,  no, yes,   3,  6) \
    SC( 15,      8,        6,      3,  no, yes,   7,  6) \
    SC( 16,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 17,      9,        7,      1,  no, yes,   5,  7) \
    SC( 18,      9,        7,      2,  no, yes,   3,  7) \
    SC( 19,      9,        7,      3,  no, yes,   7,  7) \
    SC( 20,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 21,     10,        8,      1,  no, yes,   5,  8) \
    SC( 22,     10,        8,      2,  no, yes,   3,  8) \
    SC( 23,     10,        8,      3,  no, yes,   7,  8) \
    SC( 24,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 25,     11,        9,      1,  no, yes,   5,  9) \
    SC( 26,     11,        9,      2,  no, yes,   3,  9) \
    SC( 27,     11,        9,      3,  no, yes,   7,  9) \
    SC( 28,     11,        9,      4,  no, yes,   1,  9) \
                                                         \
    SC( 29,     12,       10,      1,  no, yes,   5, no) \
    SC( 30,     12,       10,      2,  no, yes,   3, no) \
    SC( 31,     12,       10,      3,  no, yes,   7, no) \
    SC( 32,     12,       10,      4, yes, yes,   1, no) \
                                                         \
    SC( 33,     13,       11,      1,  no, yes,   5, no) \
    SC( 34,     13,       11,      2,  no, yes,   3, no) \
    SC( 35,     13,       11,      3,  no, yes,   7, no) \
    SC( 36,     13,       11,      4, yes, yes,   2, no) \
                                                         \
    SC( 37,     14,       12,      1,  no, yes,   5, no) \
    SC( 38,     14,       12,      2, yes, yes,   3, no) \
    SC( 39,     14,       12,      3,  no, yes,   7, no) \
    SC( 40,     14,       12,      4, yes,  no,   0, no) \
                                                         \
    SC( 41,     15,       13,      1, yes,  no,   0, no) \
    SC( 42,     15,       13,      2, yes,  no,   0, no) \
    SC( 43,     15,       13,      3, yes,  no,   0, no) \
    SC( 44,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 45,     16,       14,      1, yes,  no,   0, no) \
    SC( 46,     16,       14,      2, yes,  no,   0, no) \
    SC( 47,     16,       14,      3, yes,  no,   0, no) \
    SC( 48,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 49,     17,       15,      1, yes,  no,   0, no) \
    SC( 50,     17,       15,      2, yes,  no,   0, no) \
    SC( 51,     17,       15,      3, yes,  no,   0, no) \
    SC( 52,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 53,     18,       16,      1, yes,  no,   0, no) \
    SC( 54,     18,       16,      2, yes,  no,   0, no) \
    SC( 55,     18,       16,      3, yes,  no,   0, no) \
    SC( 56,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 57,     19,       17,      1, yes,  no,   0, no) \
    SC( 58,     19,       17,      2, yes,  no,   0, no) \
    SC( 59,     19,       17,      3, yes,  no,   0, no) \
    SC( 60,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 61,     20,       18,      1, yes,  no,   0, no) \
    SC( 62,     20,       18,      2, yes,  no,   0, no) \
    SC( 63,     20,       18,      3, yes,  no,   0, no) \
    SC( 64,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 65,     21,       19,      1, yes,  no,   0, no) \
    SC( 66,     21,       19,      2, yes,  no,   0, no) \
    SC( 67,     21,       19,      3, yes,  no,   0, no) \
    SC( 68,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 69,     22,       20,      1, yes,  no,   0, no) \
    SC( 70,     22,       20,      2, yes,  no,   0, no) \
    SC( 71,     22,       20,      3, yes,  no,   0, no) \
    SC( 72,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 73,     23,       21,      1, yes,  no,   0, no) \
    SC( 74,     23,       21,      2, yes,  no,   0, no) \
    SC( 75,     23,       21,      3, yes,  no,   0, no) \
    SC( 76,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 77,     24,       22,      1, yes,  no,   0, no) \
    SC( 78,     24,       22,      2, yes,  no,   0, no) \
    SC( 79,     24,       22,      3, yes,  no,   0, no) \
    SC( 80,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 81,     25,       23,      1, yes,  no,   0, no) \
    SC( 82,     25,       23,      2, yes,  no,   0, no) \
    SC( 83,     25,       23,      3, yes,  no,   0, no) \
    SC( 84,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 85,     26,       24,      1, yes,  no,   0, no) \
    SC( 86,     26,       24,      2, yes,  no,   0, no) \
    SC( 87,     26,       24,      3, yes,  no,   0, no) \
    SC( 88,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 89,     27,       25,      1, yes,  no,   0, no) \
    SC( 90,     27,       25,      2, yes,  no,   0, no) \
    SC( 91,     27,       25,      3, yes,  no,   0, no) \
    SC( 92,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 93,     28,       26,      1, yes,  no,   0, no) \
    SC( 94,     28,       26,      2, yes,  no,   0, no) \
    SC( 95,     28,       26,      3, yes,  no,   0, no) \
    SC( 96,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC( 97,     29,       27,      1, yes,  no,   0, no) \
    SC( 98,     29,       27,      2, yes,  no,   0, no) \
    SC( 99,     29,       27,      3, yes,  no,   0, no) \
    SC(100,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(101,     30,       28,      1, yes,  no,   0, no) \
    SC(102,     30,       28,      2, yes,  no,   0, no) \
    SC(103,     30,       28,      3, yes,  no,   0, no) \
    SC(104,     30,       28,      4, yes,  no,   0, no) \
                                                         \
    SC(105,     31,       29,      1, yes,  no,   0, no) \
    SC(106,     31,       29,      2, yes,  no,   0, no) \
    SC(107,     31,       29,      3, yes,  no,   0, no) \
    SC(108,     31,       29,      4, yes,  no,   0, no) \
                                                         \
    SC(109,     32,       30,      1, yes,  no,   0, no) \
    SC(110,     32,       30,      2, yes,  no,   0, no) \
    SC(111,     32,       30,      3, yes,  no,   0, no) \
    SC(112,     32,       30,      4, yes,  no,   0, no) \
                                                         \
    SC(113,     33,       31,      1, yes,  no,   0, no) \
    SC(114,     33,       31,      2, yes,  no,   0, no) \
    SC(115,     33,       31,      3, yes,  no,   0, no) \
    SC(116,     33,       31,      4, yes,  no,   0, no) \
                                                         \
    SC(117,     34,       32,      1, yes,  no,   0, no) \
    SC(118,     34,       32,      2, yes,  no,   0, no) \
    SC(119,     34,       32,      3, yes,  no,   0, no) \
    SC(120,     34,       32,      4, yes,  no,   0, no) \
                                                         \
    SC(121,     35,       33,      1, yes,  no,   0, no) \
    SC(122,     35,       33,      2, yes,  no,   0, no) \
    SC(123,     35,       33,      3, yes,  no,   0, no) \
    SC(124,     35,       33,      4, yes,  no,   0, no) \
                                                         \
    SC(125,     36,       34,      1, yes,  no,   0, no) \
    SC(126,     36,       34,      2, yes,  no,   0, no) \
    SC(127,     36,       34,      3, yes,  no,   0, no) \
    SC(128,     36,       34,      4, yes,  no,   0, no) \
                                                         \
    SC(129,     37,       35,      1, yes,  no,   0, no) \
    SC(130,     37,       35,      2, yes,  no,   0, no) \
    SC(131,     37,       35,      3, yes,  no,   0, no) \
    SC(132,     37,       35,      4, yes,  no,   0, no) \
                                                         \
    SC(133,     38,       36,      1, yes,  no,   0, no) \
    SC(134,     38,       36,      2, yes,  no,   0, no) \
    SC(135,     38,       36,      3, yes,  no,   0, no) \
    SC(136,     38,       36,      4, yes,  no,   0, no) \
                                                         \
    SC(137,     39,       37,      1, yes,  no,   0, no) \
    SC(138,     39,       37,      2, yes,  no,   0, no) \
    SC(139,     39,       37,      3, yes,  no,   0, no) \
    SC(140,     39,       37,      4, yes,  no,   0, no) \
                                                         \
    SC(141,     40,       38,      1, yes,  no,   0, no) \
    SC(142,     40,       38,      2, yes,  no,   0, no) \
    SC(143,     40,       38,      3, yes,  no,   0, no) \
    SC(144,     40,       38,      4, yes,  no,   0, no) \
                                                         \
    SC(145,     41,       39,      1, yes,  no,   0, no) \
    SC(146,     41,       39,      2, yes,  no,   0, no) \
    SC(147,     41,       39,      3, yes,  no,   0, no) \
    SC(148,     41,       39,      4, yes,  no,   0, no) \
                                                         \
    SC(149,     42,       40,      1, yes,  no,   0, no) \
    SC(150,     42,       40,      2, yes,  no,   0, no) \
    SC(151,     42,       40,      3, yes,  no,   0, no) \
    SC(152,     42,       40,      4, yes,  no,   0, no) \
                                                         \
    SC(153,     43,       41,      1, yes,  no,   0, no) \
    SC(154,     43,       41,      2, yes,  no,   0, no) \
    SC(155,     43,       41,      3, yes,  no,   0, no) \
    SC(156,     43,       41,      4, yes,  no,   0, no) \
                                                         \
    SC(157,     44,       42,      1, yes,  no,   0, no) \
    SC(158,     44,       42,      2, yes,  no,   0, no) \
    SC(159,     44,       42,      3, yes,  no,   0, no) \
    SC(160,     44,       42,      4, yes,  no,   0, no) \
                                                         \
    SC(161,     45,       43,      1, yes,  no,   0, no) \
    SC(162,     45,       43,      2, yes,  no,   0, no) \
    SC(163,     45,       43,      3, yes,  no,   0, no) \
    SC(164,     45,       43,      4, yes,  no,   0, no) \
                                                         \
    SC(165,     46,       44,      1, yes,  no,   0, no) \
    SC(166,     46,       44,      2, yes,  no,   0, no) \
    SC(167,     46,       44,      3, yes,  no,   0, no) \
    SC(168,     46,       44,      4, yes,  no,   0, no) \
                                                         \
    SC(169,     47,       45,      1, yes,  no,   0, no) \
    SC(170,     47,       45,      2, yes,  no,   0, no) \
    SC(171,     47,       45,      3, yes,  no,   0, no) \
    SC(172,     47,       45,      4, yes,  no,   0, no) \
                                                         \
    SC(173,     48,       46,      1, yes,  no,   0, no) \
    SC(174,     48,       46,      2, yes,  no,   0, no) \
    SC(175,     48,       46,      3, yes,  no,   0, no) \
    SC(176,     48,       46,      4, yes,  no,   0, no) \
                                                         \
    SC(177,     49,       47,      1, yes,  no,   0, no) \
    SC(178,     49,       47,      2, yes,  no,   0, no) \
    SC(179,     49,       47,      3, yes,  no,   0, no) \
    SC(180,     49,       47,      4, yes,  no,   0, no) \
                                                         \
    SC(181,     50,       48,      1, yes,  no,   0, no) \
    SC(182,     50,       48,      2, yes,  no,   0, no) \
    SC(183,     50,       48,      3, yes,  no,   0, no) \
    SC(184,     50,       48,      4, yes,  no,   0, no) \
                                                         \
    SC(185,     51,       49,      1, yes,  no,   0, no) \
    SC(186,     51,       49,      2, yes,  no,   0, no) \
    SC(187,     51,       49,      3, yes,  no,   0, no) \
    SC(188,     51,       49,      4, yes,  no,   0, no) \
                                                         \
    SC(189,     52,       50,      1, yes,  no,   0, no) \
    SC(190,     52,       50,      2, yes,  no,   0, no) \
    SC(191,     52,       50,      3, yes,  no,   0, no) \
    SC(192,     52,       50,      4, yes,  no,   0, no) \
                                                         \
    SC(193,     53,       51,      1, yes,  no,   0, no) \
    SC(194,     53,       51,      2, yes,  no,   0, no) \
    SC(195,     53,       51,      3, yes,  no,   0, no) \
    SC(196,     53,       51,      4, yes,  no,   0, no) \
                                                         \
    SC(197,     54,       52,      1, yes,  no,   0, no) \
    SC(198,     54,       52,      2, yes,  no,   0, no) \
    SC(199,     54,       52,      3, yes,  no,   0, no) \
    SC(200,     54,       52,      4, yes,  no,   0, no) \
                                                         \
    SC(201,     55,       53,      1, yes,  no,   0, no) \
    SC(202,     55,       53,      2, yes,  no,   0, no) \
    SC(203,     55,       53,      3, yes,  no,   0, no) \
    SC(204,     55,       53,      4, yes,  no,   0, no) \
                                                         \
    SC(205,     56,       54,      1, yes,  no,   0, no) \
    SC(206,     56,       54,      2, yes,  no,   0, no) \
    SC(207,     56,       54,      3, yes,  no,   0, no) \
    SC(208,     56,       54,      4, yes,  no,   0, no) \
                                                         \
    SC(209,     57,       55,      1, yes,  no,   0, no) \
    SC(210,     57,       55,      2, yes,  no,   0, no) \
    SC(211,     57,       55,      3, yes,  no,   0, no) \
    SC(212,     57,       55,      4, yes,  no,   0, no) \
                                                         \
    SC(213,     58,       56,      1, yes,  no,   0, no) \
    SC(214,     58,       56,      2, yes,  no,   0, no) \
    SC(215,     58,       56,      3, yes,  no,   0, no) \
    SC(216,     58,       56,      4, yes,  no,   0, no) \
                                                         \
    SC(217,     59,       57,      1, yes,  no,   0, no) \
    SC(218,     59,       57,      2, yes,  no,   0, no) \
    SC(219,     59,       57,      3, yes,  no,   0, no) \
    SC(220,     59,       57,      4, yes,  no,   0, no) \
                                                         \
    SC(221,     60,       58,      1, yes,  no,   0, no) \
    SC(222,     60,       58,      2, yes,  no,   0, no) \
    SC(223,     60,       58,      3, yes,  no,   0, no) \
    SC(224,     60,       58,      4, yes,  no,   0, no) \
                                                         \
    SC(225,     61,       59,      1, yes,  no,   0, no) \
    SC(226,     61,       59,      2, yes,  no,   0, no) \
    SC(227,     61,       59,      3, yes,  no,   0, no) \
    SC(228,     61,       59,      4, yes,  no,   0, no) \
                                                         \
    SC(229,     62,       60,      1, yes,  no,   0, no) \
    SC(230,     62,       60,      2, yes,  no,   0, no) \
    SC(231,     62,       60,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			1
#define NLBINS			29
#define NBINS			40
#define NSIZES			232
#define LG_CEIL_NSIZES		8
#define NPSIZES			195
#define LG_TINY_MAXCLASS	3
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 14) + (((size_t)3) << 12))
#define LG_LARGE_MINCLASS	15
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 62) + (((size_t)3) << 60))
#endif

#if (LG_SIZEOF_PTR == 3 && LG_TINY_MIN == 4 && LG_QUANTUM == 4 && LG_PAGE == 13)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      4,        4,      0,  no, yes,   1,  4) \
    SC(  1,      4,        4,      1,  no, yes,   1,  4) \
    SC(  2,      4,        4,      2,  no, yes,   3,  4) \
    SC(  3,      4,        4,      3,  no, yes,   1,  4) \
                                                         \
    SC(  4,      6,        4,      1,  no, yes,   5,  4) \
    SC(  5,      6,        4,      2,  no, yes,   3,  4) \
    SC(  6,      6,        4,      3,  no, yes,   7,  4) \
    SC(  7,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC(  8,      7,        5,      1,  no, yes,   5,  5) \
    SC(  9,      7,        5,      2,  no, yes,   3,  5) \
    SC( 10,      7,        5,      3,  no, yes,   7,  5) \
    SC( 11,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 12,      8,        6,      1,  no, yes,   5,  6) \
    SC( 13,      8,        6,      2,  no, yes,   3,  6) \
    SC( 14,      8,        6,      3,  no, yes,   7,  6) \
    SC( 15,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 16,      9,        7,      1,  no, yes,   5,  7) \
    SC( 17,      9,        7,      2,  no, yes,   3,  7) \
    SC( 18,      9,        7,      3,  no, yes,   7,  7) \
    SC( 19,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 20,     10,        8,      1,  no, yes,   5,  8) \
    SC( 21,     10,        8,      2,  no, yes,   3,  8) \
    SC( 22,     10,        8,      3,  no, yes,   7,  8) \
    SC( 23,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 24,     11,        9,      1,  no, yes,   5,  9) \
    SC( 25,     11,        9,      2,  no, yes,   3,  9) \
    SC( 26,     11,        9,      3,  no, yes,   7,  9) \
    SC( 27,     11,        9,      4,  no, yes,   1,  9) \
                                                         \
    SC( 28,     12,       10,      1,  no, yes,   5, no) \
    SC( 29,     12,       10,      2,  no, yes,   3, no) \
    SC( 30,     12,       10,      3,  no, yes,   7, no) \
    SC( 31,     12,       10,      4, yes, yes,   1, no) \
                                                         \
    SC( 32,     13,       11,      1,  no, yes,   5, no) \
    SC( 33,     13,       11,      2,  no, yes,   3, no) \
    SC( 34,     13,       11,      3,  no, yes,   7, no) \
    SC( 35,     13,       11,      4, yes, yes,   2, no) \
                                                         \
    SC( 36,     14,       12,      1,  no, yes,   5, no) \
    SC( 37,     14,       12,      2, yes, yes,   3, no) \
    SC( 38,     14,       12,      3,  no, yes,   7, no) \
    SC( 39,     14,       12,      4, yes,  no,   0, no) \
                                                         \
    SC( 40,     15,       13,      1, yes,  no,   0, no) \
    SC( 41,     15,       13,      2, yes,  no,   0, no) \
    SC( 42,     15,       13,      3, yes,  no,   0, no) \
    SC( 43,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 44,     16,       14,      1, yes,  no,   0, no) \
    SC( 45,     16,       14,      2, yes,  no,   0, no) \
    SC( 46,     16,       14,      3, yes,  no,   0, no) \
    SC( 47,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 48,     17,       15,      1, yes,  no,   0, no) \
    SC( 49,     17,       15,      2, yes,  no,   0, no) \
    SC( 50,     17,       15,      3, yes,  no,   0, no) \
    SC( 51,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 52,     18,       16,      1, yes,  no,   0, no) \
    SC( 53,     18,       16,      2, yes,  no,   0, no) \
    SC( 54,     18,       16,      3, yes,  no,   0, no) \
    SC( 55,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 56,     19,       17,      1, yes,  no,   0, no) \
    SC( 57,     19,       17,      2, yes,  no,   0, no) \
    SC( 58,     19,       17,      3, yes,  no,   0, no) \
    SC( 59,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 60,     20,       18,      1, yes,  no,   0, no) \
    SC( 61,     20,       18,      2, yes,  no,   0, no) \
    SC( 62,     20,       18,      3, yes,  no,   0, no) \
    SC( 63,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 64,     21,       19,      1, yes,  no,   0, no) \
    SC( 65,     21,       19,      2, yes,  no,   0, no) \
    SC( 66,     21,       19,      3, yes,  no,   0, no) \
    SC( 67,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 68,     22,       20,      1, yes,  no,   0, no) \
    SC( 69,     22,       20,      2, yes,  no,   0, no) \
    SC( 70,     22,       20,      3, yes,  no,   0, no) \
    SC( 71,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 72,     23,       21,      1, yes,  no,   0, no) \
    SC( 73,     23,       21,      2, yes,  no,   0, no) \
    SC( 74,     23,       21,      3, yes,  no,   0, no) \
    SC( 75,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 76,     24,       22,      1, yes,  no,   0, no) \
    SC( 77,     24,       22,      2, yes,  no,   0, no) \
    SC( 78,     24,       22,      3, yes,  no,   0, no) \
    SC( 79,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 80,     25,       23,      1, yes,  no,   0, no) \
    SC( 81,     25,       23,      2, yes,  no,   0, no) \
    SC( 82,     25,       23,      3, yes,  no,   0, no) \
    SC( 83,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 84,     26,       24,      1, yes,  no,   0, no) \
    SC( 85,     26,       24,      2, yes,  no,   0, no) \
    SC( 86,     26,       24,      3, yes,  no,   0, no) \
    SC( 87,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 88,     27,       25,      1, yes,  no,   0, no) \
    SC( 89,     27,       25,      2, yes,  no,   0, no) \
    SC( 90,     27,       25,      3, yes,  no,   0, no) \
    SC( 91,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 92,     28,       26,      1, yes,  no,   0, no) \
    SC( 93,     28,       26,      2, yes,  no,   0, no) \
    SC( 94,     28,       26,      3, yes,  no,   0, no) \
    SC( 95,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC( 96,     29,       27,      1, yes,  no,   0, no) \
    SC( 97,     29,       27,      2, yes,  no,   0, no) \
    SC( 98,     29,       27,      3, yes,  no,   0, no) \
    SC( 99,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(100,     30,       28,      1, yes,  no,   0, no) \
    SC(101,     30,       28,      2, yes,  no,   0, no) \
    SC(102,     30,       28,      3, yes,  no,   0, no) \
    SC(103,     30,       28,      4, yes,  no,   0, no) \
                                                         \
    SC(104,     31,       29,      1, yes,  no,   0, no) \
    SC(105,     31,       29,      2, yes,  no,   0, no) \
    SC(106,     31,       29,      3, yes,  no,   0, no) \
    SC(107,     31,       29,      4, yes,  no,   0, no) \
                                                         \
    SC(108,     32,       30,      1, yes,  no,   0, no) \
    SC(109,     32,       30,      2, yes,  no,   0, no) \
    SC(110,     32,       30,      3, yes,  no,   0, no) \
    SC(111,     32,       30,      4, yes,  no,   0, no) \
                                                         \
    SC(112,     33,       31,      1, yes,  no,   0, no) \
    SC(113,     33,       31,      2, yes,  no,   0, no) \
    SC(114,     33,       31,      3, yes,  no,   0, no) \
    SC(115,     33,       31,      4, yes,  no,   0, no) \
                                                         \
    SC(116,     34,       32,      1, yes,  no,   0, no) \
    SC(117,     34,       32,      2, yes,  no,   0, no) \
    SC(118,     34,       32,      3, yes,  no,   0, no) \
    SC(119,     34,       32,      4, yes,  no,   0, no) \
                                                         \
    SC(120,     35,       33,      1, yes,  no,   0, no) \
    SC(121,     35,       33,      2, yes,  no,   0, no) \
    SC(122,     35,       33,      3, yes,  no,   0, no) \
    SC(123,     35,       33,      4, yes,  no,   0, no) \
                                                         \
    SC(124,     36,       34,      1, yes,  no,   0, no) \
    SC(125,     36,       34,      2, yes,  no,   0, no) \
    SC(126,     36,       34,      3, yes,  no,   0, no) \
    SC(127,     36,       34,      4, yes,  no,   0, no) \
                                                         \
    SC(128,     37,       35,      1, yes,  no,   0, no) \
    SC(129,     37,       35,      2, yes,  no,   0, no) \
    SC(130,     37,       35,      3, yes,  no,   0, no) \
    SC(131,     37,       35,      4, yes,  no,   0, no) \
                                                         \
    SC(132,     38,       36,      1, yes,  no,   0, no) \
    SC(133,     38,       36,      2, yes,  no,   0, no) \
    SC(134,     38,       36,      3, yes,  no,   0, no) \
    SC(135,     38,       36,      4, yes,  no,   0, no) \
                                                         \
    SC(136,     39,       37,      1, yes,  no,   0, no) \
    SC(137,     39,       37,      2, yes,  no,   0, no) \
    SC(138,     39,       37,      3, yes,  no,   0, no) \
    SC(139,     39,       37,      4, yes,  no,   0, no) \
                                                         \
    SC(140,     40,       38,      1, yes,  no,   0, no) \
    SC(141,     40,       38,      2, yes,  no,   0, no) \
    SC(142,     40,       38,      3, yes,  no,   0, no) \
    SC(143,     40,       38,      4, yes,  no,   0, no) \
                                                         \
    SC(144,     41,       39,      1, yes,  no,   0, no) \
    SC(145,     41,       39,      2, yes,  no,   0, no) \
    SC(146,     41,       39,      3, yes,  no,   0, no) \
    SC(147,     41,       39,      4, yes,  no,   0, no) \
                                                         \
    SC(148,     42,       40,      1, yes,  no,   0, no) \
    SC(149,     42,       40,      2, yes,  no,   0, no) \
    SC(150,     42,       40,      3, yes,  no,   0, no) \
    SC(151,     42,       40,      4, yes,  no,   0, no) \
                                                         \
    SC(152,     43,       41,      1, yes,  no,   0, no) \
    SC(153,     43,       41,      2, yes,  no,   0, no) \
    SC(154,     43,       41,      3, yes,  no,   0, no) \
    SC(155,     43,       41,      4, yes,  no,   0, no) \
                                                         \
    SC(156,     44,       42,      1, yes,  no,   0, no) \
    SC(157,     44,       42,      2, yes,  no,   0, no) \
    SC(158,     44,       42,      3, yes,  no,   0, no) \
    SC(159,     44,       42,      4, yes,  no,   0, no) \
                                                         \
    SC(160,     45,       43,      1, yes,  no,   0, no) \
    SC(161,     45,       43,      2, yes,  no,   0, no) \
    SC(162,     45,       43,      3, yes,  no,   0, no) \
    SC(163,     45,       43,      4, yes,  no,   0, no) \
                                                         \
    SC(164,     46,       44,      1, yes,  no,   0, no) \
    SC(165,     46,       44,      2, yes,  no,   0, no) \
    SC(166,     46,       44,      3, yes,  no,   0, no) \
    SC(167,     46,       44,      4, yes,  no,   0, no) \
                                                         \
    SC(168,     47,       45,      1, yes,  no,   0, no) \
    SC(169,     47,       45,      2, yes,  no,   0, no) \
    SC(170,     47,       45,      3, yes,  no,   0, no) \
    SC(171,     47,       45,      4, yes,  no,   0, no) \
                                                         \
    SC(172,     48,       46,      1, yes,  no,   0, no) \
    SC(173,     48,       46,      2, yes,  no,   0, no) \
    SC(174,     48,       46,      3, yes,  no,   0, no) \
    SC(175,     48,       46,      4, yes,  no,   0, no) \
                                                         \
    SC(176,     49,       47,      1, yes,  no,   0, no) \
    SC(177,     49,       47,      2, yes,  no,   0, no) \
    SC(178,     49,       47,      3, yes,  no,   0, no) \
    SC(179,     49,       47,      4, yes,  no,   0, no) \
                                                         \
    SC(180,     50,       48,      1, yes,  no,   0, no) \
    SC(181,     50,       48,      2, yes,  no,   0, no) \
    SC(182,     50,       48,      3, yes,  no,   0, no) \
    SC(183,     50,       48,      4, yes,  no,   0, no) \
                                                         \
    SC(184,     51,       49,      1, yes,  no,   0, no) \
    SC(185,     51,       49,      2, yes,  no,   0, no) \
    SC(186,     51,       49,      3, yes,  no,   0, no) \
    SC(187,     51,       49,      4, yes,  no,   0, no) \
                                                         \
    SC(188,     52,       50,      1, yes,  no,   0, no) \
    SC(189,     52,       50,      2, yes,  no,   0, no) \
    SC(190,     52,       50,      3, yes,  no,   0, no) \
    SC(191,     52,       50,      4, yes,  no,   0, no) \
                                                         \
    SC(192,     53,       51,      1, yes,  no,   0, no) \
    SC(193,     53,       51,      2, yes,  no,   0, no) \
    SC(194,     53,       51,      3, yes,  no,   0, no) \
    SC(195,     53,       51,      4, yes,  no,   0, no) \
                                                         \
    SC(196,     54,       52,      1, yes,  no,   0, no) \
    SC(197,     54,       52,      2, yes,  no,   0, no) \
    SC(198,     54,       52,      3, yes,  no,   0, no) \
    SC(199,     54,       52,      4, yes,  no,   0, no) \
                                                         \
    SC(200,     55,       53,      1, yes,  no,   0, no) \
    SC(201,     55,       53,      2, yes,  no,   0, no) \
    SC(202,     55,       53,      3, yes,  no,   0, no) \
    SC(203,     55,       53,      4, yes,  no,   0, no) \
                                                         \
    SC(204,     56,       54,      1, yes,  no,   0, no) \
    SC(205,     56,       54,      2, yes,  no,   0, no) \
    SC(206,     56,       54,      3, yes,  no,   0, no) \
    SC(207,     56,       54,      4, yes,  no,   0, no) \
                                                         \
    SC(208,     57,       55,      1, yes,  no,   0, no) \
    SC(209,     57,       55,      2, yes,  no,   0, no) \
    SC(210,     57,       55,      3, yes,  no,   0, no) \
    SC(211,     57,       55,      4, yes,  no,   0, no) \
                                                         \
    SC(212,     58,       56,      1, yes,  no,   0, no) \
    SC(213,     58,       56,      2, yes,  no,   0, no) \
    SC(214,     58,       56,      3, yes,  no,   0, no) \
    SC(215,     58,       56,      4, yes,  no,   0, no) \
                                                         \
    SC(216,     59,       57,      1, yes,  no,   0, no) \
    SC(217,     59,       57,      2, yes,  no,   0, no) \
    SC(218,     59,       57,      3, yes,  no,   0, no) \
    SC(219,     59,       57,      4, yes,  no,   0, no) \
                                                         \
    SC(220,     60,       58,      1, yes,  no,   0, no) \
    SC(221,     60,       58,      2, yes,  no,   0, no) \
    SC(222,     60,       58,      3, yes,  no,   0, no) \
    SC(223,     60,       58,      4, yes,  no,   0, no) \
                                                         \
    SC(224,     61,       59,      1, yes,  no,   0, no) \
    SC(225,     61,       59,      2, yes,  no,   0, no) \
    SC(226,     61,       59,      3, yes,  no,   0, no) \
    SC(227,     61,       59,      4, yes,  no,   0, no) \
                                                         \
    SC(228,     62,       60,      1, yes,  no,   0, no) \
    SC(229,     62,       60,      2, yes,  no,   0, no) \
    SC(230,     62,       60,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			0
#define NLBINS			28
#define NBINS			39
#define NSIZES			231
#define LG_CEIL_NSIZES		8
#define NPSIZES			195
#define LG_TINY_MAXCLASS	"NA"
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 14) + (((size_t)3) << 12))
#define LG_LARGE_MINCLASS	15
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 62) + (((size_t)3) << 60))
#endif

#if (LG_SIZEOF_PTR == 2 && LG_TINY_MIN == 3 && LG_QUANTUM == 3 && LG_PAGE == 14)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      3,        3,      0,  no, yes,   1,  3) \
    SC(  1,      3,        3,      1,  no, yes,   1,  3) \
    SC(  2,      3,        3,      2,  no, yes,   3,  3) \
    SC(  3,      3,        3,      3,  no, yes,   1,  3) \
                                                         \
    SC(  4,      5,        3,      1,  no, yes,   5,  3) \
    SC(  5,      5,        3,      2,  no, yes,   3,  3) \
    SC(  6,      5,        3,      3,  no, yes,   7,  3) \
    SC(  7,      5,        3,      4,  no, yes,   1,  3) \
                                                         \
    SC(  8,      6,        4,      1,  no, yes,   5,  4) \
    SC(  9,      6,        4,      2,  no, yes,   3,  4) \
    SC( 10,      6,        4,      3,  no, yes,   7,  4) \
    SC( 11,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC( 12,      7,        5,      1,  no, yes,   5,  5) \
    SC( 13,      7,        5,      2,  no, yes,   3,  5) \
    SC( 14,      7,        5,      3,  no, yes,   7,  5) \
    SC( 15,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 16,      8,        6,      1,  no, yes,   5,  6) \
    SC( 17,      8,        6,      2,  no, yes,   3,  6) \
    SC( 18,      8,        6,      3,  no, yes,   7,  6) \
    SC( 19,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 20,      9,        7,      1,  no, yes,   5,  7) \
    SC( 21,      9,        7,      2,  no, yes,   3,  7) \
    SC( 22,      9,        7,      3,  no, yes,   7,  7) \
    SC( 23,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 24,     10,        8,      1,  no, yes,   5,  8) \
    SC( 25,     10,        8,      2,  no, yes,   3,  8) \
    SC( 26,     10,        8,      3,  no, yes,   7,  8) \
    SC( 27,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 28,     11,        9,      1,  no, yes,   5,  9) \
    SC( 29,     11,        9,      2,  no, yes,   3,  9) \
    SC( 30,     11,        9,      3,  no, yes,   7,  9) \
    SC( 31,     11,        9,      4,  no, yes,   1,  9) \
                                                         \
    SC( 32,     12,       10,      1,  no, yes,   5, no) \
    SC( 33,     12,       10,      2,  no, yes,   3, no) \
    SC( 34,     12,       10,      3,  no, yes,   7, no) \
    SC( 35,     12,       10,      4,  no, yes,   1, no) \
                                                         \
    SC( 36,     13,       11,      1,  no, yes,   5, no) \
    SC( 37,     13,       11,      2,  no, yes,   3, no) \
    SC( 38,     13,       11,      3,  no, yes,   7, no) \
    SC( 39,     13,       11,      4, yes, yes,   1, no) \
                                                         \
    SC( 40,     14,       12,      1,  no, yes,   5, no) \
    SC( 41,     14,       12,      2,  no, yes,   3, no) \
    SC( 42,     14,       12,      3,  no, yes,   7, no) \
    SC( 43,     14,       12,      4, yes, yes,   2, no) \
                                                         \
    SC( 44,     15,       13,      1,  no, yes,   5, no) \
    SC( 45,     15,       13,      2, yes, yes,   3, no) \
    SC( 46,     15,       13,      3,  no, yes,   7, no) \
    SC( 47,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 48,     16,       14,      1, yes,  no,   0, no) \
    SC( 49,     16,       14,      2, yes,  no,   0, no) \
    SC( 50,     16,       14,      3, yes,  no,   0, no) \
    SC( 51,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 52,     17,       15,      1, yes,  no,   0, no) \
    SC( 53,     17,       15,      2, yes,  no,   0, no) \
    SC( 54,     17,       15,      3, yes,  no,   0, no) \
    SC( 55,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 56,     18,       16,      1, yes,  no,   0, no) \
    SC( 57,     18,       16,      2, yes,  no,   0, no) \
    SC( 58,     18,       16,      3, yes,  no,   0, no) \
    SC( 59,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 60,     19,       17,      1, yes,  no,   0, no) \
    SC( 61,     19,       17,      2, yes,  no,   0, no) \
    SC( 62,     19,       17,      3, yes,  no,   0, no) \
    SC( 63,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 64,     20,       18,      1, yes,  no,   0, no) \
    SC( 65,     20,       18,      2, yes,  no,   0, no) \
    SC( 66,     20,       18,      3, yes,  no,   0, no) \
    SC( 67,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 68,     21,       19,      1, yes,  no,   0, no) \
    SC( 69,     21,       19,      2, yes,  no,   0, no) \
    SC( 70,     21,       19,      3, yes,  no,   0, no) \
    SC( 71,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 72,     22,       20,      1, yes,  no,   0, no) \
    SC( 73,     22,       20,      2, yes,  no,   0, no) \
    SC( 74,     22,       20,      3, yes,  no,   0, no) \
    SC( 75,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 76,     23,       21,      1, yes,  no,   0, no) \
    SC( 77,     23,       21,      2, yes,  no,   0, no) \
    SC( 78,     23,       21,      3, yes,  no,   0, no) \
    SC( 79,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 80,     24,       22,      1, yes,  no,   0, no) \
    SC( 81,     24,       22,      2, yes,  no,   0, no) \
    SC( 82,     24,       22,      3, yes,  no,   0, no) \
    SC( 83,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 84,     25,       23,      1, yes,  no,   0, no) \
    SC( 85,     25,       23,      2, yes,  no,   0, no) \
    SC( 86,     25,       23,      3, yes,  no,   0, no) \
    SC( 87,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 88,     26,       24,      1, yes,  no,   0, no) \
    SC( 89,     26,       24,      2, yes,  no,   0, no) \
    SC( 90,     26,       24,      3, yes,  no,   0, no) \
    SC( 91,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 92,     27,       25,      1, yes,  no,   0, no) \
    SC( 93,     27,       25,      2, yes,  no,   0, no) \
    SC( 94,     27,       25,      3, yes,  no,   0, no) \
    SC( 95,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 96,     28,       26,      1, yes,  no,   0, no) \
    SC( 97,     28,       26,      2, yes,  no,   0, no) \
    SC( 98,     28,       26,      3, yes,  no,   0, no) \
    SC( 99,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC(100,     29,       27,      1, yes,  no,   0, no) \
    SC(101,     29,       27,      2, yes,  no,   0, no) \
    SC(102,     29,       27,      3, yes,  no,   0, no) \
    SC(103,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(104,     30,       28,      1, yes,  no,   0, no) \
    SC(105,     30,       28,      2, yes,  no,   0, no) \
    SC(106,     30,       28,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			0
#define NLBINS			32
#define NBINS			47
#define NSIZES			107
#define LG_CEIL_NSIZES		7
#define NPSIZES			63
#define LG_TINY_MAXCLASS	"NA"
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 15) + (((size_t)3) << 13))
#define LG_LARGE_MINCLASS	16
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 30) + (((size_t)3) << 28))
#endif

#if (LG_SIZEOF_PTR == 3 && LG_TINY_MIN == 3 && LG_QUANTUM == 3 && LG_PAGE == 14)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      3,        3,      0,  no, yes,   1,  3) \
    SC(  1,      3,        3,      1,  no, yes,   1,  3) \
    SC(  2,      3,        3,      2,  no, yes,   3,  3) \
    SC(  3,      3,        3,      3,  no, yes,   1,  3) \
                                                         \
    SC(  4,      5,        3,      1,  no, yes,   5,  3) \
    SC(  5,      5,        3,      2,  no, yes,   3,  3) \
    SC(  6,      5,        3,      3,  no, yes,   7,  3) \
    SC(  7,      5,        3,      4,  no, yes,   1,  3) \
                                                         \
    SC(  8,      6,        4,      1,  no, yes,   5,  4) \
    SC(  9,      6,        4,      2,  no, yes,   3,  4) \
    SC( 10,      6,        4,      3,  no, yes,   7,  4) \
    SC( 11,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC( 12,      7,        5,      1,  no, yes,   5,  5) \
    SC( 13,      7,        5,      2,  no, yes,   3,  5) \
    SC( 14,      7,        5,      3,  no, yes,   7,  5) \
    SC( 15,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 16,      8,        6,      1,  no, yes,   5,  6) \
    SC( 17,      8,        6,      2,  no, yes,   3,  6) \
    SC( 18,      8,        6,      3,  no, yes,   7,  6) \
    SC( 19,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 20,      9,        7,      1,  no, yes,   5,  7) \
    SC( 21,      9,        7,      2,  no, yes,   3,  7) \
    SC( 22,      9,        7,      3,  no, yes,   7,  7) \
    SC( 23,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 24,     10,        8,      1,  no, yes,   5,  8) \
    SC( 25,     10,        8,      2,  no, yes,   3,  8) \
    SC( 26,     10,        8,      3,  no, yes,   7,  8) \
    SC( 27,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 28,     11,        9,      1,  no, yes,   5,  9) \
    SC( 29,     11,        9,      2,  no, yes,   3,  9) \
    SC( 30,     11,        9,      3,  no, yes,   7,  9) \
    SC( 31,     11,        9,      4,  no, yes,   1,  9) \
                                                         \
    SC( 32,     12,       10,      1,  no, yes,   5, no) \
    SC( 33,     12,       10,      2,  no, yes,   3, no) \
    SC( 34,     12,       10,      3,  no, yes,   7, no) \
    SC( 35,     12,       10,      4,  no, yes,   1, no) \
                                                         \
    SC( 36,     13,       11,      1,  no, yes,   5, no) \
    SC( 37,     13,       11,      2,  no, yes,   3, no) \
    SC( 38,     13,       11,      3,  no, yes,   7, no) \
    SC( 39,     13,       11,      4, yes, yes,   1, no) \
                                                         \
    SC( 40,     14,       12,      1,  no, yes,   5, no) \
    SC( 41,     14,       12,      2,  no, yes,   3, no) \
    SC( 42,     14,       12,      3,  no, yes,   7, no) \
    SC( 43,     14,       12,      4, yes, yes,   2, no) \
                                                         \
    SC( 44,     15,       13,      1,  no, yes,   5, no) \
    SC( 45,     15,       13,      2, yes, yes,   3, no) \
    SC( 46,     15,       13,      3,  no, yes,   7, no) \
    SC( 47,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 48,     16,       14,      1, yes,  no,   0, no) \
    SC( 49,     16,       14,      2, yes,  no,   0, no) \
    SC( 50,     16,       14,      3, yes,  no,   0, no) \
    SC( 51,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 52,     17,       15,      1, yes,  no,   0, no) \
    SC( 53,     17,       15,      2, yes,  no,   0, no) \
    SC( 54,     17,       15,      3, yes,  no,   0, no) \
    SC( 55,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 56,     18,       16,      1, yes,  no,   0, no) \
    SC( 57,     18,       16,      2, yes,  no,   0, no) \
    SC( 58,     18,       16,      3, yes,  no,   0, no) \
    SC( 59,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 60,     19,       17,      1, yes,  no,   0, no) \
    SC( 61,     19,       17,      2, yes,  no,   0, no) \
    SC( 62,     19,       17,      3, yes,  no,   0, no) \
    SC( 63,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 64,     20,       18,      1, yes,  no,   0, no) \
    SC( 65,     20,       18,      2, yes,  no,   0, no) \
    SC( 66,     20,       18,      3, yes,  no,   0, no) \
    SC( 67,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 68,     21,       19,      1, yes,  no,   0, no) \
    SC( 69,     21,       19,      2, yes,  no,   0, no) \
    SC( 70,     21,       19,      3, yes,  no,   0, no) \
    SC( 71,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 72,     22,       20,      1, yes,  no,   0, no) \
    SC( 73,     22,       20,      2, yes,  no,   0, no) \
    SC( 74,     22,       20,      3, yes,  no,   0, no) \
    SC( 75,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 76,     23,       21,      1, yes,  no,   0, no) \
    SC( 77,     23,       21,      2, yes,  no,   0, no) \
    SC( 78,     23,       21,      3, yes,  no,   0, no) \
    SC( 79,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 80,     24,       22,      1, yes,  no,   0, no) \
    SC( 81,     24,       22,      2, yes,  no,   0, no) \
    SC( 82,     24,       22,      3, yes,  no,   0, no) \
    SC( 83,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 84,     25,       23,      1, yes,  no,   0, no) \
    SC( 85,     25,       23,      2, yes,  no,   0, no) \
    SC( 86,     25,       23,      3, yes,  no,   0, no) \
    SC( 87,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 88,     26,       24,      1, yes,  no,   0, no) \
    SC( 89,     26,       24,      2, yes,  no,   0, no) \
    SC( 90,     26,       24,      3, yes,  no,   0, no) \
    SC( 91,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 92,     27,       25,      1, yes,  no,   0, no) \
    SC( 93,     27,       25,      2, yes,  no,   0, no) \
    SC( 94,     27,       25,      3, yes,  no,   0, no) \
    SC( 95,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 96,     28,       26,      1, yes,  no,   0, no) \
    SC( 97,     28,       26,      2, yes,  no,   0, no) \
    SC( 98,     28,       26,      3, yes,  no,   0, no) \
    SC( 99,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC(100,     29,       27,      1, yes,  no,   0, no) \
    SC(101,     29,       27,      2, yes,  no,   0, no) \
    SC(102,     29,       27,      3, yes,  no,   0, no) \
    SC(103,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(104,     30,       28,      1, yes,  no,   0, no) \
    SC(105,     30,       28,      2, yes,  no,   0, no) \
    SC(106,     30,       28,      3, yes,  no,   0, no) \
    SC(107,     30,       28,      4, yes,  no,   0, no) \
                                                         \
    SC(108,     31,       29,      1, yes,  no,   0, no) \
    SC(109,     31,       29,      2, yes,  no,   0, no) \
    SC(110,     31,       29,      3, yes,  no,   0, no) \
    SC(111,     31,       29,      4, yes,  no,   0, no) \
                                                         \
    SC(112,     32,       30,      1, yes,  no,   0, no) \
    SC(113,     32,       30,      2, yes,  no,   0, no) \
    SC(114,     32,       30,      3, yes,  no,   0, no) \
    SC(115,     32,       30,      4, yes,  no,   0, no) \
                                                         \
    SC(116,     33,       31,      1, yes,  no,   0, no) \
    SC(117,     33,       31,      2, yes,  no,   0, no) \
    SC(118,     33,       31,      3, yes,  no,   0, no) \
    SC(119,     33,       31,      4, yes,  no,   0, no) \
                                                         \
    SC(120,     34,       32,      1, yes,  no,   0, no) \
    SC(121,     34,       32,      2, yes,  no,   0, no) \
    SC(122,     34,       32,      3, yes,  no,   0, no) \
    SC(123,     34,       32,      4, yes,  no,   0, no) \
                                                         \
    SC(124,     35,       33,      1, yes,  no,   0, no) \
    SC(125,     35,       33,      2, yes,  no,   0, no) \
    SC(126,     35,       33,      3, yes,  no,   0, no) \
    SC(127,     35,       33,      4, yes,  no,   0, no) \
                                                         \
    SC(128,     36,       34,      1, yes,  no,   0, no) \
    SC(129,     36,       34,      2, yes,  no,   0, no) \
    SC(130,     36,       34,      3, yes,  no,   0, no) \
    SC(131,     36,       34,      4, yes,  no,   0, no) \
                                                         \
    SC(132,     37,       35,      1, yes,  no,   0, no) \
    SC(133,     37,       35,      2, yes,  no,   0, no) \
    SC(134,     37,       35,      3, yes,  no,   0, no) \
    SC(135,     37,       35,      4, yes,  no,   0, no) \
                                                         \
    SC(136,     38,       36,      1, yes,  no,   0, no) \
    SC(137,     38,       36,      2, yes,  no,   0, no) \
    SC(138,     38,       36,      3, yes,  no,   0, no) \
    SC(139,     38,       36,      4, yes,  no,   0, no) \
                                                         \
    SC(140,     39,       37,      1, yes,  no,   0, no) \
    SC(141,     39,       37,      2, yes,  no,   0, no) \
    SC(142,     39,       37,      3, yes,  no,   0, no) \
    SC(143,     39,       37,      4, yes,  no,   0, no) \
                                                         \
    SC(144,     40,       38,      1, yes,  no,   0, no) \
    SC(145,     40,       38,      2, yes,  no,   0, no) \
    SC(146,     40,       38,      3, yes,  no,   0, no) \
    SC(147,     40,       38,      4, yes,  no,   0, no) \
                                                         \
    SC(148,     41,       39,      1, yes,  no,   0, no) \
    SC(149,     41,       39,      2, yes,  no,   0, no) \
    SC(150,     41,       39,      3, yes,  no,   0, no) \
    SC(151,     41,       39,      4, yes,  no,   0, no) \
                                                         \
    SC(152,     42,       40,      1, yes,  no,   0, no) \
    SC(153,     42,       40,      2, yes,  no,   0, no) \
    SC(154,     42,       40,      3, yes,  no,   0, no) \
    SC(155,     42,       40,      4, yes,  no,   0, no) \
                                                         \
    SC(156,     43,       41,      1, yes,  no,   0, no) \
    SC(157,     43,       41,      2, yes,  no,   0, no) \
    SC(158,     43,       41,      3, yes,  no,   0, no) \
    SC(159,     43,       41,      4, yes,  no,   0, no) \
                                                         \
    SC(160,     44,       42,      1, yes,  no,   0, no) \
    SC(161,     44,       42,      2, yes,  no,   0, no) \
    SC(162,     44,       42,      3, yes,  no,   0, no) \
    SC(163,     44,       42,      4, yes,  no,   0, no) \
                                                         \
    SC(164,     45,       43,      1, yes,  no,   0, no) \
    SC(165,     45,       43,      2, yes,  no,   0, no) \
    SC(166,     45,       43,      3, yes,  no,   0, no) \
    SC(167,     45,       43,      4, yes,  no,   0, no) \
                                                         \
    SC(168,     46,       44,      1, yes,  no,   0, no) \
    SC(169,     46,       44,      2, yes,  no,   0, no) \
    SC(170,     46,       44,      3, yes,  no,   0, no) \
    SC(171,     46,       44,      4, yes,  no,   0, no) \
                                                         \
    SC(172,     47,       45,      1, yes,  no,   0, no) \
    SC(173,     47,       45,      2, yes,  no,   0, no) \
    SC(174,     47,       45,      3, yes,  no,   0, no) \
    SC(175,     47,       45,      4, yes,  no,   0, no) \
                                                         \
    SC(176,     48,       46,      1, yes,  no,   0, no) \
    SC(177,     48,       46,      2, yes,  no,   0, no) \
    SC(178,     48,       46,      3, yes,  no,   0, no) \
    SC(179,     48,       46,      4, yes,  no,   0, no) \
                                                         \
    SC(180,     49,       47,      1, yes,  no,   0, no) \
    SC(181,     49,       47,      2, yes,  no,   0, no) \
    SC(182,     49,       47,      3, yes,  no,   0, no) \
    SC(183,     49,       47,      4, yes,  no,   0, no) \
                                                         \
    SC(184,     50,       48,      1, yes,  no,   0, no) \
    SC(185,     50,       48,      2, yes,  no,   0, no) \
    SC(186,     50,       48,      3, yes,  no,   0, no) \
    SC(187,     50,       48,      4, yes,  no,   0, no) \
                                                         \
    SC(188,     51,       49,      1, yes,  no,   0, no) \
    SC(189,     51,       49,      2, yes,  no,   0, no) \
    SC(190,     51,       49,      3, yes,  no,   0, no) \
    SC(191,     51,       49,      4, yes,  no,   0, no) \
                                                         \
    SC(192,     52,       50,      1, yes,  no,   0, no) \
    SC(193,     52,       50,      2, yes,  no,   0, no) \
    SC(194,     52,       50,      3, yes,  no,   0, no) \
    SC(195,     52,       50,      4, yes,  no,   0, no) \
                                                         \
    SC(196,     53,       51,      1, yes,  no,   0, no) \
    SC(197,     53,       51,      2, yes,  no,   0, no) \
    SC(198,     53,       51,      3, yes,  no,   0, no) \
    SC(199,     53,       51,      4, yes,  no,   0, no) \
                                                         \
    SC(200,     54,       52,      1, yes,  no,   0, no) \
    SC(201,     54,       52,      2, yes,  no,   0, no) \
    SC(202,     54,       52,      3, yes,  no,   0, no) \
    SC(203,     54,       52,      4, yes,  no,   0, no) \
                                                         \
    SC(204,     55,       53,      1, yes,  no,   0, no) \
    SC(205,     55,       53,      2, yes,  no,   0, no) \
    SC(206,     55,       53,      3, yes,  no,   0, no) \
    SC(207,     55,       53,      4, yes,  no,   0, no) \
                                                         \
    SC(208,     56,       54,      1, yes,  no,   0, no) \
    SC(209,     56,       54,      2, yes,  no,   0, no) \
    SC(210,     56,       54,      3, yes,  no,   0, no) \
    SC(211,     56,       54,      4, yes,  no,   0, no) \
                                                         \
    SC(212,     57,       55,      1, yes,  no,   0, no) \
    SC(213,     57,       55,      2, yes,  no,   0, no) \
    SC(214,     57,       55,      3, yes,  no,   0, no) \
    SC(215,     57,       55,      4, yes,  no,   0, no) \
                                                         \
    SC(216,     58,       56,      1, yes,  no,   0, no) \
    SC(217,     58,       56,      2, yes,  no,   0, no) \
    SC(218,     58,       56,      3, yes,  no,   0, no) \
    SC(219,     58,       56,      4, yes,  no,   0, no) \
                                                         \
    SC(220,     59,       57,      1, yes,  no,   0, no) \
    SC(221,     59,       57,      2, yes,  no,   0, no) \
    SC(222,     59,       57,      3, yes,  no,   0, no) \
    SC(223,     59,       57,      4, yes,  no,   0, no) \
                                                         \
    SC(224,     60,       58,      1, yes,  no,   0, no) \
    SC(225,     60,       58,      2, yes,  no,   0, no) \
    SC(226,     60,       58,      3, yes,  no,   0, no) \
    SC(227,     60,       58,      4, yes,  no,   0, no) \
                                                         \
    SC(228,     61,       59,      1, yes,  no,   0, no) \
    SC(229,     61,       59,      2, yes,  no,   0, no) \
    SC(230,     61,       59,      3, yes,  no,   0, no) \
    SC(231,     61,       59,      4, yes,  no,   0, no) \
                                                         \
    SC(232,     62,       60,      1, yes,  no,   0, no) \
    SC(233,     62,       60,      2, yes,  no,   0, no) \
    SC(234,     62,       60,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			0
#define NLBINS			32
#define NBINS			47
#define NSIZES			235
#define LG_CEIL_NSIZES		8
#define NPSIZES			191
#define LG_TINY_MAXCLASS	"NA"
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 15) + (((size_t)3) << 13))
#define LG_LARGE_MINCLASS	16
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 62) + (((size_t)3) << 60))
#endif

#if (LG_SIZEOF_PTR == 2 && LG_TINY_MIN == 3 && LG_QUANTUM == 4 && LG_PAGE == 14)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      3,        3,      0,  no, yes,   1,  3) \
                                                         \
    SC(  1,      3,        3,      1,  no, yes,   1,  3) \
    SC(  2,      4,        4,      1,  no, yes,   1,  4) \
    SC(  3,      4,        4,      2,  no, yes,   3,  4) \
    SC(  4,      4,        4,      3,  no, yes,   1,  4) \
                                                         \
    SC(  5,      6,        4,      1,  no, yes,   5,  4) \
    SC(  6,      6,        4,      2,  no, yes,   3,  4) \
    SC(  7,      6,        4,      3,  no, yes,   7,  4) \
    SC(  8,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC(  9,      7,        5,      1,  no, yes,   5,  5) \
    SC( 10,      7,        5,      2,  no, yes,   3,  5) \
    SC( 11,      7,        5,      3,  no, yes,   7,  5) \
    SC( 12,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 13,      8,        6,      1,  no, yes,   5,  6) \
    SC( 14,      8,        6,      2,  no, yes,   3,  6) \
    SC( 15,      8,        6,      3,  no, yes,   7,  6) \
    SC( 16,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 17,      9,        7,      1,  no, yes,   5,  7) \
    SC( 18,      9,        7,      2,  no, yes,   3,  7) \
    SC( 19,      9,        7,      3,  no, yes,   7,  7) \
    SC( 20,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 21,     10,        8,      1,  no, yes,   5,  8) \
    SC( 22,     10,        8,      2,  no, yes,   3,  8) \
    SC( 23,     10,        8,      3,  no, yes,   7,  8) \
    SC( 24,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 25,     11,        9,      1,  no, yes,   5,  9) \
    SC( 26,     11,        9,      2,  no, yes,   3,  9) \
    SC( 27,     11,        9,      3,  no, yes,   7,  9) \
    SC( 28,     11,        9,      4,  no, yes,   1,  9) \
                                                         \
    SC( 29,     12,       10,      1,  no, yes,   5, no) \
    SC( 30,     12,       10,      2,  no, yes,   3, no) \
    SC( 31,     12,       10,      3,  no, yes,   7, no) \
    SC( 32,     12,       10,      4,  no, yes,   1, no) \
                                                         \
    SC( 33,     13,       11,      1,  no, yes,   5, no) \
    SC( 34,     13,       11,      2,  no, yes,   3, no) \
    SC( 35,     13,       11,      3,  no, yes,   7, no) \
    SC( 36,     13,       11,      4, yes, yes,   1, no) \
                                                         \
    SC( 37,     14,       12,      1,  no, yes,   5, no) \
    SC( 38,     14,       12,      2,  no, yes,   3, no) \
    SC( 39,     14,       12,      3,  no, yes,   7, no) \
    SC( 40,     14,       12,      4, yes, yes,   2, no) \
                                                         \
    SC( 41,     15,       13,      1,  no, yes,   5, no) \
    SC( 42,     15,       13,      2, yes, yes,   3, no) \
    SC( 43,     15,       13,      3,  no, yes,   7, no) \
    SC( 44,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 45,     16,       14,      1, yes,  no,   0, no) \
    SC( 46,     16,       14,      2, yes,  no,   0, no) \
    SC( 47,     16,       14,      3, yes,  no,   0, no) \
    SC( 48,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 49,     17,       15,      1, yes,  no,   0, no) \
    SC( 50,     17,       15,      2, yes,  no,   0, no) \
    SC( 51,     17,       15,      3, yes,  no,   0, no) \
    SC( 52,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 53,     18,       16,      1, yes,  no,   0, no) \
    SC( 54,     18,       16,      2, yes,  no,   0, no) \
    SC( 55,     18,       16,      3, yes,  no,   0, no) \
    SC( 56,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 57,     19,       17,      1, yes,  no,   0, no) \
    SC( 58,     19,       17,      2, yes,  no,   0, no) \
    SC( 59,     19,       17,      3, yes,  no,   0, no) \
    SC( 60,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 61,     20,       18,      1, yes,  no,   0, no) \
    SC( 62,     20,       18,      2, yes,  no,   0, no) \
    SC( 63,     20,       18,      3, yes,  no,   0, no) \
    SC( 64,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 65,     21,       19,      1, yes,  no,   0, no) \
    SC( 66,     21,       19,      2, yes,  no,   0, no) \
    SC( 67,     21,       19,      3, yes,  no,   0, no) \
    SC( 68,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 69,     22,       20,      1, yes,  no,   0, no) \
    SC( 70,     22,       20,      2, yes,  no,   0, no) \
    SC( 71,     22,       20,      3, yes,  no,   0, no) \
    SC( 72,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 73,     23,       21,      1, yes,  no,   0, no) \
    SC( 74,     23,       21,      2, yes,  no,   0, no) \
    SC( 75,     23,       21,      3, yes,  no,   0, no) \
    SC( 76,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 77,     24,       22,      1, yes,  no,   0, no) \
    SC( 78,     24,       22,      2, yes,  no,   0, no) \
    SC( 79,     24,       22,      3, yes,  no,   0, no) \
    SC( 80,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 81,     25,       23,      1, yes,  no,   0, no) \
    SC( 82,     25,       23,      2, yes,  no,   0, no) \
    SC( 83,     25,       23,      3, yes,  no,   0, no) \
    SC( 84,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 85,     26,       24,      1, yes,  no,   0, no) \
    SC( 86,     26,       24,      2, yes,  no,   0, no) \
    SC( 87,     26,       24,      3, yes,  no,   0, no) \
    SC( 88,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 89,     27,       25,      1, yes,  no,   0, no) \
    SC( 90,     27,       25,      2, yes,  no,   0, no) \
    SC( 91,     27,       25,      3, yes,  no,   0, no) \
    SC( 92,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 93,     28,       26,      1, yes,  no,   0, no) \
    SC( 94,     28,       26,      2, yes,  no,   0, no) \
    SC( 95,     28,       26,      3, yes,  no,   0, no) \
    SC( 96,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC( 97,     29,       27,      1, yes,  no,   0, no) \
    SC( 98,     29,       27,      2, yes,  no,   0, no) \
    SC( 99,     29,       27,      3, yes,  no,   0, no) \
    SC(100,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(101,     30,       28,      1, yes,  no,   0, no) \
    SC(102,     30,       28,      2, yes,  no,   0, no) \
    SC(103,     30,       28,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			1
#define NLBINS			29
#define NBINS			44
#define NSIZES			104
#define LG_CEIL_NSIZES		7
#define NPSIZES			63
#define LG_TINY_MAXCLASS	3
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 15) + (((size_t)3) << 13))
#define LG_LARGE_MINCLASS	16
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 30) + (((size_t)3) << 28))
#endif

#if (LG_SIZEOF_PTR == 2 && LG_TINY_MIN == 4 && LG_QUANTUM == 4 && LG_PAGE == 14)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      4,        4,      0,  no, yes,   1,  4) \
    SC(  1,      4,        4,      1,  no, yes,   1,  4) \
    SC(  2,      4,        4,      2,  no, yes,   3,  4) \
    SC(  3,      4,        4,      3,  no, yes,   1,  4) \
                                                         \
    SC(  4,      6,        4,      1,  no, yes,   5,  4) \
    SC(  5,      6,        4,      2,  no, yes,   3,  4) \
    SC(  6,      6,        4,      3,  no, yes,   7,  4) \
    SC(  7,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC(  8,      7,        5,      1,  no, yes,   5,  5) \
    SC(  9,      7,        5,      2,  no, yes,   3,  5) \
    SC( 10,      7,        5,      3,  no, yes,   7,  5) \
    SC( 11,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 12,      8,        6,      1,  no, yes,   5,  6) \
    SC( 13,      8,        6,      2,  no, yes,   3,  6) \
    SC( 14,      8,        6,      3,  no, yes,   7,  6) \
    SC( 15,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 16,      9,        7,      1,  no, yes,   5,  7) \
    SC( 17,      9,        7,      2,  no, yes,   3,  7) \
    SC( 18,      9,        7,      3,  no, yes,   7,  7) \
    SC( 19,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 20,     10,        8,      1,  no, yes,   5,  8) \
    SC( 21,     10,        8,      2,  no, yes,   3,  8) \
    SC( 22,     10,        8,      3,  no, yes,   7,  8) \
    SC( 23,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 24,     11,        9,      1,  no, yes,   5,  9) \
    SC( 25,     11,        9,      2,  no, yes,   3,  9) \
    SC( 26,     11,        9,      3,  no, yes,   7,  9) \
    SC( 27,     11,        9,      4,  no, yes,   1,  9) \
                                                         \
    SC( 28,     12,       10,      1,  no, yes,   5, no) \
    SC( 29,     12,       10,      2,  no, yes,   3, no) \
    SC( 30,     12,       10,      3,  no, yes,   7, no) \
    SC( 31,     12,       10,      4,  no, yes,   1, no) \
                                                         \
    SC( 32,     13,       11,      1,  no, yes,   5, no) \
    SC( 33,     13,       11,      2,  no, yes,   3, no) \
    SC( 34,     13,       11,      3,  no, yes,   7, no) \
    SC( 35,     13,       11,      4, yes, yes,   1, no) \
                                                         \
    SC( 36,     14,       12,      1,  no, yes,   5, no) \
    SC( 37,     14,       12,      2,  no, yes,   3, no) \
    SC( 38,     14,       12,      3,  no, yes,   7, no) \
    SC( 39,     14,       12,      4, yes, yes,   2, no) \
                                                         \
    SC( 40,     15,       13,      1,  no, yes,   5, no) \
    SC( 41,     15,       13,      2, yes, yes,   3, no) \
    SC( 42,     15,       13,      3,  no, yes,   7, no) \
    SC( 43,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 44,     16,       14,      1, yes,  no,   0, no) \
    SC( 45,     16,       14,      2, yes,  no,   0, no) \
    SC( 46,     16,       14,      3, yes,  no,   0, no) \
    SC( 47,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 48,     17,       15,      1, yes,  no,   0, no) \
    SC( 49,     17,       15,      2, yes,  no,   0, no) \
    SC( 50,     17,       15,      3, yes,  no,   0, no) \
    SC( 51,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 52,     18,       16,      1, yes,  no,   0, no) \
    SC( 53,     18,       16,      2, yes,  no,   0, no) \
    SC( 54,     18,       16,      3, yes,  no,   0, no) \
    SC( 55,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 56,     19,       17,      1, yes,  no,   0, no) \
    SC( 57,     19,       17,      2, yes,  no,   0, no) \
    SC( 58,     19,       17,      3, yes,  no,   0, no) \
    SC( 59,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 60,     20,       18,      1, yes,  no,   0, no) \
    SC( 61,     20,       18,      2, yes,  no,   0, no) \
    SC( 62,     20,       18,      3, yes,  no,   0, no) \
    SC( 63,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 64,     21,       19,      1, yes,  no,   0, no) \
    SC( 65,     21,       19,      2, yes,  no,   0, no) \
    SC( 66,     21,       19,      3, yes,  no,   0, no) \
    SC( 67,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 68,     22,       20,      1, yes,  no,   0, no) \
    SC( 69,     22,       20,      2, yes,  no,   0, no) \
    SC( 70,     22,       20,      3, yes,  no,   0, no) \
    SC( 71,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 72,     23,       21,      1, yes,  no,   0, no) \
    SC( 73,     23,       21,      2, yes,  no,   0, no) \
    SC( 74,     23,       21,      3, yes,  no,   0, no) \
    SC( 75,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 76,     24,       22,      1, yes,  no,   0, no) \
    SC( 77,     24,       22,      2, yes,  no,   0, no) \
    SC( 78,     24,       22,      3, yes,  no,   0, no) \
    SC( 79,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 80,     25,       23,      1, yes,  no,   0, no) \
    SC( 81,     25,       23,      2, yes,  no,   0, no) \
    SC( 82,     25,       23,      3, yes,  no,   0, no) \
    SC( 83,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 84,     26,       24,      1, yes,  no,   0, no) \
    SC( 85,     26,       24,      2, yes,  no,   0, no) \
    SC( 86,     26,       24,      3, yes,  no,   0, no) \
    SC( 87,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 88,     27,       25,      1, yes,  no,   0, no) \
    SC( 89,     27,       25,      2, yes,  no,   0, no) \
    SC( 90,     27,       25,      3, yes,  no,   0, no) \
    SC( 91,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 92,     28,       26,      1, yes,  no,   0, no) \
    SC( 93,     28,       26,      2, yes,  no,   0, no) \
    SC( 94,     28,       26,      3, yes,  no,   0, no) \
    SC( 95,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC( 96,     29,       27,      1, yes,  no,   0, no) \
    SC( 97,     29,       27,      2, yes,  no,   0, no) \
    SC( 98,     29,       27,      3, yes,  no,   0, no) \
    SC( 99,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(100,     30,       28,      1, yes,  no,   0, no) \
    SC(101,     30,       28,      2, yes,  no,   0, no) \
    SC(102,     30,       28,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			0
#define NLBINS			28
#define NBINS			43
#define NSIZES			103
#define LG_CEIL_NSIZES		7
#define NPSIZES			63
#define LG_TINY_MAXCLASS	"NA"
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 15) + (((size_t)3) << 13))
#define LG_LARGE_MINCLASS	16
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 30) + (((size_t)3) << 28))
#endif

#if (LG_SIZEOF_PTR == 3 && LG_TINY_MIN == 3 && LG_QUANTUM == 4 && LG_PAGE == 14)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      3,        3,      0,  no, yes,   1,  3) \
                                                         \
    SC(  1,      3,        3,      1,  no, yes,   1,  3) \
    SC(  2,      4,        4,      1,  no, yes,   1,  4) \
    SC(  3,      4,        4,      2,  no, yes,   3,  4) \
    SC(  4,      4,        4,      3,  no, yes,   1,  4) \
                                                         \
    SC(  5,      6,        4,      1,  no, yes,   5,  4) \
    SC(  6,      6,        4,      2,  no, yes,   3,  4) \
    SC(  7,      6,        4,      3,  no, yes,   7,  4) \
    SC(  8,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC(  9,      7,        5,      1,  no, yes,   5,  5) \
    SC( 10,      7,        5,      2,  no, yes,   3,  5) \
    SC( 11,      7,        5,      3,  no, yes,   7,  5) \
    SC( 12,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 13,      8,        6,      1,  no, yes,   5,  6) \
    SC( 14,      8,        6,      2,  no, yes,   3,  6) \
    SC( 15,      8,        6,      3,  no, yes,   7,  6) \
    SC( 16,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 17,      9,        7,      1,  no, yes,   5,  7) \
    SC( 18,      9,        7,      2,  no, yes,   3,  7) \
    SC( 19,      9,        7,      3,  no, yes,   7,  7) \
    SC( 20,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 21,     10,        8,      1,  no, yes,   5,  8) \
    SC( 22,     10,        8,      2,  no, yes,   3,  8) \
    SC( 23,     10,        8,      3,  no, yes,   7,  8) \
    SC( 24,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 25,     11,        9,      1,  no, yes,   5,  9) \
    SC( 26,     11,        9,      2,  no, yes,   3,  9) \
    SC( 27,     11,        9,      3,  no, yes,   7,  9) \
    SC( 28,     11,        9,      4,  no, yes,   1,  9) \
                                                         \
    SC( 29,     12,       10,      1,  no, yes,   5, no) \
    SC( 30,     12,       10,      2,  no, yes,   3, no) \
    SC( 31,     12,       10,      3,  no, yes,   7, no) \
    SC( 32,     12,       10,      4,  no, yes,   1, no) \
                                                         \
    SC( 33,     13,       11,      1,  no, yes,   5, no) \
    SC( 34,     13,       11,      2,  no, yes,   3, no) \
    SC( 35,     13,       11,      3,  no, yes,   7, no) \
    SC( 36,     13,       11,      4, yes, yes,   1, no) \
                                                         \
    SC( 37,     14,       12,      1,  no, yes,   5, no) \
    SC( 38,     14,       12,      2,  no, yes,   3, no) \
    SC( 39,     14,       12,      3,  no, yes,   7, no) \
    SC( 40,     14,       12,      4, yes, yes,   2, no) \
                                                         \
    SC( 41,     15,       13,      1,  no, yes,   5, no) \
    SC( 42,     15,       13,      2, yes, yes,   3, no) \
    SC( 43,     15,       13,      3,  no, yes,   7, no) \
    SC( 44,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 45,     16,       14,      1, yes,  no,   0, no) \
    SC( 46,     16,       14,      2, yes,  no,   0, no) \
    SC( 47,     16,       14,      3, yes,  no,   0, no) \
    SC( 48,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 49,     17,       15,      1, yes,  no,   0, no) \
    SC( 50,     17,       15,      2, yes,  no,   0, no) \
    SC( 51,     17,       15,      3, yes,  no,   0, no) \
    SC( 52,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 53,     18,       16,      1, yes,  no,   0, no) \
    SC( 54,     18,       16,      2, yes,  no,   0, no) \
    SC( 55,     18,       16,      3, yes,  no,   0, no) \
    SC( 56,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 57,     19,       17,      1, yes,  no,   0, no) \
    SC( 58,     19,       17,      2, yes,  no,   0, no) \
    SC( 59,     19,       17,      3, yes,  no,   0, no) \
    SC( 60,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 61,     20,       18,      1, yes,  no,   0, no) \
    SC( 62,     20,       18,      2, yes,  no,   0, no) \
    SC( 63,     20,       18,      3, yes,  no,   0, no) \
    SC( 64,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 65,     21,       19,      1, yes,  no,   0, no) \
    SC( 66,     21,       19,      2, yes,  no,   0, no) \
    SC( 67,     21,       19,      3, yes,  no,   0, no) \
    SC( 68,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 69,     22,       20,      1, yes,  no,   0, no) \
    SC( 70,     22,       20,      2, yes,  no,   0, no) \
    SC( 71,     22,       20,      3, yes,  no,   0, no) \
    SC( 72,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 73,     23,       21,      1, yes,  no,   0, no) \
    SC( 74,     23,       21,      2, yes,  no,   0, no) \
    SC( 75,     23,       21,      3, yes,  no,   0, no) \
    SC( 76,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 77,     24,       22,      1, yes,  no,   0, no) \
    SC( 78,     24,       22,      2, yes,  no,   0, no) \
    SC( 79,     24,       22,      3, yes,  no,   0, no) \
    SC( 80,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 81,     25,       23,      1, yes,  no,   0, no) \
    SC( 82,     25,       23,      2, yes,  no,   0, no) \
    SC( 83,     25,       23,      3, yes,  no,   0, no) \
    SC( 84,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 85,     26,       24,      1, yes,  no,   0, no) \
    SC( 86,     26,       24,      2, yes,  no,   0, no) \
    SC( 87,     26,       24,      3, yes,  no,   0, no) \
    SC( 88,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 89,     27,       25,      1, yes,  no,   0, no) \
    SC( 90,     27,       25,      2, yes,  no,   0, no) \
    SC( 91,     27,       25,      3, yes,  no,   0, no) \
    SC( 92,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 93,     28,       26,      1, yes,  no,   0, no) \
    SC( 94,     28,       26,      2, yes,  no,   0, no) \
    SC( 95,     28,       26,      3, yes,  no,   0, no) \
    SC( 96,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC( 97,     29,       27,      1, yes,  no,   0, no) \
    SC( 98,     29,       27,      2, yes,  no,   0, no) \
    SC( 99,     29,       27,      3, yes,  no,   0, no) \
    SC(100,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(101,     30,       28,      1, yes,  no,   0, no) \
    SC(102,     30,       28,      2, yes,  no,   0, no) \
    SC(103,     30,       28,      3, yes,  no,   0, no) \
    SC(104,     30,       28,      4, yes,  no,   0, no) \
                                                         \
    SC(105,     31,       29,      1, yes,  no,   0, no) \
    SC(106,     31,       29,      2, yes,  no,   0, no) \
    SC(107,     31,       29,      3, yes,  no,   0, no) \
    SC(108,     31,       29,      4, yes,  no,   0, no) \
                                                         \
    SC(109,     32,       30,      1, yes,  no,   0, no) \
    SC(110,     32,       30,      2, yes,  no,   0, no) \
    SC(111,     32,       30,      3, yes,  no,   0, no) \
    SC(112,     32,       30,      4, yes,  no,   0, no) \
                                                         \
    SC(113,     33,       31,      1, yes,  no,   0, no) \
    SC(114,     33,       31,      2, yes,  no,   0, no) \
    SC(115,     33,       31,      3, yes,  no,   0, no) \
    SC(116,     33,       31,      4, yes,  no,   0, no) \
                                                         \
    SC(117,     34,       32,      1, yes,  no,   0, no) \
    SC(118,     34,       32,      2, yes,  no,   0, no) \
    SC(119,     34,       32,      3, yes,  no,   0, no) \
    SC(120,     34,       32,      4, yes,  no,   0, no) \
                                                         \
    SC(121,     35,       33,      1, yes,  no,   0, no) \
    SC(122,     35,       33,      2, yes,  no,   0, no) \
    SC(123,     35,       33,      3, yes,  no,   0, no) \
    SC(124,     35,       33,      4, yes,  no,   0, no) \
                                                         \
    SC(125,     36,       34,      1, yes,  no,   0, no) \
    SC(126,     36,       34,      2, yes,  no,   0, no) \
    SC(127,     36,       34,      3, yes,  no,   0, no) \
    SC(128,     36,       34,      4, yes,  no,   0, no) \
                                                         \
    SC(129,     37,       35,      1, yes,  no,   0, no) \
    SC(130,     37,       35,      2, yes,  no,   0, no) \
    SC(131,     37,       35,      3, yes,  no,   0, no) \
    SC(132,     37,       35,      4, yes,  no,   0, no) \
                                                         \
    SC(133,     38,       36,      1, yes,  no,   0, no) \
    SC(134,     38,       36,      2, yes,  no,   0, no) \
    SC(135,     38,       36,      3, yes,  no,   0, no) \
    SC(136,     38,       36,      4, yes,  no,   0, no) \
                                                         \
    SC(137,     39,       37,      1, yes,  no,   0, no) \
    SC(138,     39,       37,      2, yes,  no,   0, no) \
    SC(139,     39,       37,      3, yes,  no,   0, no) \
    SC(140,     39,       37,      4, yes,  no,   0, no) \
                                                         \
    SC(141,     40,       38,      1, yes,  no,   0, no) \
    SC(142,     40,       38,      2, yes,  no,   0, no) \
    SC(143,     40,       38,      3, yes,  no,   0, no) \
    SC(144,     40,       38,      4, yes,  no,   0, no) \
                                                         \
    SC(145,     41,       39,      1, yes,  no,   0, no) \
    SC(146,     41,       39,      2, yes,  no,   0, no) \
    SC(147,     41,       39,      3, yes,  no,   0, no) \
    SC(148,     41,       39,      4, yes,  no,   0, no) \
                                                         \
    SC(149,     42,       40,      1, yes,  no,   0, no) \
    SC(150,     42,       40,      2, yes,  no,   0, no) \
    SC(151,     42,       40,      3, yes,  no,   0, no) \
    SC(152,     42,       40,      4, yes,  no,   0, no) \
                                                         \
    SC(153,     43,       41,      1, yes,  no,   0, no) \
    SC(154,     43,       41,      2, yes,  no,   0, no) \
    SC(155,     43,       41,      3, yes,  no,   0, no) \
    SC(156,     43,       41,      4, yes,  no,   0, no) \
                                                         \
    SC(157,     44,       42,      1, yes,  no,   0, no) \
    SC(158,     44,       42,      2, yes,  no,   0, no) \
    SC(159,     44,       42,      3, yes,  no,   0, no) \
    SC(160,     44,       42,      4, yes,  no,   0, no) \
                                                         \
    SC(161,     45,       43,      1, yes,  no,   0, no) \
    SC(162,     45,       43,      2, yes,  no,   0, no) \
    SC(163,     45,       43,      3, yes,  no,   0, no) \
    SC(164,     45,       43,      4, yes,  no,   0, no) \
                                                         \
    SC(165,     46,       44,      1, yes,  no,   0, no) \
    SC(166,     46,       44,      2, yes,  no,   0, no) \
    SC(167,     46,       44,      3, yes,  no,   0, no) \
    SC(168,     46,       44,      4, yes,  no,   0, no) \
                                                         \
    SC(169,     47,       45,      1, yes,  no,   0, no) \
    SC(170,     47,       45,      2, yes,  no,   0, no) \
    SC(171,     47,       45,      3, yes,  no,   0, no) \
    SC(172,     47,       45,      4, yes,  no,   0, no) \
                                                         \
    SC(173,     48,       46,      1, yes,  no,   0, no) \
    SC(174,     48,       46,      2, yes,  no,   0, no) \
    SC(175,     48,       46,      3, yes,  no,   0, no) \
    SC(176,     48,       46,      4, yes,  no,   0, no) \
                                                         \
    SC(177,     49,       47,      1, yes,  no,   0, no) \
    SC(178,     49,       47,      2, yes,  no,   0, no) \
    SC(179,     49,       47,      3, yes,  no,   0, no) \
    SC(180,     49,       47,      4, yes,  no,   0, no) \
                                                         \
    SC(181,     50,       48,      1, yes,  no,   0, no) \
    SC(182,     50,       48,      2, yes,  no,   0, no) \
    SC(183,     50,       48,      3, yes,  no,   0, no) \
    SC(184,     50,       48,      4, yes,  no,   0, no) \
                                                         \
    SC(185,     51,       49,      1, yes,  no,   0, no) \
    SC(186,     51,       49,      2, yes,  no,   0, no) \
    SC(187,     51,       49,      3, yes,  no,   0, no) \
    SC(188,     51,       49,      4, yes,  no,   0, no) \
                                                         \
    SC(189,     52,       50,      1, yes,  no,   0, no) \
    SC(190,     52,       50,      2, yes,  no,   0, no) \
    SC(191,     52,       50,      3, yes,  no,   0, no) \
    SC(192,     52,       50,      4, yes,  no,   0, no) \
                                                         \
    SC(193,     53,       51,      1, yes,  no,   0, no) \
    SC(194,     53,       51,      2, yes,  no,   0, no) \
    SC(195,     53,       51,      3, yes,  no,   0, no) \
    SC(196,     53,       51,      4, yes,  no,   0, no) \
                                                         \
    SC(197,     54,       52,      1, yes,  no,   0, no) \
    SC(198,     54,       52,      2, yes,  no,   0, no) \
    SC(199,     54,       52,      3, yes,  no,   0, no) \
    SC(200,     54,       52,      4, yes,  no,   0, no) \
                                                         \
    SC(201,     55,       53,      1, yes,  no,   0, no) \
    SC(202,     55,       53,      2, yes,  no,   0, no) \
    SC(203,     55,       53,      3, yes,  no,   0, no) \
    SC(204,     55,       53,      4, yes,  no,   0, no) \
                                                         \
    SC(205,     56,       54,      1, yes,  no,   0, no) \
    SC(206,     56,       54,      2, yes,  no,   0, no) \
    SC(207,     56,       54,      3, yes,  no,   0, no) \
    SC(208,     56,       54,      4, yes,  no,   0, no) \
                                                         \
    SC(209,     57,       55,      1, yes,  no,   0, no) \
    SC(210,     57,       55,      2, yes,  no,   0, no) \
    SC(211,     57,       55,      3, yes,  no,   0, no) \
    SC(212,     57,       55,      4, yes,  no,   0, no) \
                                                         \
    SC(213,     58,       56,      1, yes,  no,   0, no) \
    SC(214,     58,       56,      2, yes,  no,   0, no) \
    SC(215,     58,       56,      3, yes,  no,   0, no) \
    SC(216,     58,       56,      4, yes,  no,   0, no) \
                                                         \
    SC(217,     59,       57,      1, yes,  no,   0, no) \
    SC(218,     59,       57,      2, yes,  no,   0, no) \
    SC(219,     59,       57,      3, yes,  no,   0, no) \
    SC(220,     59,       57,      4, yes,  no,   0, no) \
                                                         \
    SC(221,     60,       58,      1, yes,  no,   0, no) \
    SC(222,     60,       58,      2, yes,  no,   0, no) \
    SC(223,     60,       58,      3, yes,  no,   0, no) \
    SC(224,     60,       58,      4, yes,  no,   0, no) \
                                                         \
    SC(225,     61,       59,      1, yes,  no,   0, no) \
    SC(226,     61,       59,      2, yes,  no,   0, no) \
    SC(227,     61,       59,      3, yes,  no,   0, no) \
    SC(228,     61,       59,      4, yes,  no,   0, no) \
                                                         \
    SC(229,     62,       60,      1, yes,  no,   0, no) \
    SC(230,     62,       60,      2, yes,  no,   0, no) \
    SC(231,     62,       60,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			1
#define NLBINS			29
#define NBINS			44
#define NSIZES			232
#define LG_CEIL_NSIZES		8
#define NPSIZES			191
#define LG_TINY_MAXCLASS	3
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 15) + (((size_t)3) << 13))
#define LG_LARGE_MINCLASS	16
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 62) + (((size_t)3) << 60))
#endif

#if (LG_SIZEOF_PTR == 3 && LG_TINY_MIN == 4 && LG_QUANTUM == 4 && LG_PAGE == 14)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      4,        4,      0,  no, yes,   1,  4) \
    SC(  1,      4,        4,      1,  no, yes,   1,  4) \
    SC(  2,      4,        4,      2,  no, yes,   3,  4) \
    SC(  3,      4,        4,      3,  no, yes,   1,  4) \
                                                         \
    SC(  4,      6,        4,      1,  no, yes,   5,  4) \
    SC(  5,      6,        4,      2,  no, yes,   3,  4) \
    SC(  6,      6,        4,      3,  no, yes,   7,  4) \
    SC(  7,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC(  8,      7,        5,      1,  no, yes,   5,  5) \
    SC(  9,      7,        5,      2,  no, yes,   3,  5) \
    SC( 10,      7,        5,      3,  no, yes,   7,  5) \
    SC( 11,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 12,      8,        6,      1,  no, yes,   5,  6) \
    SC( 13,      8,        6,      2,  no, yes,   3,  6) \
    SC( 14,      8,        6,      3,  no, yes,   7,  6) \
    SC( 15,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 16,      9,        7,      1,  no, yes,   5,  7) \
    SC( 17,      9,        7,      2,  no, yes,   3,  7) \
    SC( 18,      9,        7,      3,  no, yes,   7,  7) \
    SC( 19,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 20,     10,        8,      1,  no, yes,   5,  8) \
    SC( 21,     10,        8,      2,  no, yes,   3,  8) \
    SC( 22,     10,        8,      3,  no, yes,   7,  8) \
    SC( 23,     10,        8,      4,  no, yes,   1,  8) \
                                                         \
    SC( 24,     11,        9,      1,  no, yes,   5,  9) \
    SC( 25,     11,        9,      2,  no, yes,   3,  9) \
    SC( 26,     11,        9,      3,  no, yes,   7,  9) \
    SC( 27,     11,        9,      4,  no, yes,   1,  9) \
                                                         \
    SC( 28,     12,       10,      1,  no, yes,   5, no) \
    SC( 29,     12,       10,      2,  no, yes,   3, no) \
    SC( 30,     12,       10,      3,  no, yes,   7, no) \
    SC( 31,     12,       10,      4,  no, yes,   1, no) \
                                                         \
    SC( 32,     13,       11,      1,  no, yes,   5, no) \
    SC( 33,     13,       11,      2,  no, yes,   3, no) \
    SC( 34,     13,       11,      3,  no, yes,   7, no) \
    SC( 35,     13,       11,      4, yes, yes,   1, no) \
                                                         \
    SC( 36,     14,       12,      1,  no, yes,   5, no) \
    SC( 37,     14,       12,      2,  no, yes,   3, no) \
    SC( 38,     14,       12,      3,  no, yes,   7, no) \
    SC( 39,     14,       12,      4, yes, yes,   2, no) \
                                                         \
    SC( 40,     15,       13,      1,  no, yes,   5, no) \
    SC( 41,     15,       13,      2, yes, yes,   3, no) \
    SC( 42,     15,       13,      3,  no, yes,   7, no) \
    SC( 43,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 44,     16,       14,      1, yes,  no,   0, no) \
    SC( 45,     16,       14,      2, yes,  no,   0, no) \
    SC( 46,     16,       14,      3, yes,  no,   0, no) \
    SC( 47,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 48,     17,       15,      1, yes,  no,   0, no) \
    SC( 49,     17,       15,      2, yes,  no,   0, no) \
    SC( 50,     17,       15,      3, yes,  no,   0, no) \
    SC( 51,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 52,     18,       16,      1, yes,  no,   0, no) \
    SC( 53,     18,       16,      2, yes,  no,   0, no) \
    SC( 54,     18,       16,      3, yes,  no,   0, no) \
    SC( 55,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 56,     19,       17,      1, yes,  no,   0, no) \
    SC( 57,     19,       17,      2, yes,  no,   0, no) \
    SC( 58,     19,       17,      3, yes,  no,   0, no) \
    SC( 59,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 60,     20,       18,      1, yes,  no,   0, no) \
    SC( 61,     20,       18,      2, yes,  no,   0, no) \
    SC( 62,     20,       18,      3, yes,  no,   0, no) \
    SC( 63,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 64,     21,       19,      1, yes,  no,   0, no) \
    SC( 65,     21,       19,      2, yes,  no,   0, no) \
    SC( 66,     21,       19,      3, yes,  no,   0, no) \
    SC( 67,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 68,     22,       20,      1, yes,  no,   0, no) \
    SC( 69,     22,       20,      2, yes,  no,   0, no) \
    SC( 70,     22,       20,      3, yes,  no,   0, no) \
    SC( 71,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 72,     23,       21,      1, yes,  no,   0, no) \
    SC( 73,     23,       21,      2, yes,  no,   0, no) \
    SC( 74,     23,       21,      3, yes,  no,   0, no) \
    SC( 75,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 76,     24,       22,      1, yes,  no,   0, no) \
    SC( 77,     24,       22,      2, yes,  no,   0, no) \
    SC( 78,     24,       22,      3, yes,  no,   0, no) \
    SC( 79,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 80,     25,       23,      1, yes,  no,   0, no) \
    SC( 81,     25,       23,      2, yes,  no,   0, no) \
    SC( 82,     25,       23,      3, yes,  no,   0, no) \
    SC( 83,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 84,     26,       24,      1, yes,  no,   0, no) \
    SC( 85,     26,       24,      2, yes,  no,   0, no) \
    SC( 86,     26,       24,      3, yes,  no,   0, no) \
    SC( 87,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 88,     27,       25,      1, yes,  no,   0, no) \
    SC( 89,     27,       25,      2, yes,  no,   0, no) \
    SC( 90,     27,       25,      3, yes,  no,   0, no) \
    SC( 91,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 92,     28,       26,      1, yes,  no,   0, no) \
    SC( 93,     28,       26,      2, yes,  no,   0, no) \
    SC( 94,     28,       26,      3, yes,  no,   0, no) \
    SC( 95,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC( 96,     29,       27,      1, yes,  no,   0, no) \
    SC( 97,     29,       27,      2, yes,  no,   0, no) \
    SC( 98,     29,       27,      3, yes,  no,   0, no) \
    SC( 99,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(100,     30,       28,      1, yes,  no,   0, no) \
    SC(101,     30,       28,      2, yes,  no,   0, no) \
    SC(102,     30,       28,      3, yes,  no,   0, no) \
    SC(103,     30,       28,      4, yes,  no,   0, no) \
                                                         \
    SC(104,     31,       29,      1, yes,  no,   0, no) \
    SC(105,     31,       29,      2, yes,  no,   0, no) \
    SC(106,     31,       29,      3, yes,  no,   0, no) \
    SC(107,     31,       29,      4, yes,  no,   0, no) \
                                                         \
    SC(108,     32,       30,      1, yes,  no,   0, no) \
    SC(109,     32,       30,      2, yes,  no,   0, no) \
    SC(110,     32,       30,      3, yes,  no,   0, no) \
    SC(111,     32,       30,      4, yes,  no,   0, no) \
                                                         \
    SC(112,     33,       31,      1, yes,  no,   0, no) \
    SC(113,     33,       31,      2, yes,  no,   0, no) \
    SC(114,     33,       31,      3, yes,  no,   0, no) \
    SC(115,     33,       31,      4, yes,  no,   0, no) \
                                                         \
    SC(116,     34,       32,      1, yes,  no,   0, no) \
    SC(117,     34,       32,      2, yes,  no,   0, no) \
    SC(118,     34,       32,      3, yes,  no,   0, no) \
    SC(119,     34,       32,      4, yes,  no,   0, no) \
                                                         \
    SC(120,     35,       33,      1, yes,  no,   0, no) \
    SC(121,     35,       33,      2, yes,  no,   0, no) \
    SC(122,     35,       33,      3, yes,  no,   0, no) \
    SC(123,     35,       33,      4, yes,  no,   0, no) \
                                                         \
    SC(124,     36,       34,      1, yes,  no,   0, no) \
    SC(125,     36,       34,      2, yes,  no,   0, no) \
    SC(126,     36,       34,      3, yes,  no,   0, no) \
    SC(127,     36,       34,      4, yes,  no,   0, no) \
                                                         \
    SC(128,     37,       35,      1, yes,  no,   0, no) \
    SC(129,     37,       35,      2, yes,  no,   0, no) \
    SC(130,     37,       35,      3, yes,  no,   0, no) \
    SC(131,     37,       35,      4, yes,  no,   0, no) \
                                                         \
    SC(132,     38,       36,      1, yes,  no,   0, no) \
    SC(133,     38,       36,      2, yes,  no,   0, no) \
    SC(134,     38,       36,      3, yes,  no,   0, no) \
    SC(135,     38,       36,      4, yes,  no,   0, no) \
                                                         \
    SC(136,     39,       37,      1, yes,  no,   0, no) \
    SC(137,     39,       37,      2, yes,  no,   0, no) \
    SC(138,     39,       37,      3, yes,  no,   0, no) \
    SC(139,     39,       37,      4, yes,  no,   0, no) \
                                                         \
    SC(140,     40,       38,      1, yes,  no,   0, no) \
    SC(141,     40,       38,      2, yes,  no,   0, no) \
    SC(142,     40,       38,      3, yes,  no,   0, no) \
    SC(143,     40,       38,      4, yes,  no,   0, no) \
                                                         \
    SC(144,     41,       39,      1, yes,  no,   0, no) \
    SC(145,     41,       39,      2, yes,  no,   0, no) \
    SC(146,     41,       39,      3, yes,  no,   0, no) \
    SC(147,     41,       39,      4, yes,  no,   0, no) \
                                                         \
    SC(148,     42,       40,      1, yes,  no,   0, no) \
    SC(149,     42,       40,      2, yes,  no,   0, no) \
    SC(150,     42,       40,      3, yes,  no,   0, no) \
    SC(151,     42,       40,      4, yes,  no,   0, no) \
                                                         \
    SC(152,     43,       41,      1, yes,  no,   0, no) \
    SC(153,     43,       41,      2, yes,  no,   0, no) \
    SC(154,     43,       41,      3, yes,  no,   0, no) \
    SC(155,     43,       41,      4, yes,  no,   0, no) \
                                                         \
    SC(156,     44,       42,      1, yes,  no,   0, no) \
    SC(157,     44,       42,      2, yes,  no,   0, no) \
    SC(158,     44,       42,      3, yes,  no,   0, no) \
    SC(159,     44,       42,      4, yes,  no,   0, no) \
                                                         \
    SC(160,     45,       43,      1, yes,  no,   0, no) \
    SC(161,     45,       43,      2, yes,  no,   0, no) \
    SC(162,     45,       43,      3, yes,  no,   0, no) \
    SC(163,     45,       43,      4, yes,  no,   0, no) \
                                                         \
    SC(164,     46,       44,      1, yes,  no,   0, no) \
    SC(165,     46,       44,      2, yes,  no,   0, no) \
    SC(166,     46,       44,      3, yes,  no,   0, no) \
    SC(167,     46,       44,      4, yes,  no,   0, no) \
                                                         \
    SC(168,     47,       45,      1, yes,  no,   0, no) \
    SC(169,     47,       45,      2, yes,  no,   0, no) \
    SC(170,     47,       45,      3, yes,  no,   0, no) \
    SC(171,     47,       45,      4, yes,  no,   0, no) \
                                                         \
    SC(172,     48,       46,      1, yes,  no,   0, no) \
    SC(173,     48,       46,      2, yes,  no,   0, no) \
    SC(174,     48,       46,      3, yes,  no,   0, no) \
    SC(175,     48,       46,      4, yes,  no,   0, no) \
                                                         \
    SC(176,     49,       47,      1, yes,  no,   0, no) \
    SC(177,     49,       47,      2, yes,  no,   0, no) \
    SC(178,     49,       47,      3, yes,  no,   0, no) \
    SC(179,     49,       47,      4, yes,  no,   0, no) \
                                                         \
    SC(180,     50,       48,      1, yes,  no,   0, no) \
    SC(181,     50,       48,      2, yes,  no,   0, no) \
    SC(182,     50,       48,      3, yes,  no,   0, no) \
    SC(183,     50,       48,      4, yes,  no,   0, no) \
                                                         \
    SC(184,     51,       49,      1, yes,  no,   0, no) \
    SC(185,     51,       49,      2, yes,  no,   0, no) \
    SC(186,     51,       49,      3, yes,  no,   0, no) \
    SC(187,     51,       49,      4, yes,  no,   0, no) \
                                                         \
    SC(188,     52,       50,      1, yes,  no,   0, no) \
    SC(189,     52,       50,      2, yes,  no,   0, no) \
    SC(190,     52,       50,      3, yes,  no,   0, no) \
    SC(191,     52,       50,      4, yes,  no,   0, no) \
                                                         \
    SC(192,     53,       51,      1, yes,  no,   0, no) \
    SC(193,     53,       51,      2, yes,  no,   0, no) \
    SC(194,     53,       51,      3, yes,  no,   0, no) \
    SC(195,     53,       51,      4, yes,  no,   0, no) \
                                                         \
    SC(196,     54,       52,      1, yes,  no,   0, no) \
    SC(197,     54,       52,      2, yes,  no,   0, no) \
    SC(198,     54,       52,      3, yes,  no,   0, no) \
    SC(199,     54,       52,      4, yes,  no,   0, no) \
                                                         \
    SC(200,     55,       53,      1, yes,  no,   0, no) \
    SC(201,     55,       53,      2, yes,  no,   0, no) \
    SC(202,     55,       53,      3, yes,  no,   0, no) \
    SC(203,     55,       53,      4, yes,  no,   0, no) \
                                                         \
    SC(204,     56,       54,      1, yes,  no,   0, no) \
    SC(205,     56,       54,      2, yes,  no,   0, no) \
    SC(206,     56,       54,      3, yes,  no,   0, no) \
    SC(207,     56,       54,      4, yes,  no,   0, no) \
                                                         \
    SC(208,     57,       55,      1, yes,  no,   0, no) \
    SC(209,     57,       55,      2, yes,  no,   0, no) \
    SC(210,     57,       55,      3, yes,  no,   0, no) \
    SC(211,     57,       55,      4, yes,  no,   0, no) \
                                                         \
    SC(212,     58,       56,      1, yes,  no,   0, no) \
    SC(213,     58,       56,      2, yes,  no,   0, no) \
    SC(214,     58,       56,      3, yes,  no,   0, no) \
    SC(215,     58,       56,      4, yes,  no,   0, no) \
                                                         \
    SC(216,     59,       57,      1, yes,  no,   0, no) \
    SC(217,     59,       57,      2, yes,  no,   0, no) \
    SC(218,     59,       57,      3, yes,  no,   0, no) \
    SC(219,     59,       57,      4, yes,  no,   0, no) \
                                                         \
    SC(220,     60,       58,      1, yes,  no,   0, no) \
    SC(221,     60,       58,      2, yes,  no,   0, no) \
    SC(222,     60,       58,      3, yes,  no,   0, no) \
    SC(223,     60,       58,      4, yes,  no,   0, no) \
                                                         \
    SC(224,     61,       59,      1, yes,  no,   0, no) \
    SC(225,     61,       59,      2, yes,  no,   0, no) \
    SC(226,     61,       59,      3, yes,  no,   0, no) \
    SC(227,     61,       59,      4, yes,  no,   0, no) \
                                                         \
    SC(228,     62,       60,      1, yes,  no,   0, no) \
    SC(229,     62,       60,      2, yes,  no,   0, no) \
    SC(230,     62,       60,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			0
#define NLBINS			28
#define NBINS			43
#define NSIZES			231
#define LG_CEIL_NSIZES		8
#define NPSIZES			191
#define LG_TINY_MAXCLASS	"NA"
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 15) + (((size_t)3) << 13))
#define LG_LARGE_MINCLASS	16
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 62) + (((size_t)3) << 60))
#endif

#if (LG_SIZEOF_PTR == 2 && LG_TINY_MIN == 3 && LG_QUANTUM == 3 && LG_PAGE == 11)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      3,        3,      0,  no, yes,   1,  3) \
    SC(  1,      3,        3,      1,  no, yes,   1,  3) \
    SC(  2,      3,        3,      2,  no, yes,   3,  3) \
    SC(  3,      3,        3,      3,  no, yes,   1,  3) \
                                                         \
    SC(  4,      5,        3,      1,  no, yes,   5,  3) \
    SC(  5,      5,        3,      2,  no, yes,   3,  3) \
    SC(  6,      5,        3,      3,  no, yes,   7,  3) \
    SC(  7,      5,        3,      4,  no, yes,   1,  3) \
                                                         \
    SC(  8,      6,        4,      1,  no, yes,   5,  4) \
    SC(  9,      6,        4,      2,  no, yes,   3,  4) \
    SC( 10,      6,        4,      3,  no, yes,   7,  4) \
    SC( 11,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC( 12,      7,        5,      1,  no, yes,   5,  5) \
    SC( 13,      7,        5,      2,  no, yes,   3,  5) \
    SC( 14,      7,        5,      3,  no, yes,   7,  5) \
    SC( 15,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 16,      8,        6,      1,  no, yes,   5,  6) \
    SC( 17,      8,        6,      2,  no, yes,   3,  6) \
    SC( 18,      8,        6,      3,  no, yes,   7,  6) \
    SC( 19,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 20,      9,        7,      1,  no, yes,   5,  7) \
    SC( 21,      9,        7,      2,  no, yes,   3,  7) \
    SC( 22,      9,        7,      3,  no, yes,   7,  7) \
    SC( 23,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 24,     10,        8,      1,  no, yes,   5,  8) \
    SC( 25,     10,        8,      2,  no, yes,   3,  8) \
    SC( 26,     10,        8,      3,  no, yes,   7,  8) \
    SC( 27,     10,        8,      4, yes, yes,   1,  8) \
                                                         \
    SC( 28,     11,        9,      1,  no, yes,   5,  9) \
    SC( 29,     11,        9,      2,  no, yes,   3,  9) \
    SC( 30,     11,        9,      3,  no, yes,   7,  9) \
    SC( 31,     11,        9,      4, yes, yes,   2,  9) \
                                                         \
    SC( 32,     12,       10,      1,  no, yes,   5, no) \
    SC( 33,     12,       10,      2, yes, yes,   3, no) \
    SC( 34,     12,       10,      3,  no, yes,   7, no) \
    SC( 35,     12,       10,      4, yes,  no,   0, no) \
                                                         \
    SC( 36,     13,       11,      1, yes,  no,   0, no) \
    SC( 37,     13,       11,      2, yes,  no,   0, no) \
    SC( 38,     13,       11,      3, yes,  no,   0, no) \
    SC( 39,     13,       11,      4, yes,  no,   0, no) \
                                                         \
    SC( 40,     14,       12,      1, yes,  no,   0, no) \
    SC( 41,     14,       12,      2, yes,  no,   0, no) \
    SC( 42,     14,       12,      3, yes,  no,   0, no) \
    SC( 43,     14,       12,      4, yes,  no,   0, no) \
                                                         \
    SC( 44,     15,       13,      1, yes,  no,   0, no) \
    SC( 45,     15,       13,      2, yes,  no,   0, no) \
    SC( 46,     15,       13,      3, yes,  no,   0, no) \
    SC( 47,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 48,     16,       14,      1, yes,  no,   0, no) \
    SC( 49,     16,       14,      2, yes,  no,   0, no) \
    SC( 50,     16,       14,      3, yes,  no,   0, no) \
    SC( 51,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 52,     17,       15,      1, yes,  no,   0, no) \
    SC( 53,     17,       15,      2, yes,  no,   0, no) \
    SC( 54,     17,       15,      3, yes,  no,   0, no) \
    SC( 55,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 56,     18,       16,      1, yes,  no,   0, no) \
    SC( 57,     18,       16,      2, yes,  no,   0, no) \
    SC( 58,     18,       16,      3, yes,  no,   0, no) \
    SC( 59,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 60,     19,       17,      1, yes,  no,   0, no) \
    SC( 61,     19,       17,      2, yes,  no,   0, no) \
    SC( 62,     19,       17,      3, yes,  no,   0, no) \
    SC( 63,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 64,     20,       18,      1, yes,  no,   0, no) \
    SC( 65,     20,       18,      2, yes,  no,   0, no) \
    SC( 66,     20,       18,      3, yes,  no,   0, no) \
    SC( 67,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 68,     21,       19,      1, yes,  no,   0, no) \
    SC( 69,     21,       19,      2, yes,  no,   0, no) \
    SC( 70,     21,       19,      3, yes,  no,   0, no) \
    SC( 71,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 72,     22,       20,      1, yes,  no,   0, no) \
    SC( 73,     22,       20,      2, yes,  no,   0, no) \
    SC( 74,     22,       20,      3, yes,  no,   0, no) \
    SC( 75,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 76,     23,       21,      1, yes,  no,   0, no) \
    SC( 77,     23,       21,      2, yes,  no,   0, no) \
    SC( 78,     23,       21,      3, yes,  no,   0, no) \
    SC( 79,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 80,     24,       22,      1, yes,  no,   0, no) \
    SC( 81,     24,       22,      2, yes,  no,   0, no) \
    SC( 82,     24,       22,      3, yes,  no,   0, no) \
    SC( 83,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 84,     25,       23,      1, yes,  no,   0, no) \
    SC( 85,     25,       23,      2, yes,  no,   0, no) \
    SC( 86,     25,       23,      3, yes,  no,   0, no) \
    SC( 87,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 88,     26,       24,      1, yes,  no,   0, no) \
    SC( 89,     26,       24,      2, yes,  no,   0, no) \
    SC( 90,     26,       24,      3, yes,  no,   0, no) \
    SC( 91,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 92,     27,       25,      1, yes,  no,   0, no) \
    SC( 93,     27,       25,      2, yes,  no,   0, no) \
    SC( 94,     27,       25,      3, yes,  no,   0, no) \
    SC( 95,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 96,     28,       26,      1, yes,  no,   0, no) \
    SC( 97,     28,       26,      2, yes,  no,   0, no) \
    SC( 98,     28,       26,      3, yes,  no,   0, no) \
    SC( 99,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC(100,     29,       27,      1, yes,  no,   0, no) \
    SC(101,     29,       27,      2, yes,  no,   0, no) \
    SC(102,     29,       27,      3, yes,  no,   0, no) \
    SC(103,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(104,     30,       28,      1, yes,  no,   0, no) \
    SC(105,     30,       28,      2, yes,  no,   0, no) \
    SC(106,     30,       28,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			0
#define NLBINS			32
#define NBINS			35
#define NSIZES			107
#define LG_CEIL_NSIZES		7
#define NPSIZES			75
#define LG_TINY_MAXCLASS	"NA"
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 12) + (((size_t)3) << 10))
#define LG_LARGE_MINCLASS	13
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 30) + (((size_t)3) << 28))
#endif

#if (LG_SIZEOF_PTR == 3 && LG_TINY_MIN == 3 && LG_QUANTUM == 3 && LG_PAGE == 11)
#define SIZE_CLASSES \
  /* index, lg_grp, lg_delta, ndelta, psz, bin, pgs, lg_delta_lookup */ \
    SC(  0,      3,        3,      0,  no, yes,   1,  3) \
    SC(  1,      3,        3,      1,  no, yes,   1,  3) \
    SC(  2,      3,        3,      2,  no, yes,   3,  3) \
    SC(  3,      3,        3,      3,  no, yes,   1,  3) \
                                                         \
    SC(  4,      5,        3,      1,  no, yes,   5,  3) \
    SC(  5,      5,        3,      2,  no, yes,   3,  3) \
    SC(  6,      5,        3,      3,  no, yes,   7,  3) \
    SC(  7,      5,        3,      4,  no, yes,   1,  3) \
                                                         \
    SC(  8,      6,        4,      1,  no, yes,   5,  4) \
    SC(  9,      6,        4,      2,  no, yes,   3,  4) \
    SC( 10,      6,        4,      3,  no, yes,   7,  4) \
    SC( 11,      6,        4,      4,  no, yes,   1,  4) \
                                                         \
    SC( 12,      7,        5,      1,  no, yes,   5,  5) \
    SC( 13,      7,        5,      2,  no, yes,   3,  5) \
    SC( 14,      7,        5,      3,  no, yes,   7,  5) \
    SC( 15,      7,        5,      4,  no, yes,   1,  5) \
                                                         \
    SC( 16,      8,        6,      1,  no, yes,   5,  6) \
    SC( 17,      8,        6,      2,  no, yes,   3,  6) \
    SC( 18,      8,        6,      3,  no, yes,   7,  6) \
    SC( 19,      8,        6,      4,  no, yes,   1,  6) \
                                                         \
    SC( 20,      9,        7,      1,  no, yes,   5,  7) \
    SC( 21,      9,        7,      2,  no, yes,   3,  7) \
    SC( 22,      9,        7,      3,  no, yes,   7,  7) \
    SC( 23,      9,        7,      4,  no, yes,   1,  7) \
                                                         \
    SC( 24,     10,        8,      1,  no, yes,   5,  8) \
    SC( 25,     10,        8,      2,  no, yes,   3,  8) \
    SC( 26,     10,        8,      3,  no, yes,   7,  8) \
    SC( 27,     10,        8,      4, yes, yes,   1,  8) \
                                                         \
    SC( 28,     11,        9,      1,  no, yes,   5,  9) \
    SC( 29,     11,        9,      2,  no, yes,   3,  9) \
    SC( 30,     11,        9,      3,  no, yes,   7,  9) \
    SC( 31,     11,        9,      4, yes, yes,   2,  9) \
                                                         \
    SC( 32,     12,       10,      1,  no, yes,   5, no) \
    SC( 33,     12,       10,      2, yes, yes,   3, no) \
    SC( 34,     12,       10,      3,  no, yes,   7, no) \
    SC( 35,     12,       10,      4, yes,  no,   0, no) \
                                                         \
    SC( 36,     13,       11,      1, yes,  no,   0, no) \
    SC( 37,     13,       11,      2, yes,  no,   0, no) \
    SC( 38,     13,       11,      3, yes,  no,   0, no) \
    SC( 39,     13,       11,      4, yes,  no,   0, no) \
                                                         \
    SC( 40,     14,       12,      1, yes,  no,   0, no) \
    SC( 41,     14,       12,      2, yes,  no,   0, no) \
    SC( 42,     14,       12,      3, yes,  no,   0, no) \
    SC( 43,     14,       12,      4, yes,  no,   0, no) \
                                                         \
    SC( 44,     15,       13,      1, yes,  no,   0, no) \
    SC( 45,     15,       13,      2, yes,  no,   0, no) \
    SC( 46,     15,       13,      3, yes,  no,   0, no) \
    SC( 47,     15,       13,      4, yes,  no,   0, no) \
                                                         \
    SC( 48,     16,       14,      1, yes,  no,   0, no) \
    SC( 49,     16,       14,      2, yes,  no,   0, no) \
    SC( 50,     16,       14,      3, yes,  no,   0, no) \
    SC( 51,     16,       14,      4, yes,  no,   0, no) \
                                                         \
    SC( 52,     17,       15,      1, yes,  no,   0, no) \
    SC( 53,     17,       15,      2, yes,  no,   0, no) \
    SC( 54,     17,       15,      3, yes,  no,   0, no) \
    SC( 55,     17,       15,      4, yes,  no,   0, no) \
                                                         \
    SC( 56,     18,       16,      1, yes,  no,   0, no) \
    SC( 57,     18,       16,      2, yes,  no,   0, no) \
    SC( 58,     18,       16,      3, yes,  no,   0, no) \
    SC( 59,     18,       16,      4, yes,  no,   0, no) \
                                                         \
    SC( 60,     19,       17,      1, yes,  no,   0, no) \
    SC( 61,     19,       17,      2, yes,  no,   0, no) \
    SC( 62,     19,       17,      3, yes,  no,   0, no) \
    SC( 63,     19,       17,      4, yes,  no,   0, no) \
                                                         \
    SC( 64,     20,       18,      1, yes,  no,   0, no) \
    SC( 65,     20,       18,      2, yes,  no,   0, no) \
    SC( 66,     20,       18,      3, yes,  no,   0, no) \
    SC( 67,     20,       18,      4, yes,  no,   0, no) \
                                                         \
    SC( 68,     21,       19,      1, yes,  no,   0, no) \
    SC( 69,     21,       19,      2, yes,  no,   0, no) \
    SC( 70,     21,       19,      3, yes,  no,   0, no) \
    SC( 71,     21,       19,      4, yes,  no,   0, no) \
                                                         \
    SC( 72,     22,       20,      1, yes,  no,   0, no) \
    SC( 73,     22,       20,      2, yes,  no,   0, no) \
    SC( 74,     22,       20,      3, yes,  no,   0, no) \
    SC( 75,     22,       20,      4, yes,  no,   0, no) \
                                                         \
    SC( 76,     23,       21,      1, yes,  no,   0, no) \
    SC( 77,     23,       21,      2, yes,  no,   0, no) \
    SC( 78,     23,       21,      3, yes,  no,   0, no) \
    SC( 79,     23,       21,      4, yes,  no,   0, no) \
                                                         \
    SC( 80,     24,       22,      1, yes,  no,   0, no) \
    SC( 81,     24,       22,      2, yes,  no,   0, no) \
    SC( 82,     24,       22,      3, yes,  no,   0, no) \
    SC( 83,     24,       22,      4, yes,  no,   0, no) \
                                                         \
    SC( 84,     25,       23,      1, yes,  no,   0, no) \
    SC( 85,     25,       23,      2, yes,  no,   0, no) \
    SC( 86,     25,       23,      3, yes,  no,   0, no) \
    SC( 87,     25,       23,      4, yes,  no,   0, no) \
                                                         \
    SC( 88,     26,       24,      1, yes,  no,   0, no) \
    SC( 89,     26,       24,      2, yes,  no,   0, no) \
    SC( 90,     26,       24,      3, yes,  no,   0, no) \
    SC( 91,     26,       24,      4, yes,  no,   0, no) \
                                                         \
    SC( 92,     27,       25,      1, yes,  no,   0, no) \
    SC( 93,     27,       25,      2, yes,  no,   0, no) \
    SC( 94,     27,       25,      3, yes,  no,   0, no) \
    SC( 95,     27,       25,      4, yes,  no,   0, no) \
                                                         \
    SC( 96,     28,       26,      1, yes,  no,   0, no) \
    SC( 97,     28,       26,      2, yes,  no,   0, no) \
    SC( 98,     28,       26,      3, yes,  no,   0, no) \
    SC( 99,     28,       26,      4, yes,  no,   0, no) \
                                                         \
    SC(100,     29,       27,      1, yes,  no,   0, no) \
    SC(101,     29,       27,      2, yes,  no,   0, no) \
    SC(102,     29,       27,      3, yes,  no,   0, no) \
    SC(103,     29,       27,      4, yes,  no,   0, no) \
                                                         \
    SC(104,     30,       28,      1, yes,  no,   0, no) \
    SC(105,     30,       28,      2, yes,  no,   0, no) \
    SC(106,     30,       28,      3, yes,  no,   0, no) \
    SC(107,     30,       28,      4, yes,  no,   0, no) \
                                                         \
    SC(108,     31,       29,      1, yes,  no,   0, no) \
    SC(109,     31,       29,      2, yes,  no,   0, no) \
    SC(110,     31,       29,      3, yes,  no,   0, no) \
    SC(111,     31,       29,      4, yes,  no,   0, no) \
                                                         \
    SC(112,     32,       30,      1, yes,  no,   0, no) \
    SC(113,     32,       30,      2, yes,  no,   0, no) \
    SC(114,     32,       30,      3, yes,  no,   0, no) \
    SC(115,     32,       30,      4, yes,  no,   0, no) \
                                                         \
    SC(116,     33,       31,      1, yes,  no,   0, no) \
    SC(117,     33,       31,      2, yes,  no,   0, no) \
    SC(118,     33,       31,      3, yes,  no,   0, no) \
    SC(119,     33,       31,      4, yes,  no,   0, no) \
                                                         \
    SC(120,     34,       32,      1, yes,  no,   0, no) \
    SC(121,     34,       32,      2, yes,  no,   0, no) \
    SC(122,     34,       32,      3, yes,  no,   0, no) \
    SC(123,     34,       32,      4, yes,  no,   0, no) \
                                                         \
    SC(124,     35,       33,      1, yes,  no,   0, no) \
    SC(125,     35,       33,      2, yes,  no,   0, no) \
    SC(126,     35,       33,      3, yes,  no,   0, no) \
    SC(127,     35,       33,      4, yes,  no,   0, no) \
                                                         \
    SC(128,     36,       34,      1, yes,  no,   0, no) \
    SC(129,     36,       34,      2, yes,  no,   0, no) \
    SC(130,     36,       34,      3, yes,  no,   0, no) \
    SC(131,     36,       34,      4, yes,  no,   0, no) \
                                                         \
    SC(132,     37,       35,      1, yes,  no,   0, no) \
    SC(133,     37,       35,      2, yes,  no,   0, no) \
    SC(134,     37,       35,      3, yes,  no,   0, no) \
    SC(135,     37,       35,      4, yes,  no,   0, no) \
                                                         \
    SC(136,     38,       36,      1, yes,  no,   0, no) \
    SC(137,     38,       36,      2, yes,  no,   0, no) \
    SC(138,     38,       36,      3, yes,  no,   0, no) \
    SC(139,     38,       36,      4, yes,  no,   0, no) \
                                                         \
    SC(140,     39,       37,      1, yes,  no,   0, no) \
    SC(141,     39,       37,      2, yes,  no,   0, no) \
    SC(142,     39,       37,      3, yes,  no,   0, no) \
    SC(143,     39,       37,      4, yes,  no,   0, no) \
                                                         \
    SC(144,     40,       38,      1, yes,  no,   0, no) \
    SC(145,     40,       38,      2, yes,  no,   0, no) \
    SC(146,     40,       38,      3, yes,  no,   0, no) \
    SC(147,     40,       38,      4, yes,  no,   0, no) \
                                                         \
    SC(148,     41,       39,      1, yes,  no,   0, no) \
    SC(149,     41,       39,      2, yes,  no,   0, no) \
    SC(150,     41,       39,      3, yes,  no,   0, no) \
    SC(151,     41,       39,      4, yes,  no,   0, no) \
                                                         \
    SC(152,     42,       40,      1, yes,  no,   0, no) \
    SC(153,     42,       40,      2, yes,  no,   0, no) \
    SC(154,     42,       40,      3, yes,  no,   0, no) \
    SC(155,     42,       40,      4, yes,  no,   0, no) \
                                                         \
    SC(156,     43,       41,      1, yes,  no,   0, no) \
    SC(157,     43,       41,      2, yes,  no,   0, no) \
    SC(158,     43,       41,      3, yes,  no,   0, no) \
    SC(159,     43,       41,      4, yes,  no,   0, no) \
                                                         \
    SC(160,     44,       42,      1, yes,  no,   0, no) \
    SC(161,     44,       42,      2, yes,  no,   0, no) \
    SC(162,     44,       42,      3, yes,  no,   0, no) \
    SC(163,     44,       42,      4, yes,  no,   0, no) \
                                                         \
    SC(164,     45,       43,      1, yes,  no,   0, no) \
    SC(165,     45,       43,      2, yes,  no,   0, no) \
    SC(166,     45,       43,      3, yes,  no,   0, no) \
    SC(167,     45,       43,      4, yes,  no,   0, no) \
                                                         \
    SC(168,     46,       44,      1, yes,  no,   0, no) \
    SC(169,     46,       44,      2, yes,  no,   0, no) \
    SC(170,     46,       44,      3, yes,  no,   0, no) \
    SC(171,     46,       44,      4, yes,  no,   0, no) \
                                                         \
    SC(172,     47,       45,      1, yes,  no,   0, no) \
    SC(173,     47,       45,      2, yes,  no,   0, no) \
    SC(174,     47,       45,      3, yes,  no,   0, no) \
    SC(175,     47,       45,      4, yes,  no,   0, no) \
                                                         \
    SC(176,     48,       46,      1, yes,  no,   0, no) \
    SC(177,     48,       46,      2, yes,  no,   0, no) \
    SC(178,     48,       46,      3, yes,  no,   0, no) \
    SC(179,     48,       46,      4, yes,  no,   0, no) \
                                                         \
    SC(180,     49,       47,      1, yes,  no,   0, no) \
    SC(181,     49,       47,      2, yes,  no,   0, no) \
    SC(182,     49,       47,      3, yes,  no,   0, no) \
    SC(183,     49,       47,      4, yes,  no,   0, no) \
                                                         \
    SC(184,     50,       48,      1, yes,  no,   0, no) \
    SC(185,     50,       48,      2, yes,  no,   0, no) \
    SC(186,     50,       48,      3, yes,  no,   0, no) \
    SC(187,     50,       48,      4, yes,  no,   0, no) \
                                                         \
    SC(188,     51,       49,      1, yes,  no,   0, no) \
    SC(189,     51,       49,      2, yes,  no,   0, no) \
    SC(190,     51,       49,      3, yes,  no,   0, no) \
    SC(191,     51,       49,      4, yes,  no,   0, no) \
                                                         \
    SC(192,     52,       50,      1, yes,  no,   0, no) \
    SC(193,     52,       50,      2, yes,  no,   0, no) \
    SC(194,     52,       50,      3, yes,  no,   0, no) \
    SC(195,     52,       50,      4, yes,  no,   0, no) \
                                                         \
    SC(196,     53,       51,      1, yes,  no,   0, no) \
    SC(197,     53,       51,      2, yes,  no,   0, no) \
    SC(198,     53,       51,      3, yes,  no,   0, no) \
    SC(199,     53,       51,      4, yes,  no,   0, no) \
                                                         \
    SC(200,     54,       52,      1, yes,  no,   0, no) \
    SC(201,     54,       52,      2, yes,  no,   0, no) \
    SC(202,     54,       52,      3, yes,  no,   0, no) \
    SC(203,     54,       52,      4, yes,  no,   0, no) \
                                                         \
    SC(204,     55,       53,      1, yes,  no,   0, no) \
    SC(205,     55,       53,      2, yes,  no,   0, no) \
    SC(206,     55,       53,      3, yes,  no,   0, no) \
    SC(207,     55,       53,      4, yes,  no,   0, no) \
                                                         \
    SC(208,     56,       54,      1, yes,  no,   0, no) \
    SC(209,     56,       54,      2, yes,  no,   0, no) \
    SC(210,     56,       54,      3, yes,  no,   0, no) \
    SC(211,     56,       54,      4, yes,  no,   0, no) \
                                                         \
    SC(212,     57,       55,      1, yes,  no,   0, no) \
    SC(213,     57,       55,      2, yes,  no,   0, no) \
    SC(214,     57,       55,      3, yes,  no,   0, no) \
    SC(215,     57,       55,      4, yes,  no,   0, no) \
                                                         \
    SC(216,     58,       56,      1, yes,  no,   0, no) \
    SC(217,     58,       56,      2, yes,  no,   0, no) \
    SC(218,     58,       56,      3, yes,  no,   0, no) \
    SC(219,     58,       56,      4, yes,  no,   0, no) \
                                                         \
    SC(220,     59,       57,      1, yes,  no,   0, no) \
    SC(221,     59,       57,      2, yes,  no,   0, no) \
    SC(222,     59,       57,      3, yes,  no,   0, no) \
    SC(223,     59,       57,      4, yes,  no,   0, no) \
                                                         \
    SC(224,     60,       58,      1, yes,  no,   0, no) \
    SC(225,     60,       58,      2, yes,  no,   0, no) \
    SC(226,     60,       58,      3, yes,  no,   0, no) \
    SC(227,     60,       58,      4, yes,  no,   0, no) \
                                                         \
    SC(228,     61,       59,      1, yes,  no,   0, no) \
    SC(229,     61,       59,      2, yes,  no,   0, no) \
    SC(230,     61,       59,      3, yes,  no,   0, no) \
    SC(231,     61,       59,      4, yes,  no,   0, no) \
                                                         \
    SC(232,     62,       60,      1, yes,  no,   0, no) \
    SC(233,     62,       60,      2, yes,  no,   0, no) \
    SC(234,     62,       60,      3, yes,  no,   0, no) \

#define SIZE_CLASSES_DEFINED
#define NTBINS			0
#define NLBINS			32
#define NBINS			35
#define NSIZES			235
#define LG_CEIL_NSIZES		8
#define NPSIZES			203
#define LG_TINY_MAXCLASS	"NA"
#define LOOKUP_MAXCLASS		((((size_t)1) << 11) + (((size_t)4) << 9))
#define SMALL_MAXCLASS		((((size_t)1) << 12) + (((size_t)3) << 10))
#define LG_LARGE_MINCLASS	13
#define LARGE_MINCLASS		(ZU(1) << LG_LARGE_MINCLASS)
#define LARGE_MAXCLASS		((((size_t)1) << 62) + (((size_t)3) << 60))
#endif

#ifndef SIZE_CLASSES_DEFINED
#  error "No size class definitions match configuration"
#endif
#undef SIZE_CLASSES_DEFINED
/*
 * The size2index_tab lookup table uses uint8_t to encode each bin index, so we
 * cannot support more than 256 small size classes.
 */
#if (NBINS > 256)
#  error "Too many small size classes"
#endif

#endif /* JEMALLOC_INTERNAL_SIZE_CLASSES_H */
