/*	$NetBSD: run-ssl_init.c,v 1.4 2024/08/18 20:47:27 christos Exp $	*/

/* AUTOGENERATED FILE. DO NOT EDIT. */

//=======Test Runner Used To Run Each Test Below=====
#define RUN_TEST(TestFunc, TestLineNum) \
{ \
  Unity.CurrentTestName = #TestFunc; \
  Unity.CurrentTestLineNumber = TestLineNum; \
  Unity.NumberOfTests++; \
  if (TEST_PROTECT()) \
  { \
      setUp(); \
      TestFunc(); \
  } \
  if (TEST_PROTECT() && !TEST_IS_IGNORED) \
  { \
    tearDown(); \
  } \
  UnityConcludeTest(); \
}

//=======Automagically Detected Files To Include=====
#include "unity.h"
#include <setjmp.h>
#include <stdio.h>
#include "config.h"
#include "ntp.h"

//=======External Functions This Runner Calls=====
extern void setUp(void);
extern void tearDown(void);
extern void test_MD5KeyTypeWithoutDigestLength(void);
extern void test_MD5KeyTypeWithDigestLength(void);
extern void test_SHA1KeyTypeWithDigestLength(void);
extern void test_CMACKeyTypeWithDigestLength(void);
extern void test_MD5KeyName(void);
extern void test_SHA1KeyName(void);
extern void test_CMACKeyName(void);


//=======Suite Setup=====
static void suite_setup(void)
{
extern int change_iobufs(int);
extern int change_logfile(const char*, int);
change_iobufs(1);
change_logfile("stderr", 0);
}

//=======Test Reset Option=====
void resetTest(void);
void resetTest(void)
{
  tearDown();
  setUp();
}

char const *progname;


//=======MAIN=====
int main(int argc, char *argv[])
{
  progname = argv[0];
  suite_setup();
  UnityBegin("ssl_init.c");
  RUN_TEST(test_MD5KeyTypeWithoutDigestLength, 16);
  RUN_TEST(test_MD5KeyTypeWithDigestLength, 17);
  RUN_TEST(test_SHA1KeyTypeWithDigestLength, 18);
  RUN_TEST(test_CMACKeyTypeWithDigestLength, 19);
  RUN_TEST(test_MD5KeyName, 20);
  RUN_TEST(test_SHA1KeyName, 21);
  RUN_TEST(test_CMACKeyName, 22);

  return (UnityEnd());
}
