require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_IO_H)) {
    eval 'sub _ASM_IO_H () {1;}' unless defined(&_ASM_IO_H);
    require 'linux/string.ph';
    require 'linux/compiler.ph';
    eval 'sub IO_SPACE_LIMIT () {0xffff;}' unless defined(&IO_SPACE_LIMIT);
    eval 'sub XQUAD_PORTIO_BASE () {0xfe400000;}' unless defined(&XQUAD_PORTIO_BASE);
    eval 'sub XQUAD_PORTIO_QUAD () {0x40000;}' unless defined(&XQUAD_PORTIO_QUAD);
    if(defined(&__KERNEL__)) {
	require 'asm-generic/iomap.ph';
	require 'linux/vmalloc.ph';
	eval 'sub xlate_dev_mem_ptr {
	    my($p) = @_;
    	    eval q( &__va($p));
	}' unless defined(&xlate_dev_mem_ptr);
	eval 'sub xlate_dev_kmem_ptr {
	    my($p) = @_;
    	    eval q($p);
	}' unless defined(&xlate_dev_kmem_ptr);
	eval 'sub page_to_phys {
	    my($page) = @_;
    	    eval q((( &dma_addr_t) &page_to_pfn($page) <<  &PAGE_SHIFT));
	}' unless defined(&page_to_phys);
	eval 'sub dmi_ioremap () { &bt_ioremap;}' unless defined(&dmi_ioremap);
	eval 'sub dmi_iounmap () { &bt_iounmap;}' unless defined(&dmi_iounmap);
	eval 'sub dmi_alloc () { &alloc_bootmem;}' unless defined(&dmi_alloc);
	eval 'sub isa_virt_to_bus () { &virt_to_phys;}' unless defined(&isa_virt_to_bus);
	eval 'sub isa_page_to_bus () { &page_to_phys;}' unless defined(&isa_page_to_bus);
	eval 'sub isa_bus_to_virt () { &phys_to_virt;}' unless defined(&isa_bus_to_virt);
	eval 'sub virt_to_bus () { &virt_to_phys;}' unless defined(&virt_to_bus);
	eval 'sub bus_to_virt () { &phys_to_virt;}' unless defined(&bus_to_virt);
	eval 'sub readw {
	    my($addr) = @_;
    	    eval q({ *( &volatile my $__force *) $addr; });
	}' unless defined(&readw);
	eval 'sub readl {
	    my($addr) = @_;
    	    eval q({ *( &volatile my $__force *) $addr; });
	}' unless defined(&readl);
	eval 'sub readb_relaxed {
	    my($addr) = @_;
    	    eval q( &readb($addr));
	}' unless defined(&readb_relaxed);
	eval 'sub readw_relaxed {
	    my($addr) = @_;
    	    eval q( &readw($addr));
	}' unless defined(&readw_relaxed);
	eval 'sub readl_relaxed {
	    my($addr) = @_;
    	    eval q( &readl($addr));
	}' unless defined(&readl_relaxed);
	eval 'sub __raw_readb () { &readb;}' unless defined(&__raw_readb);
	eval 'sub __raw_readw () { &readw;}' unless defined(&__raw_readw);
	eval 'sub __raw_readl () { &readl;}' unless defined(&__raw_readl);
	eval 'sub writeb {
	    my($b,$addr) = @_;
    	    eval q({ *( &volatile my $__force *) $addr = $b; });
	}' unless defined(&writeb);
	eval 'sub writew {
	    my($b,$addr) = @_;
    	    eval q({ *( &volatile my $__force *) $addr = $b; });
	}' unless defined(&writew);
	eval 'sub writel {
	    my($b,$addr) = @_;
    	    eval q({ *( &volatile my $__force *) $addr = $b; });
	}' unless defined(&writel);
	eval 'sub __raw_writeb () { &writeb;}' unless defined(&__raw_writeb);
	eval 'sub __raw_writew () { &writew;}' unless defined(&__raw_writew);
	eval 'sub __raw_writel () { &writel;}' unless defined(&__raw_writel);
	eval 'sub mmiowb () {
	    eval q();
	}' unless defined(&mmiowb);
	eval 'sub memset_io {
	    my($addr,$val,$count) = @_;
    	    eval q({  &memset(( &void  &__force *) $addr, $val, $count); });
	}' unless defined(&memset_io);
	eval 'sub memcpy_fromio {
	    my($dst,$src,$count) = @_;
    	    eval q({  &__memcpy($dst, ( &void  &__force *) $src, $count); });
	}' unless defined(&memcpy_fromio);
	eval 'sub memcpy_toio {
	    my($dst,$src,$count) = @_;
    	    eval q({  &__memcpy(( &void  &__force *) $dst, $src, $count); });
	}' unless defined(&memcpy_toio);
	eval 'sub __ISA_IO_base () {((\'char\'  &__iomem *)( &PAGE_OFFSET));}' unless defined(&__ISA_IO_base);
	eval 'sub eth_io_copy_and_sum {
	    my($a,$b,$c,$d) = @_;
    	    eval q( &eth_copy_and_sum(($a),( &void  &__force *)($b),($c),($d)));
	}' unless defined(&eth_io_copy_and_sum);
	if(defined( &CONFIG_X86_OOSTORE) || defined( &CONFIG_X86_PPRO_FENCE)) {
	    eval 'sub flush_write_buffers {
	        my($void) = @_;
    		eval q(\\"(assembly code)\\");
	    }' unless defined(&flush_write_buffers);
	    eval 'sub dma_cache_inv {
	        my($_start,$_size) = @_;
    		eval q( &flush_write_buffers());
	    }' unless defined(&dma_cache_inv);
	    eval 'sub dma_cache_wback {
	        my($_start,$_size) = @_;
    		eval q( &flush_write_buffers());
	    }' unless defined(&dma_cache_wback);
	    eval 'sub dma_cache_wback_inv {
	        my($_start,$_size) = @_;
    		eval q( &flush_write_buffers());
	    }' unless defined(&dma_cache_wback_inv);
	} else {
	    eval 'sub dma_cache_inv {
	        my($_start,$_size) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&dma_cache_inv);
	    eval 'sub dma_cache_wback {
	        my($_start,$_size) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&dma_cache_wback);
	    eval 'sub dma_cache_wback_inv {
	        my($_start,$_size) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&dma_cache_wback_inv);
	    eval 'sub flush_write_buffers () {
	        eval q();
	    }' unless defined(&flush_write_buffers);
	}
    }
    if(defined(&SLOW_IO_BY_JUMPING)) {
	eval 'sub __SLOW_DOWN_IO () {"jmp 1f; 1: jmp 1f; 1:";}' unless defined(&__SLOW_DOWN_IO);
    } else {
	eval 'sub __SLOW_DOWN_IO () {"outb %%al,$0x80;";}' unless defined(&__SLOW_DOWN_IO);
    }
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub slow_down_io {
        my($void) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&slow_down_io);
    if(defined(&CONFIG_X86_NUMAQ)) {
	eval 'sub XQUAD_PORT_ADDR {
	    my($port, $quad) = @_;
    	    eval q(( &xquad_portio + ( &XQUAD_PORTIO_QUAD*$quad) + $port));
	}' unless defined(&XQUAD_PORT_ADDR);
	eval 'sub __BUILDIO {
	    my($bwl,$bw,$type) = @_;
    	    eval q( &static  &inline  &void  &out$bwl &_quad(\'unsigned type value\', \'int\'  &port, \'int\'  &quad) {  &if ( &xquad_portio)  &write$bwl( &value,  &XQUAD_PORT_ADDR( &port,  &quad));  &else  &out$bwl &_local( &value,  &port); }  &static  &inline  &void  &out$bwl(\'unsigned type value\', \'int\'  &port) {  &out$bwl &_quad( &value,  &port, 0); }  &static  &inline \'unsigned type in\'$bwl &_quad(\'int\'  &port, \'int\'  &quad) {  &if ( &xquad_portio)  &return  &read$bwl( &XQUAD_PORT_ADDR( &port,  &quad));  &else  &return  &in$bwl &_local( &port); }  &static  &inline \'unsigned type in\'$bwl(\'int\'  &port) {  &return  &in$bwl &_quad( &port, 0); });
	}' unless defined(&__BUILDIO);
    } else {
	eval 'sub __BUILDIO {
	    my($bwl,$bw,$type) = @_;
    	    eval q( &static  &inline  &void  &out$bwl(\'unsigned type value\', \'int\'  &port) {  &out$bwl &_local( &value,  &port); }  &static  &inline \'unsigned type in\'$bwl(\'int\'  &port) {  &return  &in$bwl &_local( &port); });
	}' unless defined(&__BUILDIO);
    }
    eval 'sub BUILDIO {
        my($bwl,$bw,$type) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&BUILDIO);
}
1;
