/*
 * windowx.c - Window opening routine
 *
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>

#include "icon"

/*
 * Program-wide Globals
 *
 */

extern Display    *theDisplay;      /* -- Which display */
extern int        theScreen;        /* -- Which screen on the display */
extern int        theDepth;         /* -- Number of color planes */
extern unsigned long theBlackPixel;  /* -- System "black" color */
extern unsigned long theWhitePixel;  /* -- System "white" color */

#define  BORDER_WIDTH  2

/*
 * openWindow    1.1
 *
 * This function takes a x,y pixel location for the upper-left
 * corner of the window, as well as a width and height for the
 * size of the window.
 * 
 * It opens the window and returns the window ID. It also
 * takes a flag that specifies whether the window is to be
 * a pop-up window (a menu) or not. (Not implemented in this
 * version [1.1]).
 *
 */

Window openWindow(x, y, width, height, flag, theNewGC, theFauxGC)

int x,y,width,height,flag;
GC *theNewGC, *theFauxGC;

{
  XSetWindowAttributes     theWindowAttributes;
  XSizeHints               theSizeHints;
  unsigned long            theWindowMask;
  Window                   theNewWindow,theFauxWindow;
  Pixmap                   theIconPixmap;
  XWMHints                 theWMHints;

/* 
 * First: Set up attributes desired for the window. Important one to observe
 * is 'override_redirect': This specifies whether or not the window manager
 * has control over the window. When set to 'True', the window manager ignores
 * the window.
 */

  theWindowAttributes.border_pixel = theBlackPixel;
  theWindowAttributes.background_pixel = theWhitePixel;
  theWindowAttributes.override_redirect = True;

  theWindowMask = CWBackPixel | CWBorderPixel | CWOverrideRedirect;

/* Second: Open a window on the display. */

  theNewWindow = XCreateWindow(theDisplay, RootWindow(theDisplay,theScreen),
			       x,y,width,height,BORDER_WIDTH,
			       theDepth,
			       InputOutput,
			       CopyFromParent,
			       theWindowMask,
			       &theWindowAttributes);

/* Third: Tell XWindow Manager about Icon information */
 
  theIconPixmap = XCreateBitmapFromData( theDisplay,
					 theNewWindow,
					 icon_bits,
					 icon_width,
					 icon_height );
  theWMHints.icon_pixmap = theIconPixmap;
  theWMHints.initial_state = NormalState;
  theWMHints.flags = IconPixmapHint | StateHint;

  XSetWMHints( theDisplay, theNewWindow, &theWMHints );

/* Now, send size hints */

  theSizeHints.flags = PPosition | PSize;    /* -- what we want */
  theSizeHints.x     = x;
  theSizeHints.y     = y;
  theSizeHints.width = width;
  theSizeHints.height = height;

  XSetNormalHints(theDisplay, theNewWindow, &theSizeHints );

/* Get the GC */

  if(createGC( theNewWindow, theNewGC) == 0)
    {
      XDestroyWindow(theDisplay, theNewWindow);
      return((Window) 0);
    }

/* Create a faux-window with reversed attributes */

  theWindowAttributes.border_pixel = theWhitePixel;
  theWindowAttributes.background_pixel = theBlackPixel;
  theWindowAttributes.override_redirect = True;

  theFauxWindow = XCreateWindow(theDisplay, RootWindow(theDisplay,theScreen),
			       x,y,width,height,BORDER_WIDTH,
			       theDepth,
			       InputOutput,
			       CopyFromParent,
			       theWindowMask,
			       &theWindowAttributes);


  if(createGC( theFauxWindow, theFauxGC) == 0)
    {
      XDestroyWindow(theDisplay, theFauxWindow);
      return((Window) 0);
    }

/* Fourth: Ask X to place the window visibly on the screen. */

  XMapWindow( theDisplay, theNewWindow );
 
/* Fifth: Flush out all queued X commands */

  XFlush( theDisplay );

/* Sixth: Return the window ID */

  return( theNewWindow );
}


int createGC( theNewWindow, theNewGC)

Window theNewWindow;
GC *theNewGC;

{
  XGCValues theGCValues;

  *theNewGC = XCreateGC (theDisplay, theNewWindow,
			 (unsigned long) 0,
			 &theGCValues);

  if (*theNewGC == 0) /* unable to create */
    {
      return(0);
    }
  else
    {
      XSetForeground( theDisplay, *theNewGC, theBlackPixel);
      XSetBackground( theDisplay, *theNewGC, theWhitePixel);
      return(1); /* a-ok! */
    }
}
