######################################################################
##
##		     SOS Master Makefile Template
##
######################################################################


######################################################################
##
## OS Dependant directores
##
override ARCH_DIR = $(shell uname -s | tr / - )-$(shell uname -r)-$(shell uname -m | tr / - )
override OS_TYPE = $(shell uname -s | tr / - )-$(shell uname -r | sed 's/\(\.[^.]*\)\..*/\1/')

export ARCH_DIR OS_TYPE

######################################################################
##
## Database Variables
## Most everybody needs this set *but* BSDI (it's in libc).
DBM_LIBS=-ldb

######################################################################
##
## OS Specific directives (must have a separate file for each OS)
##
include /usr/local/include/make/$(OS_TYPE).mk
######################################################################

ifneq ($(strip $(WANT_SOSAUTH)),)
######################################################################
##
## Authentication information
##

AUTH_ROOT=/src/fearless/seth/src/proj/SOF
SOSAUTH_LIBS=-lsosauth

USING_NULL=true
USING_TEST=false
USING_UNIX=true
USING_HASH_STATIC=true
USING_HASH_DYNAMIC=true
USING_SKEY=true
USING_ENIGMA=false
USING_SECURID=true
USING_CCARD=true

########################################
##
## Null
##
ifeq ($(USING_NULL),true)
NULL_ROOT=
NULL_DEF=-DSOSAUTH_NULL_AUTH
NULL_INCDIR=
NULL_INCLUDES=
NULL_LDIR=
NULL_LINC=
NULL_LIBS=
else
NULL_ROOT=
NULL_DEF=
NULL_INCDIR=
NULL_INCLUDES=
NULL_LDIR=
NULL_LINC=
NULL_LIBS=
endif

########################################
##
## Test defines
##
ifeq ($(USING_TEST),true)
TEST_DEF=-DSOSAUTH_TEST_AUTH
else
endif

########################################
##
## Simple Unix Passwords
##
ifeq ($(USING_UNIX),true)
UNIX_ROOT=
UNIX_DEF=-DSOSAUTH_UNIX_AUTH
UNIX_INCDIR=
UNIX_INCLUDES=
UNIX_LDIR=
UNIX_LINC=
UNIX_LIBS=
else
UNIX_ROOT=
UNIX_DEF=
UNIX_INCDIR=
UNIX_INCLUDES=
UNIX_LDIR=
UNIX_LINC=
UNIX_LIBS=
endif

########################################
##
## SOS's HASH Static Passwords
##
ifeq ($(USING_HASH_STATIC),true)
HASH_STATIC_ROOT=
HASH_STATIC_DEF=-DSOSAUTH_HASH_STATIC_AUTH
HASH_STATIC_INCDIR=
HASH_STATIC_INCLUDES=
HASH_STATIC_LDIR=
HASH_STATIC_LINC=
HASH_STATIC_LIBS=#${MD5_LIBS}
else
HASH_STATIC_ROOT=
HASH_STATIC_DEF=
HASH_STATIC_INCDIR=
HASH_STATIC_INCLUDES=
HASH_STATIC_LDIR=
HASH_STATIC_LINC=
HASH_STATIC_LIBS=
endif

########################################
##
## SOS's HASH Dynamic Passwords
##
ifeq ($(USING_HASH_DYNAMIC),true)
HASH_DYNAMIC_ROOT=
HASH_DYNAMIC_DEF=-DSOSAUTH_HASH_DYNAMIC_AUTH
HASH_DYNAMIC_INCDIR=
HASH_DYNAMIC_INCLUDES=
HASH_DYNAMIC_LDIR=
HASH_DYNAMIC_LINC=
HASH_DYNAMIC_LIBS=#${MD5_LIBS}
else
HASH_DYNAMIC_ROOT=
HASH_DYNAMIC_DEF=
HASH_DYNAMIC_INCDIR=
HASH_DYNAMIC_INCLUDES=
HASH_DYNAMIC_LDIR=
HASH_DYNAMIC_LINC=
HASH_DYNAMIC_LIBS=
endif

########################################
##
## Bellcore's S/Key
##
ifeq ($(USING_SKEY),true)
SKEY_ROOT=${AUTH_ROOT}/auth/skey-1.1b.sos
SKEY_DEF=-DSOSAUTH_SKEY_AUTH
SKEY_INCDIR=${SKEY_ROOT}/src
SKEY_INCLUDES=-I${SKEY_INCDIR}
SKEY_LDIR=${SKEY_ROOT}/src
SKEY_LINC=
SKEY_LIBS=-lskey
else
SKEY_ROOT=
SKEY_DEF=
SKEY_INCDIR=
SKEY_INCLUDES=
SKEY_LDIR=
SKEY_LINC=
SKEY_LIBS=
endif

########################################
##
## Enigma
##
## Enigma has problem so it is no
## longer officially supported
##
ifneq ($(USING_ENIGMA),false)
ifeq ($(USING_ENIGMA),3)
ENIGMA_DEF=-DSOSAUTH_ENIGMA_AUTH=3
ENIGMA_ROOT=${AUTH_ROOT}/auth/Enigma.unix.3$(OS_EXT)
else
ENIGMA_DEF=-DSOSAUTH_ENIGMA_AUTH=4
ENIGMA_ROOT=${AUTH_ROOT}/auth/Enigma.unix.4$(OS_EXT)
endif
ENIGMA_INCDIR=${ENIGMA_ROOT}
ENIGMA_INCLUDES=-I${ENIGMA_INCDIR}
ENIGMA_LDIR=${ENIGMA_ROOT}
ENIGMA_LINC=-L${ENIGMA_LDIR}
ENIGMA_LIBS=-lidpb
else
ENIGMA_ROOT=
ENIGMA_DEF=
ENIGMA_INCDIR=
ENIGMA_INCLUDES=
ENIGMA_LDIR=
ENIGMA_LINC=
ENIGMA_LIBS=
endif

########################################
##
## SecurID
##
ifeq ($(USING_SECURID),true)
SID_ROOT=
SID_DEF=-DSOSAUTH_SECURID_AUTH
SID_INCDIR=
SID_INCLUDES=
SID_LDIR=
SID_LINC=
SID_LIBS=-lsdiclient
else
SID_ROOT=
SID_DEF=
SID_INCDIR=
SID_INCLUDES=
SID_LDIR=
SID_LINC=
SID_LIBS=
endif

########################################
##
## CryptoCard
##
ifeq ($(USING_CCARD),true)
CCARD_ROOT=${AUTH_ROOT}/auth/cryptocard-1.0
CCARD_DEF=-DSOSAUTH_CCARD_AUTH
CCARD_INCDIR=${CCARD_ROOT}
CCARD_INCLUDES= #-I${CCARD_INCDIR}
CCARD_LDIR=${CCARD_ROOT}
CCARD_LINC= #-L${CCARD_LDIR}
CCARD_LIBS=-lccard
else
CCARD_ROOT=
CCARD_DEF=
CCARD_INCDIR=
CCARD_INCLUDES=
CCARD_LDIR=
CCARD_LINC=
CCARD_LIBS=
endif

########################################
##
## Authentication Defines
##
AUTH_DEF=${NULL_DEF} ${TEST_DEF} ${UNIX_DEF} ${HASH_STATIC_DEF} ${HASH_DYNAMIC_DEF} ${SKEY_DEF} ${ENIGMA_DEF} ${SID_DEF} ${CCARD_DEF}
AUTH_INCLUDES=${NULL_INCLUDES} ${TEST_INCLUDES} ${UNIX_INCLUDES} ${HASH_STATIC_INCLUDES} ${HASH_DYNAMIC_INCLUDES} ${SKEY_INCLUDES} ${ENIGMA_INCLUDES} ${SID_INCLUDES} ${CCARD_INCLUDES}
AUTH_LINC=${NULL_LINC} ${TEST_LINC} ${UNIX_LINC} ${HASH_STATIC_LINC} ${HASH_DYNAMIC_LINC} ${SKEY_LINC} ${ENIGMA_LINC} ${SID_LINC} ${CCARD_LINC}
AUTH_VPATH=${NULL_LDIR}:${TEST_LDIR}:${UNIX_LDIR}:${HASH_STATIC_LDIR}:${HASH_DYNAMIC_LDIR}:${SKEY_LDIR}:${ENIGMA_LDIR}:${SID_LDIR}:${CCARD_LDIR}
AUTH_LIBS=${SOSAUTH_LIBS} ${NULL_LIBS} ${TEST_LIBS} ${UNIX_LIBS} ${HASH_STATIC_LIBS} ${HASH_DYNAMIC_LIBS} ${SKEY_LIBS} ${ENIGMA_LIBS} ${SID_LIBS} ${CCARD_LIBS}
else
AUTH_DEF=
AUTH_INCLUDES=
AUTH_LINC=
AUTH_VPATH=
AUTH_LIBS=
endif

######################################################################
##
## Encryption
##
ifeq ($(SOS_ENCRYPT_MODE),DES)
else
ifeq ($(SOS_ENCRYPT_MODE),SNUFFLE)
else
SOS_ENCRYPT_MODE=SNUFFLE
endif
endif


DES_DEF=-DUSE_STREAM_DES
DES_LIBS=-ldes

SNUFFLE_DEF=-DUSE_STREAM_SNUFFLE
SNUFFLE_LIBS=-lsnuffle

ifeq ($(SOS_ENCRYPT_MODE),DES)
ENCRYPT_ROOT=$(DES_ROOT)
ENCRYPT_DEF=#$(DES_DEF)
ENCRYPT_INCDIR=$(DES_INCDIR)
ENCRYPT_INCLUDES=$(DES_INCLUDES)
ENCRYPT_LDIR=$(DES_LDIR)
ENCRYPT_LINC=$(DES_LINC)
ENCRYPT_LIBS=$(DES_LIBS)
else
ifeq ($(SOS_ENCRYPT_MODE),SNUFFLE)
ENCRYPT_ROOT=$(SNUFFLE_ROOT)
ENCRYPT_DEF=#$(SNUFFLE_DEF)
ENCRYPT_INCDIR=$(SNUFFLE_INCDIR)
ENCRYPT_INCLUDES=$(SNUFFLE_INCLUDES)
ENCRYPT_LDIR=$(SNUFFLE_LDIR)
ENCRYPT_LINC=$(SNUFFLE_LINC)
ENCRYPT_LIBS=$(SNUFFLE_LIBS)
endif
endif



######################################################################
##
## Compiler variables
##
ifeq ($(USING_INSIGHT),true)
CC=insight
else
CC=gcc
endif

LEX=flex
YACC=bison -d
UMASK=:
INSTALL=install
INSTALL_BINFLAGS=-m 775
INSTALL_OTHERFLAGS=-m 664
MKDEP=$(CPP) -M $(CFLAGS)

########################################
# C
COPTDEBUG=-g -O -Werror
#COPTDEBUG=-g
#COPTDEBUG=-O2
########################################

##############################################################################
# include a local override file in current directory (if exists),
# and then one at the $TOPDIR.
-include Make-$(OS_TYPE).mk
-include $(TOPDIR)/Make-$(OS_TYPE).mk
##############################################################################

COMMON_DEFINES=-D__STDC__ $(DEBUG_FLAG) $(OS_FLAGS)
COMMON_INCLUDES=-I$(SOS)/include -I/usr/local/include
COMMON_LDS=-L$(SOS)/lib/lib.$(ARCH_DIR) $(OS_LDFLAGS) -L/usr/local/lib
COMMON_LIBS=$(OS_LIBS) -lz

ifneq ($(strip $(WANT_SOS_LIBS)),)
SOS_LDS=$(AUTH_LINC)
SOS_CONSLIBS=-lsoscons -lsoslice -lsosstore
SOS_LIBS=$(AUTH_LIBS) -lsos -ldict -lfsma -lpq -lmd5 $(ENCRYPT_LIBS) -lm
endif

CFLAGS=	$(COPTDEBUG) $(PRIVATE_COPTDEBUG) $(PRIVATE_DEFINES) $(COMMON_DEFINES) ${STANDARD_DEFINES} $(LOCAL_DEFINES) \
	$(PRIVATE_INCLUDES) $(COMMON_INCLUDES) ${STANDARD_INCLUDES} ${LOCAL_INCLUDES} 
LDFLAGS=$(PRIVATE_LDS) $(SOS_LDS) ${STANDARD_LDS} $(COMMON_LDS) ${LOCAL_LDS}
LDLIBS=$(PRIVATE_LIBS) $(PRIVATE_NODEP_LIBS) $(SOS_LIBS) $(STANDARD_LIBS) ${COMMON_LIBS} ${LOCAL_LIBS}

VPATH+=:$(AUTH_VPATH):$(SOS)/lib/lib.${ARCH_DIR}:/usr/local/gnu/lib:/usr/local/lib:/usr/lib:

########################################
# Information for multiple-arch builds
ifneq ($(strip $(CURDIR)),)
BUILD_UPDIR=../..
vpath %.h $(TOPDIR)/$(BUILD_UPDIR)/$(CURDIR)
vpath %.c $(TOPDIR)/$(BUILD_UPDIR)/$(CURDIR)
vpath %.l $(TOPDIR)/$(BUILD_UPDIR)/$(CURDIR)
vpath %.y $(TOPDIR)/$(BUILD_UPDIR)/$(CURDIR)
endif


########################################
# Lex
LOPTDEBUG=
#LOPTDEBUG=-CF

LEX_LIB=-lfl
LFLAGS=$(LOPTDEBUG)


######################################################################
##
## Makefile rules
##

%.o: %.c
	$(COMPILE.c) $(OUTPUT_OPTION) $<

%.c: %.l
	$(LEX) $(LFLAGS) -t $< > $@

%.tab.c: %.y
	$(YACC) $(YFLAGS) $<

######################################################################
##
## Common targets
##

########################################
# Default target (for user to munge)
ifneq ($(strip $(NO_DEFAULT_RULE)),)
default::
else
default:: $(PRIVATE_TARGETS) $(LIBS) $(SIMPLE_PROGS) $(COMPLEX_PROGS)
ifneq ($(strip $(SUBDIR)),)
	$(SUBDIRRULE)	
endif
endif


########################################
# Simple programs:
#
# Due to a bug in GNU make on NT, I have to ignore the library dependencies.
# Therefore you must know when you need to relink applications, when their
# libraries have changed.
# -Erez.
ifeq ($(OS_TYPE),CYGWIN32-NT-4.0)
$(SIMPLE_PROGS): %: %.o
	$(LINK.c) -o $@ $@.o $(LDLIBS)
else
$(SIMPLE_PROGS): %: %.o $(LDLIBS)
	$(LINK.c) -o $@ $@.o $(LDLIBS)
endif
########################################
# Clean
SOS_JUNK=*.o *.a *~ core $(SIMPLE_PROGS) $(COMPLEX_PROGS) $(LIBS) tca.log tca.map .inslog _1001.out a.out mon.out gmon.out *.core

clean::
	$(RM) $(SOS_JUNK) $(PRIVATE_JUNK) .depend
ifneq ($(strip $(SUBDIR)),)
	$(SUBDIRRULE)	
endif

neat::
	$(RM) $(SOS_JUNK) $(PRIVATE_JUNK)
ifneq ($(strip $(SUBDIR)),)
	$(SUBDIRRULE)	
endif

########################################
# Subdirectories
SUBDIRRULE=@SUBDIR="${SUBDIR}"; if [ -n "$$SUBDIR" ]; then for d in $$SUBDIR; do (cd $$d; $(MAKE) $(MFLAGS) $@); done; fi

########################################
# Dependancies
ifneq ($(strip $(OBJ)),)
depends:: $(OBJ:.o=.c)
	$(MKDEP) $^ > .depend
endif

ifneq ($(strip $(SIMPLE_PROGS)),)
depends:: $(SIMPLE_PROGS:=.c)
	$(MKDEP) $^ > .depend
endif

ifneq ($(strip $(SUBDIR)),)
depends::
	$(SUBDIRRULE)	
endif

######################################################################
# BUILD targets for multi-arch
#
ifneq ($(strip $(CURDIR)),)
build::
	-d=BUILD/$(ARCH_DIR); (ls ./Make*; find $(SUBDIR) -name Make\* -print) | while read f; do mkdir -p $$d/`dirname $$f`; ln -s `pwd`/$$f $$d/$$f; done
	@echo "To compile: cd BUILD/$(ARCH_DIR) and type make"
endif

########################################
# Install
install::
ifneq ($(strip $(SUBDIR)),)
	$(SUBDIRRULE)	
endif


######################################################################
######################################################################
# Start auto generated depenancies				     #
######################################################################
######################################################################
-include .depend

.PHONY : default clean neat depends install
