#include "sos.h"
/**********************************************************************
 *				 CLC ERRORS			      *
 **********************************************************************/

/* This information is static in the CLC distribution. Sigh.. */

char *sos_clc_error_codes(int s)
{
  SOS_ENTRY("sos", __FUNCTION__, NULL);

  switch (s)
    {
    case DICT_ENOMEM:
      SOS_RETURN ("out of memory");
      break;
      
    case DICT_ENOTFOUND:
      SOS_RETURN("object not found"); 
      break;
      
    case DICT_ENOOOCOMP:
      SOS_RETURN("object-object comparison function is missing");
      break;

    case DICT_ENOKOCOMP:
      SOS_RETURN("key-object comparison function is missing");
      break;

    case DICT_ENULLOBJECT:
      SOS_RETURN("object is NULL");
      break;

    case DICT_EEXISTS:
      SOS_RETURN("object exists");
      break;

    case DICT_ENOHVFUNC:
      SOS_RETURN("hashvalue extraction function is missing");
      break;

    case DICT_EBADOBJECT:
      SOS_RETURN("object does not exist");
      break;

    case DICT_EBADORDER:
      SOS_RETURN("bad order flag");
      break;

    case DICT_EORDER:
      SOS_RETURN("specified order not supported");
      break;

    case DICT_ENOERROR:
      SOS_RETURN("No error");
      break;

    default:
      SOS_RETURN("Unknown CLC error");
    }

}



