#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Compatibility functions.
 */

#ifdef __linux__

#include <syscall.h>
#include <sys/socket.h>
#include <sys/socketcall.h>
#include <linux/net.h>

static inline _syscall2(long,socketcall,int,call,unsigned long *,args);
int recvmsg (int sockfd, struct msghdr *msg, unsigned int flags);
int sendmsg (int sockfd, struct msghdr *msg, unsigned int flags);

int
recvmsg (int sockfd, struct msghdr *msg, unsigned int flags)
{
  unsigned long args[3];
  args[0] = sockfd;
  args[1] = (unsigned long) msg;
  args[2] = flags;
  return (socketcall (SYS_RECVMSG, args));
}

int
sendmsg (int sockfd, struct msghdr *msg, unsigned int flags)
{
  unsigned long args[3];
  args[0] = sockfd;
  args[1] = (unsigned long) msg;
  args[2] = flags;
  return (socketcall (SYS_SENDMSG, args));
}

#endif /* __linux__ */

