#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * SOS Error routines
 *
 * enable a function to generate error message via some non-interferring
 * manner which can be later outputted.
 *
 * If this looks alot like the bounded message queue functions, there is a reason.
 *
 * Debug levels:
 *
 * 1 - debug messages added
 */

#include "sos.h"


static sos_mq_t libsos_error_queue = NULL;



/*
 * Create a message queue and perform initialization
 */
void sos_error_create(int queue_len)
{
  SOS_ENTRY("sos_error","sos_error_create", NULL);
  libsos_error_queue = sos_mq_create(queue_len);
  SOS_VRETURN();
}



/*
 * Add a string to the message queue
 * (possibly causing an older one to fall off the end)
 */
int sos_error_add(char *str)
{
  SOS_ENTRY("sos_error","sos_error_add", NULL);
  char outbuf[1152];
  char *curfun = sos_fun_current(1,NULL,NULL);

  snprintf(outbuf,1152,"%s: %s",curfun?curfun:"(unknown)",str);

  sos_debug_printf_and(1,"adding message %s",outbuf);
  SOS_RETURN(sos_mq_add(libsos_error_queue, outbuf));
}



/*
 * Add a string generated by sprintf to the message queue
 * (possibly causing an older one to fall off the end)
 *
 */
int sos_error_printf(char *fmt, ...)
{
  SOS_ENTRY("sos_error","sos_error_printf",NULL);
  va_list args;
  char buf[1024];
  char outbuf[1152];
  char *curfun = sos_fun_current(1,NULL,NULL);

  va_start(args, fmt);
  vsnprintf(buf, 1024, fmt, args);
  va_end(args);

  snprintf(outbuf,1152,"%s: %s",curfun?curfun:"(unknown)",buf);

  sos_debug_printf_and(1,"adding message %s",outbuf);
  SOS_RETURN(sos_mq_add(libsos_error_queue, outbuf));
}



/*
 * Print, non-destructively, the current strings in the queue
 * to the supplied file descriptor
 */
int sos_error_fdout(int fd)
{
  SOS_ENTRY("sos_error","sos_error_fdout",NULL);
  SOS_RETURN(sos_mq_fdout(libsos_error_queue, fd));
}



/*
 * Print, non-destructively, the current strings in the queue
 * to the supplied file handle
 */
int sos_error_stdout(FILE *out)
{
  SOS_ENTRY("sos_error","sos_error_stdout",NULL);
  SOS_RETURN(sos_mq_stdout(libsos_error_queue, out));
}



/*
 * Print, non-destructively, the current strings in the queue
 * via soslog at the supplied priority
 */
int sos_error_soslog(int priority)
{
  SOS_ENTRY("sos_error","sos_error_soslog",NULL);
  SOS_RETURN(sos_mq_soslog(libsos_error_queue, priority));
}



/*
 * Peek at the depth string from the top (0 is top)
 */
char *sos_error_peek(int depth)
{
  SOS_ENTRY("sos_error","sos_error_peek",NULL);
  SOS_RETURN(sos_mq_peek(libsos_error_queue, depth));
}



/*
 * Pop number of strings from the queue (1 will pop the top--0 will pop all)
 */
int sos_error_pop(int number)
{
  SOS_ENTRY("sos_error","sos_error_pop",NULL);
  SOS_RETURN(sos_mq_pop(libsos_error_queue, number));
}



/*
 * Destroy the queue and all messages in it
 */
int sos_error_destroy(void)
{
  SOS_ENTRY("sos_error","sos_error_destroy",NULL);
  int ret;

  ret = sos_mq_destroy(libsos_error_queue);
  libsos_error_queue = NULL;

  SOS_RETURN(ret);
}
