#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Find the FQ hostname
 */

#include "sos.h"



/*
 * Get the fully qualified host name
 */
char *sos_fqhname(char *name,int namelen)
{
  SOS_ENTRY("sos_fqhname","sos_fqhname",NULL);
  char *fqname;
  static char statbuf[MAXHOSTNAMELEN+1];

  memset(statbuf,0,MAXHOSTNAMELEN+1);

  if (gethostname(statbuf,MAXHOSTNAMELEN) < 0)
    {
      sos_error_printf("Could not get host name: %s\n",strerror(errno));
      SOS_RETURN(NULL);
    }

  fqname = sos_getnbyfoo(statbuf,NULL,0);

  if (!fqname)
    {				/* No DNS entry */
      fqname = statbuf;
    }

  if (!name)
    SOS_RETURN(fqname);		/* Use static buffer */

  if (strlen(fqname) > namelen)
    {
      sos_error_printf("Could not fit FQ hostname into supplied buffer (%d > %d)\n",strlen(fqname),namelen);
      SOS_RETURN(NULL);		/* Not long enough */
    }

  strcpy(name,fqname);
  SOS_RETURN(name);
}
