#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER
 * DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER
 * DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER
 *
 * SOS did not develop sos_soundex.  It was written by Jonathan Leffler
 * as described below.
 *
 * We did apply a bugfix or two and we did SOSify it.
 *
 * DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER
 * DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER
 * DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER DISCLAIMER
 */


/*
 *	SOUNDEX CODING
 *
 *	Rules:
 *	1.	Retain the first letter; ignore non-alphabetic characters.
 *	2.	Replace second and subsequent characters by a group code.
 *		Group	Letters
 *		1		BFPV
 *		2		CGJKSXZ
 *		3		DT
 *		4		L
 *		5		MN
 *		6		R
 *	3.	Do not repeat digits
 *	4.	Truncate or ser-pad to 4-character result.
 *
 *	Originally formatted with tabstops set at 4 spaces -- you were warned!
 *
 *	Code by: Jonathan Leffler (john@sphinx.co.uk)
 *	This code is shareware -- I wrote it; you can have it for free
 *	if you supply it to anyone else who wants it for free.
 *
 *	BUGS: Assumes ASCII
 */

#include <sos.h>
#define SOS_SOUNDEX_BUGFIX
#define KNUTH_SOUNDEX


static char	lookup[] = {
	'0',	/* A */
	'1',	/* B */
	'2',	/* C */
	'3',	/* D */
	'0',	/* E */
	'1',	/* F */
	'2',	/* G */
	'0',	/* H */
	'0',	/* I */
	'2',	/* J */
	'2',	/* K */
	'4',	/* L */
	'5',	/* M */
	'5',	/* N */
	'0',	/* O */
	'1',	/* P */
#ifdef KNUTH_SOUNDEX
	'2',	/* Q */
#else /* KNUTH_SOUNDEX */
	'0',	/* Q */
#endif /* KNUTH_SOUNDEX */
	'6',	/* R */
	'2',	/* S */
	'3',	/* T */
	'0',	/* U */
	'1',	/* V */
	'0',	/* W */
	'2',	/* X */
	'0',	/* Y */
	'2',	/* Z */
};



/*
 *	Soundex for arbitrary number of characters of information
 */
char *sos_nsoundex(char *str, int n)
{
  SOS_ENTRY("sos_soundex","sos_nsoundex",NULL);
  static char buff[10];
  register char	*s;
  register char	*t;
  char	c;
  char	l;

  if (!str)
    {
      sos_error_printf("Invalid arguments\n");
      SOS_RETURN(NULL);
    }

  if (n <= 0)
    n = 4;	/* Default */
  if (n > sizeof(buff) - 1)
    n = sizeof(buff) - 1;
  t = &buff[0];

  for (s = str; ((c = *s) != '\0') && t < &buff[n]; s++)
    {
      if (!isascii(c))
	continue;
      if (!isalpha(c))
	continue;
      c = toupper(c);
      if (t == &buff[0])
	{
	  l = *t++ = c;
#ifdef SOS_SOUNDEX_BUGFIX
	  l = lookup[c-'A'];			/* BUGFIX--l is in lookup-space, not ascii */
#endif /* SOS_SOUNDEX_BUGFIX */
	  continue;
	}
      c = lookup[c-'A'];
      if (c != '0' && c != l)
	l = *t++ = c;
    }

  while (t < &buff[n])
    *t++ = '0';
  *t = '\0';

  SOS_RETURN(&buff[0]);
}



/*
 * Normal external interface
 */
char *sos_soundex(char *str)
{
  SOS_ENTRY("sos_soundex","sos_soundex",NULL);
  SOS_ORETURN(sos_nsoundex(str, 4));
}


/*
 * Alternative interface which uses supplied buffer, sort of
 */
char *sos_soundex_buf(char *str, char *dest)
{
  SOS_ENTRY("sos_soundex","sos_soundex_malloc",NULL);

  if (!str || !dest)
    {
      sos_error_printf("Invalid arguments\n");
      SOS_RETURN(NULL);
    }

  strcpy(dest, sos_nsoundex(str, 4));
  SOS_RETURN(dest);
}



#ifdef SOUNDEXTEST
main()
{
	char	buff[30];

	while (fgets(buff, sizeof(buff), stdin) != (char *)0)
		printf("Given: %s Soundex produces %s\n", buff, soundex(buff));
}
#endif
