#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * SOS architecture "independent" (HA!) statfs functions
 * These are totally hacked together! Cf GNU fileutils for the proper 
 * way of doing this!!!
 *
 * At any rate, they provide a consistent API and that's usefull.  See 
 * sos.h for complete info on sos_fsinfo structure and unix-decl.h for info
 * on the required macros.  
 */

#include "sos.h"



#ifndef SOS_STATFS
#	error "Please specifiy the STATFS information for this platform (normally in unix-decl.h"
#	error "Then please send the updates to manager@soscorp.com"
#endif /* ! SOS_STATFS */


/*
 * Basic statfs function
 */
int 
sos_statfs(char *path, struct sos_fsinfo *fsinfo)
{
  SOS_ENTRY("sos_statfs","sos_statfs",NULL);
  sos_tmpstatfs tmpstat;

  if ( SOS_STATFS(path, (sos_tmpstatfs *)&tmpstat) < 0 )
    {
      sos_error_printf("statfs(%s) failed: %s\n",path,strerror(errno));
      SOS_RETURN(-1);
    }

  fsinfo->f_fsize = SOS_FSIZE(tmpstat);
  fsinfo->f_blocks = tmpstat.f_blocks;
  fsinfo->f_bfree = tmpstat.f_bfree;
  fsinfo->f_bavail = tmpstat.f_bavail;
  fsinfo->f_files = tmpstat.f_files;
  fsinfo->f_ffree = SOS_FINODE(tmpstat);
  
  SOS_RETURN(0);
}



/*
 * statfs from a fd
 */
int 
sos_fstatfs(int fd, struct sos_fsinfo *fsinfo)
{
  SOS_ENTRY("sos_statfs","sos_fstatfs",NULL);
  sos_tmpstatfs tmpstat;

  if ( SOS_FSTATFS(fd, (sos_tmpstatfs *)&tmpstat) < 0 )
    {
      sos_error_printf("fstatfs(%d) failed: %s\n",fd,strerror(errno));
      SOS_RETURN(-1);
    }

  fsinfo->f_fsize = SOS_FSIZE(tmpstat);
  fsinfo->f_blocks = tmpstat.f_blocks;
  fsinfo->f_bfree = tmpstat.f_bfree;
  fsinfo->f_bavail = tmpstat.f_bavail;
  fsinfo->f_files = tmpstat.f_files;
  fsinfo->f_ffree = SOS_FINODE(tmpstat);
  
  SOS_RETURN(0);
}



/*
 * Convert from one blocksize to another. Generally used to statfs information
 * reported in 512b to 1024b values.
 *
 * Input	num_blocks: number of blocks
 *		from: current block size
 *		to: target block size
 *
 * Ouput	Number of blocks in target blocksize
 */
sos_fslong_t
sos_blocksize_convert(sos_fslong_t num_blocks, 
		      sos_fslong_t from,
		      sos_fslong_t to)
{
  return ( (sos_fslong_t)((double)num_blocks * (double)from / (double)to));
}





