#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Routine to generate values for SOS's dynamic authentication type
 */


#include "sos.h"

main(int argc,char *argv[])
{
  int c, errflg = 0;
  extern char *optarg;
  extern int optind;
  int echo=0;
  char password[80];
  char *tmp;
  char in_testbuf[32];

  while ((c = getopt(argc, argv, "e")) != -1)
    switch (c)
      {
      case 'e':
	echo++;
	break;
      }

  if (errflg || optind != argc - 2)
    {
      fprintf(stderr,"Usage: %s [-e] <challenge>\n",argv[0]);
      exit(5);
    }

  fprintf(stderr,"Please enter password: ");
  fgets(password,80,stdin);
  sos_rip(password);

/*  salt = argv[optind];*/
  sscanf(argv[optind+0],"%08X",((unsigned int *)(in_testbuf)));
  sscanf(argv[optind+1],"%08X",((unsigned int *)(in_testbuf+4)));

  tmp = sos_dynamichash("",in_testbuf,password);
  printf("Dynamic hash is: %08X %08X\n",*((unsigned int *)(tmp)),*((unsigned int *)(tmp+4)));
  exit(0);
}
