#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Test the ProcTitle routines
 */

#include "sos.h"

char *program = "before";
void PrintInfo(int argc, char *argv[], char *envp[]);


main(int argc, char *argv[], char **envp)
{
  int c;
  int ret = -2;
  char cmd[80];

  PrintInfo(argc, argv, envp);
  fflush(stdout);
  system(cmd);
  fflush(stdout);

  if (sos_initProcTitle(argc, &argv, &envp, &program) < 0)
    {
      perror("init ProcTitle");
      exit(2);
    }

#ifdef PS
  sprintf(cmd, "ps -fp %d", getpid());
#else
  sprintf(cmd, "sps wep %d", getpid());
#endif


  PrintInfo(argc, argv, envp);
  fflush(stdout);
  system(cmd);
  fflush(stdout);

#if 1
  sos_setProcTitle("User seth, Dhost dauntless.soscorp.com, Shost sirius.ctr.columbia.edu, pid %d ", getpid());
#else
  sos_setProcTitle("12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890");
#endif
  fflush(stdout);
  PrintInfo(argc, argv, envp);
  fflush(stdout);
  system(cmd);
  fflush(stdout);

#ifdef ENV
  printf("\n\nPRINTENV\n--------------------------------------------------\n");
  fflush(stdout);

  system("/usr/ucb/printenv");
#endif

  fflush(stdout);
  if (fork() == 0)
    {
      printf("Child\n");
      sos_setProcTitle("Child: User seth, Dhost dauntless.soscorp.com, Shost sirius.ctr.columbia.edu, pid %d ", getpid());
    }
  else
    printf("Parent\n");

#ifdef PS
  sprintf(cmd, "ps -fp %d", getpid());
#else
  sprintf(cmd, "sps wep %d", getpid());
#endif

  fflush(stdout);
  PrintInfo(argc, argv, envp);
  fflush(stdout);
  system(cmd);
  fflush(stdout);

#ifdef ENV
  printf("\n\nPRINTENV\n--------------------------------------------------\n");
  fflush(stdout);

  system("/usr/ucb/printenv");
#endif

  exit(0);
}


void PrintInfo(int argc, char *argv[], char *envp[])
{
  int c;

  printf("\n\nProgram %s\n\nARGV\n--------------------------------------------------\n", program);

  for(c=0;c<argc;c++)
    {
      printf("argv[%02d] = %s\n", c, argv[c]);
    }

#ifdef ENV
  printf("\nENVP\n--------------------------------------------------\n");

  for(c=0;envp[c];c++)
    {
      printf("envp[%03d] = %s\n", c, envp[c]);
    }
#endif
  printf("\n\n");
}
