#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Test the SecureNets databases
 */

#include "sos.h"

sos_config_t config;
char *program;

#ifdef DEBUG
extern char libsos_information[];
#define PRINT_LIBSOSLOG() fprintf(stderr,"%s",libsos_information)
#endif


main(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int c;
  int ret = -2;
  char *cname = NULL;
  int file = 0;
  int init = 0;
  int addr = 0;
  struct in_addr saddr;
  SOS_Snets snets;

  program = argv[0];

  while ((c = getopt(argc, argv, "f:c:a:")) != -1)
    switch (c)
      {
      case 'a':
	if (sos_getabyfoo(optarg, &saddr) < 0)
	  goto usage;
	addr = 1;
	break;

      case 'f':
	cname = optarg;
	init = 1;
	file = 1;
	break;

      case 'c':
	cname = optarg;
	init = 1;
	file = 0;
	break;

      default:
      usage:
	printf("Usage: %s [-c <sos config file>] [-f <SNET config file>] [-a addr] \n",argv[0]);
	exit(1);
	break;
      }

  if (!init)
    goto usage;

  if (file)
    {
      snets = sos_LoadSecureNets_File(cname);
    }
  else
    {
      config = sos_config_read(cname);
      if (!config) goto badconfig;
      snets = sos_LoadSecureNets_Config(config, "snets");
    }

  if (!snets)
    {
    badconfig:
#ifdef DEBUG
      PRINT_LIBSOSLOG();
#endif
      fprintf(stderr,"Could not read config %s\n",cname);
      exit(2);
    }
  else
    {
      fprintf(stderr, "found snets in config file\n");
    }

  if (!addr)
    {
      ret = sos_CheckSecureNets_fd(snets, 0);
    }
  else
    {
      ret = sos_CheckSecureNets(snets, saddr);
    }

  switch (ret)
    {
    case -1:
#ifdef DEBUG
      PRINT_LIBSOSLOG();
#endif
      fprintf(stderr,"ERROR, could not verify connection\n");
      break;
    case 0:
      fprintf(stderr,"You are not allowed in\n");
      break;
    case 1:
      fprintf(stderr,"YOU WON!!!\n");
      break;
    }
  exit(0);
}
