#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Test XDR routines
 */

#include "sos.h"

int client(char *, int);
int server(int);

int port=9999;


main(int argc, char *argv[])
{
  SOS_ENTRY("testab", "main",NULL);
  extern char *optarg;
  extern int optind;
  int c;
  int testnbio=0;

  
  while ((c = getopt(argc, argv, "d:nrt:p:")) != -1)
    switch (c)
      {
      case 'r':
	server(testnbio);
	break;

      case 't':			/* This argument must go last! */
	client(optarg, testnbio);
	break;

      case 'p':
	port = atoi(optarg);
	break;       

      case 'n': 
	testnbio++;
	break;
	
      case 'd': 
	sos_debug_set("sos_alice_bob", atoi(optarg));
#if 0
	sos_debug_set("sos_fun", 1);
#endif
	sos_debug_set("sos_error",1);
	sos_debug_info(stderr,0);
	sos_fun_upbug();
	printf ("Setting debug level to: %d\n", atoi(optarg));
	break;


	printf("Usage: %s [-p port] [-n] [-d debug level] -r|-t server\n",argv[0]);
	exit(1);
	break;
      }
  exit(0);
}


int
client(char *server, int testnbio)
{
  int s;			/* socket */
  if ( (s=sos_nmake_conn(server, port, 9999, 0, NULL)) < 0 )
    {
      perror("Failed to make connection");
      exit(0);
    }
  
  return (run_alice_bob(s,testnbio));

}


int
server(int testnbio)
{

/*  SOS_ENTRY("testab", "server",NULL);*/
  int s;			/* Socket */
  int child;			/* Socket */
  struct sockaddr_in sock;	/* My name. */
  int len;			/* Length of socket */


  if ( (s = sos_get_conn(NULL, port, SO_REUSEADDR, NULL)) < 0 )
    {
      perror("Failed to set up service");
      exit(1);
    }
  
  len = sizeof (sock);
  memset((char *)&sock, (char )0, sizeof(sock));
  if ((child  = accept (s, (struct sockaddr *)&sock, (int *)&len)) < 0)
    {
      perror("accept");
      exit(5);
    }
  fprintf(stderr,"Acceptance is nice\n");

  return (run_alice_bob(child,testnbio));

}

int 
run_alice_bob(int s,int testnbio)
{
  int ret;
  sos_alice_bob_handle abh=NULL;
  sos_nbio_handle *rnbh;
  sos_nbio_handle *wnbh;

  if (!testnbio ) 
    {
      if ( (ret=sos_alice_bob (s, sosBIOread, s, sosBIOwrite)) == -1 )
	{
	  fprintf(stderr,"Alice/Bob failed\n");
	  exit (1);
	}
      else
	{
	  printf ("I will play the role of %s\n", (ret==SOS_IDENT_ALICE?"Alice":"Bob"));
	}
    }
  else
    {
      rnbh=sos_nbio_fdopen(s, sosRawRead, O_RDONLY);
      wnbh=sos_nbio_fdopen(s, sosRawWrite, O_WRONLY);

ab_cont:      
      ret = sos_nbio_alice_bob (rnbh, sos_nbio_read, wnbh, sos_nbio_write, NULL, NULL, &abh);

      sos_debug_printf_and(128,"Return from nbio: %d\n", ret);

      switch (ret)
	{
	case -1:
	  fprintf(stderr,"Alice/Bob failed\n");
	  exit (1);
	  break;

	case SOS_NBIO_ALICE_BOB_NOPROGRESS:
	  sos_debug_printf_and(64,"Alice/Bob seems to be going nowhere fast\n");
	case SOS_NBIO_ALICE_BOB_PROGRESS:
	  goto ab_cont;
	  break;
	    
	case SOS_IDENT_ALICE:
	case SOS_IDENT_BOB:
	  printf ("I will play the role of %s\n", (ret==SOS_IDENT_ALICE?"Alice":"Bob"));
	  break;
	  
	default:
	  fprintf(stderr,"Funny return value from sos_nbio_alice_bob: %d\n", ret);
	  exit (1);
	  break;
	}
      
    }

  return (ret);
  
}
