#include "sos.h"

static void do_delete(sos_config_t config);

main(int argc, char *argv[])
{
  int c;
  sos_config_t config;
  int writefile=0;
  char *wfilename=NULL;
  extern char *optarg;
  extern int optind;
  int reload=0;
  char *rfilename=NULL;
  int delete=0;
  char *concat_key=NULL;

  while ((c = getopt(argc, argv, "c:Dd:ow:rn:")) != -1)
    switch (c)
      {
      case 'w':
	writefile++;
	wfilename=strdup(optarg);
	break;

      case 'c':
	concat_key = strdup(optarg);
	break;

      case 'o': 	/* Overwrite the existing file. */
	writefile++;
	break;

      case 'r':
	reload++;
	break;

      case 'D':
	delete++;
	break;

      case 'n':
	reload++;
	rfilename=strdup(optarg);
	break;

      case 'd':
	sos_debug_set("sos_config", atoi(optarg));
	sos_debug_set("sos_fun", 3);
	sos_debug_set("sos_error", 3);
	sos_debug_info(stderr,0);
	printf ("Setting debug level to: %d\n", atoi(optarg));
	break;

      default :
	printf("Usage: %s [-do] [-w newfile] configfile\n",argv[0]);
	exit(1);
	break;
      }


  if ( (config = sos_config_read(argv[optind])) == NULL )
    {
      fprintf(stderr, "Error reading config file\n");
      exit (1);
    }
  sos_config_print(config);

  if ( concat_key )
      printf("%s\n", sos_config_concat_key(config, concat_key, " ",
					   SOS_CONFIG_NULL));

  if ( delete )
    do_delete(config);

  (void)getchar();


  if ( writefile )
    {
      if ( sos_config_write_file(config, wfilename) < 0 )
	{
	  fprintf(stderr,"%s: Error writing newfile\n", argv[0]);
	  exit (1);
	}
    }


  if ( reload )
    {

      if ( !rfilename )
	{
	  config=sos_config_reload(config,NULL);
	}
      else
	{
	  config=sos_config_reload(config,rfilename);
	}

      if ( !config )
	{
	  fprintf(stderr,"Error reading config file\n");
	}

      sos_config_print(config);
    }
  exit (0);

}

void do_delete(sos_config_t config)
{
  sos_string *data;
  char *line;
  sos_config_key key;

 again:
  data=sos_allocstr(NULL, 255);

  printf("From which  key do you wish to delete: ");
  sos_readline(stdin,stdout,data, NULL);

  line=data->str;

  sos_rip(line);

  if ( SOS_STREQ("",line))
    return;

  key=strdup(line);

  printf("Which value do you wish to delete: ");
  sos_readline(stdin,stdout,data, NULL);

  line=data->str;
  sos_rip(line);

  if ( SOS_STREQ(line, "all") )
    {
      sos_config_delete_key(config, key);
    }
  else
    {
      printf("Deleting *%s* from *%s*\n", line, key);
      config->key_list=sos_config_delete_value(config, key, line);
    }

  sos_config_print(config);

  free (data->str);
  free (key);
  free(line);

  goto again;
}
