#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Test event queue
 */

#include "sos.h"

void stdrule(void *seconds);
void exitrule(void *info);


int requeue=0;
pq_h queue;

main(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int c;
  int e = 20;
  int t[] = { 1, 5, 10, 15, 60, 300, 0 };
  int tmp;

  queue = sos_event_createq();

  while ((c = getopt(argc, argv, "re:")) != -1)
    switch (c)
      {
      case 'e':
	e = atoi(optarg);
	break;
      case 'r':
	requeue = 1;
	break;
      default :
	printf("Usage: %s \n",argv[0]);
	exit(1);
	break;
      }

  for (tmp=0;t[tmp];tmp++)
    sos_event_enqueue(queue, time(NULL)+t[tmp], stdrule, &(t[tmp]), NULL);

  sos_event_enqueue(queue, time(NULL)+e, exitrule, "EUREKA!!", NULL);

  while (tmp = sos_event_check(queue))
    {
      if (tmp < 0)
	abort();

      sleep(tmp);
    }

  exit(0);
}

void stdrule(void *seconds)
{
  int *sec = seconds;

  printf("Rule %05d fired at %d\n",*sec,time(NULL));
  if (requeue)
    sos_event_enqueue(queue, time(NULL)+*sec,stdrule, seconds, NULL);
}

void exitrule(void *info)
{
  char *i = info;

  printf("Bye Bye (%s)\n",i);
  exit(1);
}
