#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Stupid path name utilities. Why aren't these supported everwhere????
 */

#include "sos.h"

main(int argc, char *argv[])
{
  int c;
  extern char *optarg;
  extern int optind;
  int basename=0;
  int dirname=0;
  char *filename=NULL;

  while ((c = getopt(argc, argv, "d:bp")) != -1)
    switch (c)
      {
      case 'b':
	basename++;
	break;

      case 'p': 	/* Overwrite the existing file. */
	dirname++;
	break;
	
      case 'd': 
	sos_debug_set("sos_config", atoi(optarg));
	sos_debug_set("sos_fun", 3);
	sos_debug_set("sos_pathutils", 3);
	sos_debug_info(stderr,0);
	printf ("Setting debug level to: %d\n", atoi(optarg));
	break;

      default :
	printf("Usage: %s [-do] [-w newfile] configfile\n",argv[0]);
	exit(1);
	break;
      }

  filename=argv[optind];

  if (basename)
    printf("Basename of %s: **%s**\n", filename, sos_pathutils_basename(filename));

  if (dirname)
    printf("Dirname of %s: **%s**\n", filename, sos_pathutils_dirname(filename));

  exit (0);
	   
}
