#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "$Id$";
static char sos__copyright[] = "Copyright (c) 1994, 1995, 1996 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995, 1996 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Test XDR routines
 */

#include "sos.h"

int tint;
long tlong;
short tshort;
char *tstring;
sos_string tbuffer;
char tchar;
int tint1;
long tlong1;
short tshort1;
char *tstring1;
sos_string tbuffer1;
sos_quad_t tquad;
char *tquadp;
char tchar1;
int port=2332;

void client(char *, int, int);
void server(int,int);


main(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int c;
  int testappend=0;
  int testprepend=0;

#if _WIN32
  if (sosnt_initialize() < 0) {
    printf("failed to initialize winsock!\n");
    exit(1);
  }
#endif /* _WIN32 */

  while ((c = getopt(argc, argv, "d:a:rt:p:P:")) != -1)
    switch (c)
      {
      case 'r':
	server(testappend,testprepend);
	break;

      case 't':			/* This argument must go last! */
	client(optarg, testappend, testprepend);
	break;

      case 'p':
	port = atoi(optarg);
	break;

      case 'a':
	testappend = atoi(optarg);
	break;

      case 'P':
	testprepend=atoi(optarg);
	break;

      case 'd':
	sos_debug_set("sos_xdr", atoi(optarg));
	sos_debug_set("sos_fun", 0);
	sos_debug_set("sos_error",1);
	sos_debug_info(stderr,0);
	printf ("Setting debug level to: %d\n", atoi(optarg));
	break;

      default :
	printf("Usage: %s -r|-t server\n",argv[0]);
	exit(1);
	break;
      }
  exit(0);
}


void
client(char *server, int testappend, int testprepend)
{
  int s;			/* socket */
  struct sockaddr_in saddr;	/* Server addr */
  struct hostent *servhent;	/* Hostent */
  int i;			/* Dumb counter */
  sos_string buf;		/* For use in append mode */
  sos_string *tmpbuf;
  int argcount=0;
  char *curloc;			/* Curent peek location */
  int error=0;

  tint = 2323;
  tlong = -17;
  tshort = 124;
#ifdef _WIN32
  tquad = 0x8040201008040201;
#else
# ifndef SOS_QUAD_IS_LONG
  tquad = 0x8040201008040201LL;
# else /*  SOS_QUAD_IS_LONG */
  tquad = 0x08040201L;
# endif /* SOS_QUAD_IS_LONG */
#endif /* _WIN32 */

  tstring = strdup("This is a null terminated test string");
  tbuffer.len = 1024;
  tchar = '[';

#if 0
  srandom (getpid());
#endif
  tbuffer.str = (char *)malloc(tbuffer.len);
  for (i=1; i <= 1021; i++)
    tbuffer.str[i]=(char)((i%64)+64);
#if 0
    tbuffer.str[i]=(char)rint((double)random() / (double)MAXLONG * 256.0);
#endif
  tbuffer.str[0]='*';
  tbuffer.str[1021]='%';
  tbuffer.str[1022]='*';
  tbuffer.str[1023]='/';


  /* NO ERROR CHECKING !! :-) */
  if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    {
      perror("socket");
      exit(5);
    }
  else
    fprintf(stderr, "socket ok. returns %d\n", s);

  servhent = sos_gethbyfoo(server);

  memset ((char *)&saddr, (char)0, sizeof(saddr));
  saddr.sin_family = AF_INET;
  saddr.sin_port = SOS_HTONS(port);
  memcpy((caddr_t)&(saddr.sin_addr.s_addr),
	 (caddr_t)(servhent->h_addr_list[0]),
	 sizeof(servhent->h_addr_list[0]));

  if ((connect(s, (struct sockaddr *)&saddr, sizeof(saddr))) < 0)
    {
      perror("connect");
      exit(5);
    }
  else
    fprintf(stderr, "connect ok\n");

  if ( ! (testappend || testprepend) )
    {
      if ( sos_xdr_wencode(s, sosBIOwrite, "ilsScBq",
			   tint,
			   tlong,
			   tshort,
			   tstring,
			   tchar,
			   &tbuffer,
			   tquad
			   ) == -1 )
	{
	  fprintf(stderr,"client: sos_xdr_wencode() failed\n");
	  return;
	}
    }
  else
    {
      int loopcount=0;
      tmpbuf = sos_xdr_sencode("ilsScBq",
			       tint,
			       tlong,
			       tshort,
			       tstring,
			       tchar,
			       &tbuffer,
			       tquad);

      buf.len = tmpbuf->len;
      if ( (buf.str = (char *) malloc (buf.len)) == NULL )
	{
	  perror("main(): sos string malloc");
	  exit(1);
	}

      memcpy (buf.str, tmpbuf->str, buf.len);

      (void)sos_xdr_freebuf();	/* It's now safe since we copied */


    do_both:
      do {
	loopcount=(testappend)?testappend:testprepend;


	tint++;
	tlong++;
	tshort++;
	tquad++;
	tstring = strdup("This is another null terminated test string");
	/* We'll keep the same buffer */
	tchar++;

	if ( testappend )
	  {
	    if ( sos_xdr_sappend(&buf, "ilsScBq",
				 tint,
				 tlong,
				 tshort,
				 tstring,
				 tchar,
				 &tbuffer,
				 tquad) == NULL )
	      {
		fprintf(stderr,"main(): Error in sappend: Exiting\n");
		exit(1);
	      }
	    testappend--;
	  }
	else
	  {
	    if ( sos_xdr_sprepend(&buf, "ilsScBq",
				 tint,
				 tlong,
				 tshort,
				 tstring,
				 tchar,
				 &tbuffer,
				 tquad) == NULL )
	      {
		fprintf(stderr,"main(): Error in sprepend: Exiting\n");
		exit(1);
	      }
	    testprepend--;
	  }
	   
	loopcount--;
      } while (loopcount);
     
      if ( testappend || testprepend ) goto do_both;


      printf("*******************  WORK DONE CHECKING ********************\n");

      curloc = NULL;
/* XXX NEED TO MAKE PEEK DO ARGCOUNT AND LENGTH FOR ANY MEANINGFUL WORK */
      i=0;
      do {
	error =sos_xdr_speek(&buf,&curloc,"ilsScBq",
			     &tint,
			     &tlong,
			     &tshort,
			     &tstring,
			     &tchar,
			     &tbuffer,
			     &tquad);

	if (error == -1 ) break;

	if ( !error )
	  {
	    printf("A PERFECT CHECKSUM\n");
	    break;
	  }

	printf("**************** LOOP: %d *******************\n",i);
	i++;


	printf("Int: %d\nLong: %d\nShort: %d\nString: **%s**\nBuffer(%d): **%s**\nChar: %c\n",
	       tint,
	       tlong,
	       tshort,
	       tstring,
	       tbuffer.len,
	       tbuffer.str);

#ifndef SOS_QUAD_IS_LONG
	tquadp=(char *)&tquad;

	printf ("quad: %02x %02x %02x %02x %02x %02x %02x %02x\n",
		tquadp[0],
		tquadp[1],
		tquadp[2],
		tquadp[3],
		tquadp[4],
		tquadp[5],
		tquadp[6],
		tquadp[7]);

#else /* SOS_QUAD_IS_LONG */
	printf("quad: %ld\n", tquad);
#endif /* SOS_QUAD_IS_LONG */


      } while (1);

      if ( sos_xdr_wencode(s, sosBIOwrite, "B", &buf, sosBIOwrite) < 0 )
	{
	  fprintf(stderr,"Error writing buffer to network\n");
	  exit (1);
	}
    } /* END of IF */

  /* close socket (so it flushes socket buffers under NT */
  if (close(s) < 0) {
    perror("close socket");
    exit(5);
  }

  return;
}


void
server(int testappend,int testprepend)
{

  int s;			/* Socket */
  int child;			/* Socket */
  struct sockaddr_in sock;	/* My name. */
  int len;			/* Length of socket */
  int foo;
  int i;
  int error;
  sos_buffer buffer;
  char *curloc=NULL;

  if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    {
      perror("socket");
      exit(5);
    }
  else
    {
      printf("got socket number %d back.\n", s);
    }

  len = sizeof (sock);
  memset((char *)&sock, 0, sizeof(sock));
  sock.sin_family = AF_INET;
  sock.sin_port = SOS_HTONS(port);
  sock.sin_addr.s_addr = INADDR_ANY;

  if (bind (s, (struct sockaddr *)&sock, len) < 0)
    {
#ifdef _WIN32
      fprintf(stderr, "WSAGetLastError %d\n", WSAGetLastError());
#else
      perror("bind");
#endif /* _WIN32 */
      exit(5);
    }

  if (listen(s, 5) < 0)
    {
      perror("listen");
      exit(5);
    }

  memset((char *)&sock, (char )0, sizeof(sock));
  if ((child  = accept (s, (struct sockaddr *)&sock, (int *)&len)) < 0)
    {
      perror("bind");
      exit(5);
    }
  fprintf(stderr,"Acceptance is nice\n");

  if (!(testappend | testprepend))
    {

      if ((foo = sos_xdr_wdecode(child, sosBIOread, "ilsScBq",
				 &tint,
				 &tlong,
				 &tshort,
				 &tstring,
				 &tchar,
				 &tbuffer,
				 &tquad
				 )) != 7 )
	{
	  fprintf(stderr,"server: sos_xdr_wdecode(%d) failed\n",foo);
	  return;
	}

      printf("*********** Server output *************\n");
      printf("Int: %d\nLong: %d\nShort: %d\nString: **%s**\nBuffer(%d): **%s**\nChar: %c\n",
	     tint,
	     tlong,
	     tshort,
	     tstring,
	     tbuffer.len,
	     tbuffer.str,
	     tchar);


#ifndef SOS_QUAD_IS_LONG
	tquadp=(char *)&tquad;

	printf ("quad: %02x %02x %02x %02x %02x %02x %02x %02x\n",
		tquadp[0],
		tquadp[1],
		tquadp[2],
		tquadp[3],
		tquadp[4],
		tquadp[5],
		tquadp[6],
		tquadp[7]);

#else /* SOS_QUAD_IS_LONG */
	printf("quad: %ld\n", tquad);
#endif /* SOS_QUAD_IS_LONG */

      (void)sos_xdr_freebuf();
    }
  else
    {
      if ( (foo = sos_xdr_wdecode(child, sosBIOread, "B", &buffer)) !=1 )
	{
	  fprintf(stderr,"server: sos_xdr_wdecode(%d) failed\n",foo);
	  return;
	}

      i=0;
      do {
	i++;
	printf("**************** LOOP: %d *******************\n",i);
	error =sos_xdr_speek(&buffer,&curloc,"ilsScBq",
			     &tint,
			     &tlong,
			     &tshort,
			     &tstring,
			     &tchar,
			     &tbuffer,
			     &tquad);

	if (error == -1 ) break;

	if ( !error )
	  {
	    printf("A PERFECT CHECKSUM\n");
	    break;
	  }

	printf("Int: %d\nLong: %d\nShort: %d\nString: **%s**\nBuffer(%d): **%s**\nChar: %c\n",
	       tint,
	       tlong,
	       tshort,
	       tstring,
	       tbuffer.len,
	       tbuffer.str);

#ifndef SOS_QUAD_IS_LONG
	tquadp=(char *)&tquad;

	printf ("quad: %02x %02x %02x %02x %02x %02x %02x %02x\n",
		tquadp[0],
		tquadp[1],
		tquadp[2],
		tquadp[3],
		tquadp[4],
		tquadp[5],
		tquadp[6],
		tquadp[7]);

#else /* SOS_QUAD_IS_LONG */
	printf("quad: %ld\n", tquad);
#endif /* SOS_QUAD_IS_LONG */
      } while (1);


    }
  return;

}
